import math
import array
import struct
import sta_globals
import random

from OpenGL.GL import *
from OpenGL.GLUT import *
from OpenGL.GLU import *

#==============================================================================================
#																			Texture profiles   
#==============================================================================================
TEXSZ = 64			# texture sampling

texture1 = array.array('f')	# Texture for 1D cushion
texture2 = array.array('f')	# Texture for 2D cushion

#-----------------------------------------------------------------------------------------------
#																1D profiles - geometry cushions 
#-----------------------------------------------------------------------------------------------
def profile1D_01(x,D,h,alpha,l_ratio):
	pi = math.pi
	alpha = float(pi*alpha)/180

	a = - float(4*h)/(D*D)
	b= float(4*h)/D
	r = -(2.0*a*x+b)*math.cos(alpha)+math.sin(alpha)
	r= float(r)/math.pow(4*a*a*x*x+4*a*b*x+b*b+1,0.5)
	if (r>1):
	   r=1
	return (r*l_ratio)

#-----------------------------------------------------------------------------------------------
#																2D profiles - geometry cushions 
#-----------------------------------------------------------------------------------------------

#------------------------------------------------------------------------------------ Pillow ---
def profile2D_01(x,y,D,h,alpha,l_ratio):
	pi = math.pi
	alpha = float(pi*alpha)/180

	a= - float(4*h)/(D*D)
	b= float(4*h)/D
	r1 = -(2.0*a*x+b)*math.cos(alpha)+math.sin(alpha)	
	r1= float(r1)/math.pow(4*a*a*x*x+4*a*b*x+b*b+1,0.5)
	if (r1>1):
	   r1=1
	   
	r2 = math.sqrt(1-(2*y-1)*(2*y-1))	
	if (r2>1):
	   r2=1
	   	
	return (r1*r2*l_ratio)

#---------------------------------------------------------------------------- Fading in bar ---
def profile2D_02(x,y,D,h,alpha,l_ratio):
       
        global TEXSZ
	
	pi = math.pi
	alpha = float(pi*alpha)/180

	a = - float(4*h)/(D*D)
	b= float(4*h)/D
	r = -(2.0*a*x+b)*math.cos(alpha)+math.sin(alpha)
	r= float(r)/math.pow(4*a*a*x*x+4*a*b*x+b*b+1,0.5)
	if (r>1):
	   r=1   
	
	return 1+y*(r-1)
	 
	
#--------------------------------------------------------------------------- Fading out bar ---
def profile2D_03(x,y,D,h,alpha,l_ratio):

	pi = math.pi
	alpha = float(pi*alpha)/180

	a = - float(4*h)/(D*D)
	b= float(4*h)/D
	r = -(2.0*a*x+b)*math.cos(alpha)+math.sin(alpha)
	r= float(r)/math.pow(4*a*a*x*x+4*a*b*x+b*b+1,0.5)
	if (r>1):
	   r=1   

	return 1+(1-y)*(r-1)

#------------------------------------------------------------------------------------ Image ---
def profile2D_04(l_sFile,l_ratio):
 
  	global texture2
  	
  	fileHandle = open(l_sFile,'rb')  	
  	bRaw = fileHandle.read()
  	fileHandle.close()
  	
  	iSize = len(bRaw)/3
  	for i in range(iSize):
  	   fValue  = (float((struct.unpack('B',bRaw[i*3]))[0])/255)*l_ratio + 1 - l_ratio  	   
  	   texture2.append(fValue)

#-------------------------------------------------------------------------------------- Bar ---
def profile2D_05(l_ratio):
  	global texture2
  	
  	for i in range(TEXSZ):
  	   for j in range(TEXSZ): 	
  	       texture2.append(l_ratio)
  	       
#----------------------------------------------------------------------------------- Circle ---
def profile2D_06(h,alpha,l_ratio):
  	
  	global texture2
  	global TEXSZ
  	
  	pi = math.pi
	alpha = float(pi*alpha)/180
	fRadius = float(TEXSZ)/2
	
	D = TEXSZ
	h = float(h*TEXSZ)  	
	a = - float(4*h)/(D*D)
	b= float(4*h)/D  	 	
  	
  	for i in range(TEXSZ):
  	   for j in range(TEXSZ): 	
  	       x = fRadius-math.sqrt((i-fRadius)*(i-fRadius)+(j-fRadius)*(j-fRadius))
  	       r = -(2.0*a*x+b)*math.cos(alpha)+math.sin(alpha)
	       r= float(r)/math.pow(4*a*a*x*x+4*a*b*x+b*b+1,0.5)
	       if (r>1):
	          r=1  	       
  	       texture2.append(l_ratio*r)

#==============================================================================================
#									Generate textures
#==============================================================================================

#----------------------------------------------------------------------------------------------
#								Bar 1D (Geometry cushion)
#----------------------------------------------------------------------------------------------
def gtexBar1D(cCushion,layer,l_height,angle,l_ratio):	

  global TEXSZ
  global texture1  

  glBindTexture(GL_TEXTURE_1D,cCushion.tex[layer])	
  del texture1[:]
  for i in range(TEXSZ):
  	texture1.append(profile1D_01(i,TEXSZ,float(l_height*TEXSZ),angle,l_ratio))
  	   
  glEnable(GL_TEXTURE_1D)
  glTexParameteri(GL_TEXTURE_1D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
  glTexParameteri(GL_TEXTURE_1D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
  
  glTexImage1D(GL_TEXTURE_1D,0,GL_ALPHA,TEXSZ,0,GL_ALPHA,GL_FLOAT,texture1.tostring())

  glDisable(GL_TEXTURE_1D)

#----------------------------------------------------------------------------------------------
#																Pillow 2D (Geometry cushion)   
#----------------------------------------------------------------------------------------------
def gtexPillow2D(cCushion,layer,l_mode,l_height,angle,l_ratio):

  global TEXSZ  
  global texture2  

  glBindTexture(GL_TEXTURE_2D,cCushion.tex[layer])	
  del texture2[:]  
  #-------------------------------------------------------------
  if l_mode==1:  		# pillow
     for i in range(TEXSZ):
        for j in range(TEXSZ):
           texture2.append(profile2D_01(i,float(j)/TEXSZ,TEXSZ,float(l_height)*TEXSZ,angle,l_ratio))  
  elif l_mode==2:		# fade-in
     for i in range(TEXSZ):
        for j in range(TEXSZ):
           texture2.append(profile2D_02(i,float(j)/TEXSZ,TEXSZ,float(l_height)*TEXSZ,angle,l_ratio))
  else:
     for i in range(TEXSZ):	# fade-out
        for j in range(TEXSZ):
           texture2.append(profile2D_03(i,float(j)/TEXSZ,TEXSZ,float(l_height)*TEXSZ,angle,l_ratio))

  #-------------------------------------------------------------
  glEnable(GL_TEXTURE_2D)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT)
  
  glTexImage2D(GL_TEXTURE_2D,0,GL_ALPHA,TEXSZ,TEXSZ,0,GL_ALPHA,GL_FLOAT,texture2.tostring())

  glDisable(GL_TEXTURE_2D)

#----------------------------------------------------------------------------------------------
#																			2D image cushion   
#----------------------------------------------------------------------------------------------
def gtexImage2D(cCushion,layer,l_sFile,l_ratio):

  global TEXSZ  
  global texture2  

  glBindTexture(GL_TEXTURE_2D,cCushion.tex[layer])	
  del texture2[:]  
  #-------------------------------------------------------------  
  profile2D_04(l_sFile,1-l_ratio)
  #-------------------------------------------------------------
  
  glEnable(GL_TEXTURE_2D)  
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR)
  #glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT)
  
  #glTexImage2D(GL_TEXTURE_2D,0,GL_ALPHA,TEXSZ,TEXSZ,0,GL_ALPHA,GL_FLOAT,texture2.tostring())  
  
  gluBuild2DMipmaps( GL_TEXTURE_2D, GL_ALPHA, TEXSZ, TEXSZ, GL_ALPHA, GL_FLOAT, texture2.tostring())
  

  glDisable(GL_TEXTURE_2D)

#----------------------------------------------------------------------------------------------
#																		Circle 2D (for corners)
#----------------------------------------------------------------------------------------------
def gtexCircle2D(cCushion,layer,l_height,angle,l_ratio):

  global TEXSZ  
  global texture2  

  glBindTexture(GL_TEXTURE_2D,cCushion.tex[layer])	
  del texture2[:]  
  #-------------------------------------------------------------  
  profile2D_06(l_height,angle,l_ratio)
  #-------------------------------------------------------------
  glEnable(GL_TEXTURE_2D)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP)
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP)
  
  glTexImage2D(GL_TEXTURE_2D,0,GL_ALPHA,TEXSZ,TEXSZ,0,GL_ALPHA,GL_FLOAT,texture2.tostring())

  glDisable(GL_TEXTURE_2D)


#----------------------------------------------------------------------------------------------
#								First time load cushions
#----------------------------------------------------------------------------------------------
def generateMainTextures(cCushion):
    
  cCushion.tex = glGenTextures(19)
  
  #----------------------------------------------------------------------------------------------
  gtexBar1D(cCushion,0,sta_globals.fCushionHeight,sta_globals.iCushionLight,0.6)  	# generate 1D texture (Level 1)
  gtexBar1D(cCushion,2,sta_globals.fCushionHeight,sta_globals.iCushionLight,1)  	# generate 1D texture (Level 0) 
  
  gtexPillow2D(cCushion,4,1,sta_globals.fCushionHeight,sta_globals.iCushionLight,0.4) # generate pillow 2D texture (Level 2)
   
  gtexBar1D(cCushion,9,0.70,90,1)		  			# generate 1D texture for clusters
  gtexCircle2D(cCushion,12,0.70,90,1)				# Circle for corners
  
  # Images
  gtexImage2D(cCushion,18,sta_globals.sMarkerName,0)			# Density marker image
  
  #----------------------------------------------------------------------------------------------   

def generateHorizontalTextures(cCushion):
   
   cCushion.tex = glGenTextures(2)					# make 1 tex-names
   
   gtexBar1D(cCushion,0,sta_globals.fCushionHeight,sta_globals.iCushionLight,1)  	# generate 1D texture (Level 0) 

def generateClusterTextures(cCushion):
   
   cCushion.tex = glGenTextures(2)					# make 1 tex-names
   
   gtexBar1D(cCushion,0,sta_globals.fCushionHeight,sta_globals.iCushionLight,1)  	# generate 1D texture (Level 0) 

def generateFileTextures(cCushion):
   
   cCushion.tex = glGenTextures(2)					# make 1 tex-names
   
   gtexBar1D(cCushion,0,sta_globals.fCushionHeight,sta_globals.iCushionLight,1)  	# generate 1D texture (Level 0) 

#==============================================================================================
#								Draw file cushions
#==============================================================================================

#----------------------------------------------------------------- Draw vertical cushion 1D ---
def drawCushion1DV(startx,starty,endx,endy,cCushion,l_tex,enabled):  	

	if (enabled):						# draw cushion in the alpha-channel	
		glBindTexture(GL_TEXTURE_1D,cCushion.tex[l_tex])		
		glEnable(GL_TEXTURE_1D)	
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)

		glBegin(GL_QUADS)
		glTexCoord1i(0)
		glVertex2i(startx,starty)
		glTexCoord1i(1)
		glVertex2i(endx,starty)
		glTexCoord1i(1)
		glVertex2i(endx,endy)
		glTexCoord1i(0)
		glVertex2i(startx,endy)
		glEnd()

		glDisable(GL_TEXTURE_1D)
	else:							# draw surrogate in the alpha-channel			
		glColor4f(1,1,1,1)
		glRectf(startx,starty,endx,endy)

#---------------------------------------------------------------- Draw horizontal cushion 1D ---
def drawCushion1DH(startx,starty,endx,endy,cCushion,l_tex,enabled):
  	

	startx = int(startx)
	starty = int(starty)
	endx = int(endx)
	endy = int(endy)
	
	if (enabled):						# draw cushion in the alpha-channel	
		glBindTexture(GL_TEXTURE_1D,cCushion.tex[l_tex])		
		glEnable(GL_TEXTURE_1D)
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)

		glBegin(GL_QUADS)
		glTexCoord1i(0)
		glVertex2i(startx,starty)
		glTexCoord1i(0)
		glVertex2i(endx,starty)
		glTexCoord1i(1)
		glVertex2i(endx,endy)
		glTexCoord1i(1)
		glVertex2i(startx,endy)
		glEnd()

		glDisable(GL_TEXTURE_1D)		
		
	else:							# draw surrogate in the alpha-channel			
		glColor4f(1,1,1,1)
		glRectf(startx,starty,endx,endy)
		
#-------------------------------------------------------------------------- Draw cushion 2D ---
def drawCushion2D(startx,starty,endx,endy,cCushion,l_tex,enabled):
  	

	if (enabled):						# draw cushion in the alpha-channel	
		glBindTexture(GL_TEXTURE_2D,cCushion.tex[l_tex])
		glEnable(GL_TEXTURE_2D)
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)

		glBegin(GL_QUADS)
		glTexCoord2i(0,0)
		glVertex2f(startx,starty)
		glTexCoord2i(1,0)
		glVertex2f(endx,starty)
		glTexCoord2i(1,1)
		glVertex2f(endx,endy)
		glTexCoord2i(0,1)
		glVertex2f(startx,endy)
		glEnd()

		glDisable(GL_TEXTURE_2D)

	else:							# draw surrogate in the alpha-channel			
		glColor4f(1,1,1,0.6)
		glRectf(startx,starty,endx,endy)		

#==============================================================================================
#																		Draw cluster cushions  
#==============================================================================================
		
def drawCluster2D(startx,starty,endx,endy,fUnitX,fUnitY,cCushion):

  			
	fMaxGrowthX 	= sta_globals.iNrPixelsClusterEdge * fUnitX
	fMaxGrowthY 	= sta_globals.iNrPixelsClusterEdge * fUnitY	
	fWidthY		= float(endy - starty)		
	fWidthX		= float(endx - startx)
		
	#-------------------------------------- make the cushion a plateau ---
	if (fWidthY>2*fMaxGrowthY) and (fWidthX>2*fMaxGrowthX):
	
		glBindTexture(GL_TEXTURE_1D,cCushion.tex[9])		
		glEnable(GL_TEXTURE_1D)	
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)
		
		#================================================================
		
		#------------------------ top ---
		glBegin(GL_QUADS)
		glTexCoord1f(0.5)
		glVertex2f(startx+fMaxGrowthX,starty+fMaxGrowthY)
		glTexCoord1f(0)
		glVertex2f(startx+fMaxGrowthX,starty)			
		glTexCoord1f(0)
		glVertex2f(endx-fMaxGrowthX,starty)
		glTexCoord1f(0.5)
		glVertex2f(endx-fMaxGrowthX,starty+fMaxGrowthY)
		glEnd()
		
		#--------------------- bottom ---
		glBegin(GL_QUADS)
		glTexCoord1f(1)
		glVertex2f(startx+fMaxGrowthX,endy)
		glTexCoord1f(0.5)
		glVertex2f(startx+fMaxGrowthX,endy-fMaxGrowthY)			
		glTexCoord1f(0.5)
		glVertex2f(endx-fMaxGrowthX,endy-fMaxGrowthY)
		glTexCoord1f(1)
		glVertex2f(endx-fMaxGrowthX,endy)										
		glEnd()
		
		#----------------------- left ---
		glBegin(GL_QUADS)
		glTexCoord1f(0)
		glVertex2f(startx,endy-fMaxGrowthY)
		glTexCoord1f(0)
		glVertex2f(startx,starty+fMaxGrowthY)			
		glTexCoord1f(0.5)
		glVertex2f(startx+fMaxGrowthX,starty+fMaxGrowthY)
		glTexCoord1f(0.5)
		glVertex2f(startx+fMaxGrowthX,endy-fMaxGrowthY)
		glEnd()
		
		#---------------------- right ---
		glBegin(GL_QUADS)
		glTexCoord1f(0.5)
		glVertex2f(endx-fMaxGrowthX,endy-fMaxGrowthY)
		glTexCoord1f(0.5)
		glVertex2f(endx-fMaxGrowthX,starty+fMaxGrowthY)			
		glTexCoord1f(1)
		glVertex2f(endx,starty+fMaxGrowthY)
		glTexCoord1f(1)
		glVertex2f(endx,endy-fMaxGrowthY)
		glEnd()
		
		#================================================================
		glDisable(GL_TEXTURE_1D)
		
		glBindTexture(GL_TEXTURE_2D,cCushion.tex[12])		
		glEnable(GL_TEXTURE_2D)	
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)
		#================================================================
		
		#------------------- top left ---
		glBegin(GL_QUADS)
		glTexCoord2f(0,0.5)
		glVertex2f(startx,starty+fMaxGrowthY)
		glTexCoord2f(0,1)
		glVertex2f(startx,starty)		
		glTexCoord2f(0.5,1)
		glVertex2f(startx+fMaxGrowthX,starty)
		glTexCoord2f(0.5,0.5)
		glVertex2f(startx+fMaxGrowthX,starty+fMaxGrowthY)
		glEnd()	
		
		#------------------ top right ---
		glBegin(GL_QUADS)
		glTexCoord2f(0.5,0.5)
		glVertex2f(endx-fMaxGrowthX,starty+fMaxGrowthY)
		glTexCoord2f(0.5,1)
		glVertex2f(endx-fMaxGrowthX,starty)		
		glTexCoord2f(1,1)
		glVertex2f(endx,starty)
		glTexCoord2f(1,0.5)
		glVertex2f(endx,starty+fMaxGrowthY)
		glEnd()	
		
		#--------------- bottom right ---
		glBegin(GL_QUADS)
		glTexCoord2f(0.5,0)
		glVertex2f(endx-fMaxGrowthX,endy)
		glTexCoord2f(0.5,0.5)
		glVertex2f(endx-fMaxGrowthX,endy-fMaxGrowthY)		
		glTexCoord2f(1,0.5)
		glVertex2f(endx,endy-fMaxGrowthY)
		glTexCoord2f(1,0)
		glVertex2f(endx,endy)
		glEnd()
		
		#--------------- bottom left ---
		glBegin(GL_QUADS)
		glTexCoord2f(0,0)
		glVertex2f(startx,endy)
		glTexCoord2f(0,0.5)
		glVertex2f(startx,endy-fMaxGrowthY)		
		glTexCoord2f(0.5,0.5)
		glVertex2f(startx+fMaxGrowthX,endy-fMaxGrowthY)
		glTexCoord2f(0.5,0)
		glVertex2f(startx+fMaxGrowthX,endy)
		glEnd()
		
		#================================================================	
		glDisable(GL_TEXTURE_2D)
		
	#----------------------------------- keep the cushion unchanged on Y ---
	elif (fWidthX>2*fMaxGrowthX):			
		glBindTexture(GL_TEXTURE_1D,cCushion.tex[9])		
		glEnable(GL_TEXTURE_1D)	
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)
		
		#================================================================
		glBegin(GL_QUADS)
		glTexCoord1i(0)
		glVertex2f(startx+fMaxGrowthX,starty)
		glTexCoord1i(1)
		glVertex2f(startx+fMaxGrowthX,endy)		
		glTexCoord1i(1)
		glVertex2f(endx-fMaxGrowthX,endy)
		glTexCoord1i(0)
		glVertex2f(endx-fMaxGrowthX,starty)
		glEnd()			
		#================================================================
		glDisable(GL_TEXTURE_1D)
		
		glBindTexture(GL_TEXTURE_2D,cCushion.tex[12])		
		glEnable(GL_TEXTURE_2D)	
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)
		#================================================================
		#------------------ left ---
		glBegin(GL_QUADS)
		glTexCoord2f(0,0)
		glVertex2f(startx,endy)
		glTexCoord2f(0,1)
		glVertex2f(startx,starty)		
		glTexCoord2f(0.5,1)
		glVertex2f(startx+fMaxGrowthX,starty)
		glTexCoord2f(0.5,0)
		glVertex2f(startx+fMaxGrowthX,endy)
		glEnd()	
		
		#------------------ right ---
		glBegin(GL_QUADS)
		glTexCoord2f(0.5,0)
		glVertex2f(endx-fMaxGrowthX,endy)
		glTexCoord2f(0.5,1)
		glVertex2f(endx-fMaxGrowthX,starty)		
		glTexCoord2f(1,1)
		glVertex2f(endx,starty)
		glTexCoord2f(1,0)
		glVertex2f(endx,endy)
		glEnd()	
		
		#================================================================	
		glDisable(GL_TEXTURE_2D)		
		
	#----------------------------------- keep the cushion unchanged on X ---
	elif (fWidthY>2*fMaxGrowthY):			
		glBindTexture(GL_TEXTURE_1D,cCushion.tex[9])		
		glEnable(GL_TEXTURE_1D)	
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)
		
		#================================================================
		glBegin(GL_QUADS)
		glTexCoord1i(0)
		glVertex2f(startx,starty+fMaxGrowthY)
		glTexCoord1i(0)
		glVertex2f(startx,endy-fMaxGrowthY)		
		glTexCoord1i(1)
		glVertex2f(endx,endy-fMaxGrowthY)
		glTexCoord1i(1)
		glVertex2f(endx,starty+fMaxGrowthY)
		glEnd()			
		#================================================================
		glDisable(GL_TEXTURE_1D)
		
		glBindTexture(GL_TEXTURE_2D,cCushion.tex[12])		
		glEnable(GL_TEXTURE_2D)	
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)
		#================================================================		
		#------------------- top ---
		glBegin(GL_QUADS)
		glTexCoord2f(0,0.5)
		glVertex2f(startx,starty+fMaxGrowthY)
		glTexCoord2f(0,0)
		glVertex2f(startx,starty)		
		glTexCoord2f(1,0)
		glVertex2f(endx,starty)
		glTexCoord2f(1,0.5)
		glVertex2f(endx,starty+fMaxGrowthY)
		glEnd()			
		#---------------- bottom ---
		glBegin(GL_QUADS)
		glTexCoord2f(0,0)
		glVertex2f(startx,endy)
		glTexCoord2f(0,0.5)
		glVertex2f(startx,endy-fMaxGrowthY)		
		glTexCoord2f(1,0.5)
		glVertex2f(endx,endy-fMaxGrowthY)
		glTexCoord2f(1,0)
		glVertex2f(endx,endy)
		glEnd()			
		#================================================================	
		glDisable(GL_TEXTURE_2D)	
		
	#------------------------------ keep the cushion unchanged on X and Y ---
	else:
	   	glBindTexture(GL_TEXTURE_2D,cCushion.tex[12])		
		glEnable(GL_TEXTURE_2D)	
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE)
		#================================================================
		#------------------- top ---
		glBegin(GL_QUADS)
		glTexCoord2f(0,0)
		glVertex2f(startx,endy)
		glTexCoord2f(0,1)
		glVertex2f(startx,starty)		
		glTexCoord2f(1,1)
		glVertex2f(endx,starty)
		glTexCoord2f(1,0)
		glVertex2f(endx,endy)
		glEnd()		

		#================================================================	
		glDisable(GL_TEXTURE_2D)	
	
#=================================================================================
#																	Class CCushion
#=================================================================================
class CCushion:
	def __init__(self,*args,**kwds):
	   self.tex = []			# Number of textures