#! /usr/bin/python

import subprocess
import sys
import os
import ctypes.util
import base64
import codecs

CREATE_NEW_PROCESS_GROUP = 512
CTRL_C_EVENT = 0
CTRL_BREAK_EVENT = 1

# Make app independent of lauch folder
sStartPath = os.getcwd()
sTargetPath = sys.argv[0]
sTargetPath = sTargetPath.replace('\\','/')
iPos = sTargetPath.rfind('/')
if (iPos>=0):
	sTargetPath = sTargetPath[:iPos]
	os.chdir(sTargetPath)

sys.path.append('.')
sys.path.append('./sta_plugins')
sys.path.append('./Common')

import TAboutBox

#---------------------------------------------------------------
# Platform dependent instalation tweak
sPlatform = sys.platform

if (sPlatform[:3] == 'win'):
	sys.path.insert(0, os.path.join(sys.prefix, "PyOpenGL-3.0.1a3"))

#---------------------------------------------------------------
import OpenGL
OpenGL.ERROR_CHECKING = False
OpenGL.ERROR_LOGGING = False
from OpenGL.GLUT import *

import wx
import sta_gui
import sta_data
import sta_data_manip
import sta_gl
import sta_utils
import os.path
import thread
import subprocess
import ctypes
import time
import calendar
import datetime
import sta_globals
import cushions
import sta_clusters
import sys
import random
import pysvn
import urllib
import win32api, win32process, win32con, win32gui, win32event

#TODO: This are required by the external plugins and we need them here to be considered by py2exe
import wx.wizard as wiz
import urllib2
import traceback
import _winreg

import sta_plugin
import sta_metricgenerator

import sta_svn

from sta_gl						import MainCanvas
from sta_gl_mixer				import MixerCanvas_Project
from sta_gl_cluster				import ClusterCanvas
from sta_gl_horizontalmetric	import HorizontalMetricCanvas
from sta_gl_verticalmetric		import VerticalMetricCanvas

import pysqlite2.dbapi2 as sqlite

#--------------
# Demo patch. This is necessary in order to import the modules in the library upon deployment
import subprocess
import xml.sax
#--------------

#/////////////////////////////////////////////////////////////////////////////////////////
#														  				 Plug-in Engine
#/////////////////////////////////////////////////////////////////////////////////////////

l_lPluginCompatibilityList = ['1.0']
l_lPlugins = os.listdir('./sta_plugins')
print '> Loading plugins ...'

for i in l_lPlugins:

	#------------------------------------------------------- Project Plugins ---
	if (i[:4] == 'pext') and (i[-2:] == 'py'):
		l_sPluginName = i[:-3]
		exec('import '+l_sPluginName)
		exec('l_cPlugin= '+l_sPluginName+'.Plugin()')
		if l_cPlugin.sVersion in l_lPluginCompatibilityList:
			sta_globals.lPlugins_Project.append(l_cPlugin)
			print '... '+l_cPlugin.sName+' (Project)'
		else:
			print 'WARNING: Plugin '+l_cPlugin.sName+' version ' + l_cPlugin.sVersion\
					+'\n\t is incompatible with this version of SolidSTA ('+sta_globals.sVersion+')'
	#------------------------------------------------------- Cluster Plugins ---
	if (i[:4] == 'cext') and (i[-2:] == 'py'):
		l_sPluginName = i[:-3]
		exec('import '+l_sPluginName)
		exec('l_cPlugin= '+l_sPluginName+'.CClusterEngine()')
		if l_cPlugin.sVersion in l_lPluginCompatibilityList:
			sta_globals.lPlugins_Cluster.append(l_cPlugin)
			print '... '+l_cPlugin.sName+' (Cluster)'
		else:
			print 'WARNING: Plugin '+l_cPlugin.sName+' version ' + l_cPlugin.sVersion\
					+'\n\t is incompatible with this version of SolidSTA ('+sta_globals.sVersion+')'

	#---------------------------------------------- Metric Generator Plugins ---
	if (i[:4] == 'mext') and (i[-2:] == 'py'):
		l_sPluginName = i[:-3]
		exec('import '+l_sPluginName)
		exec('l_cPlugin= '+l_sPluginName+'.MetricGenerator()')

		if l_cPlugin.sVersion in l_lPluginCompatibilityList:
			sta_globals.lPlugins_MetricGenerator.append(l_cPlugin)
			print '... '+l_cPlugin.sName+' (Metric computation)'
		else:
			print 'WARNING: Plugin '+l_cPlugin.sName+' version ' + l_cPlugin.sVersion\
					+'\n\t is incompatible with this version of SolidSTA ('+sta_globals.sVersion+')'

#/////////////////////////////////////////////////////////////////////////////////////////
#																			Main Engine
#/////////////////////////////////////////////////////////////////////////////////////////
def exit_program(p_iCode):
	sta_globals.GUI.cancelTFSImporter()
	sta_globals.fileDebug.close()
	sys.exit(p_iCode)

class STA(wx.App):
	#------------------------------------------------------------------ Init ---
	def OnInit(self):

		sta_globals.GUI					= self	# Make the application global
		glutInit([])

		# Images
		wx.InitAllImageHandlers()
		sta_globals.cConnectionBmp = wx.Bitmap(sta_globals.sConnectionBmp)

		# Frames
		self.mainFrame				  	= sta_gui.CMainFrame(None, -1, "")
		self.mainFrame.SetTitle(sta_globals.sTitle)
		self.mainFrame.enableFileButtons(False)
		self.mainFrame.enableCurrentPrjButtons(False)

		self.mainFrame.RegisterPlugins()
		self.InfoDialog					= sta_gui.CInfoDialog("Version info",self.mainFrame)
		self.LogDialog					= sta_gui.CInfoDialog("Command log",self.mainFrame)
		self.OpenProjectDialog			= sta_gui.COpenProjectDialog(self,self.mainFrame)
		self.SettingsDialog				= sta_gui.CSettingsDialog(self,self.mainFrame)
		self.SettingsDialog.RegisterPlugins()
		self.ComputeMetricsDialog		= sta_gui.CComputeMetricsDialog(self,self.mainFrame)
		self.ComputeMetricsDialog.RegisterPlugins()

		# Cushions
		sta_globals.cMainCushions		= cushions.CCushion()
		sta_globals.cHorizontalCushions	= cushions.CCushion()
		sta_globals.cClusterCushions	= cushions.CCushion()

		# OpenGL windows
		self.glCanvas					= MainCanvas(self,self.mainFrame.g_panelOpenGLPrj)
		self.glVerticalCanvas			= VerticalMetricCanvas(self,self.mainFrame.panel_vertical_metric)
		self.glHorizontalCanvas			= HorizontalMetricCanvas(self,self.mainFrame.panel_horizontal_metric)
		self.glMixerCanvas_Project		= MixerCanvas_Project(self,self.mainFrame.project_blender)
		self.glClusterCanvas			= ClusterCanvas(self,self.mainFrame.panelGL_clusters)

		#Tooltips
		wx.ToolTip.Enable(True)
		self.gVerticalCanvasTip			= wx.ToolTip("Activity")
		self.glVerticalCanvas.SetToolTip(self.gVerticalCanvasTip)

		random.seed("SolidSTA")

		self.SetTopWindow(self.mainFrame)

		#----------------------------------------------------------------------
		# config
		#----------------------------------------------------------------------

		self.cPrjProgress = wx.Colour(120,120,200)				# Project progress guage color
		self.cFileInfoProgress = wx.Colour(200,120,120)			# File info progress guage color
		self.cFileClearProgress = wx.Colour(70,70,70)			# File clear progress guage color
		self.cFileContentProgress = wx.Colour(120,200,120)		# File content progress guage color

		self.cAttr1 = wx.TextAttr(wx.BLACK)
		l_cFont1 = wx.Font(8,wx.FONTFAMILY_DEFAULT,wx.FONTSTYLE_NORMAL,wx.FONTWEIGHT_NORMAL)
		self.cAttr1.SetFont(l_cFont1)
		self.cAttr1.SetBackgroundColour(wx.WHITE)

		self.cAttr2 = wx.TextAttr(wx.BLACK)
		l_cFont2 = wx.Font(8,wx.FONTFAMILY_DEFAULT,wx.FONTSTYLE_NORMAL,wx.FONTWEIGHT_BOLD)
		self.cAttr2.SetFont(l_cFont2)
		self.cAttr2.SetBackgroundColour(wx.WHITE)

		self.cAttr3 = wx.TextAttr(wx.BLACK)
		self.cAttr3.SetFont(l_cFont2)

		#----------------------------------------------------------------------
		# register callbacks
		#----------------------------------------------------------------------


		#----- Main menu
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10101)		# Open project
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10100)		# New
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10102)		# Export
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10103)		# Import
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10110)		# Exit
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10700)		# Metric generators
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10701)		# Metric generators
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10800)		# Settings
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10900)		# Help
		self.Bind(wx.EVT_MENU, self.cbMainMenu, id=10901)		# About

		#----- Projects

		self.Bind(sta_globals.EVT_CUSTOM_STA_ID,self.cbExecuteAsynch)
		self.Bind(wx.EVT_WINDOW_DESTROY, self.cbExitApp, self.mainFrame)

		self.ComputeMetricsDialog.metrics_lGenerators.Bind(wx.EVT_LISTBOX,self.cbSelectGenerator)
		self.ComputeMetricsDialog.metrics_bGenerate.Bind(wx.EVT_BUTTON,self.cbRunGenerator)
		self.ComputeMetricsDialog.metrics_lMetrics.Bind(wx.EVT_LISTBOX,self.cbSelectMetric)
		self.ComputeMetricsDialog.metrics_bRemove.Bind(wx.EVT_BUTTON,self.cbRemoveMetric)
		self.ComputeMetricsDialog.metrics_bCancel.Bind(wx.EVT_BUTTON,self.cbCancelMetric)

		self.OpenProjectDialog.g_bPrjNew.Bind(wx.EVT_BUTTON,self.cbPrjNew_1)
		self.OpenProjectDialog.g_bPrjEdit.Bind(wx.EVT_BUTTON,self.cbPrjEdit)
		self.OpenProjectDialog.g_bPrjDelete.Bind(wx.EVT_BUTTON,self.cbPrjDelete)
		self.OpenProjectDialog.g_bPrjLoad.Bind(wx.EVT_BUTTON,self.cbPrjLoad)
		self.OpenProjectDialog.g_listProjects.Bind(wx.EVT_LIST_ITEM_ACTIVATED,self.cbPrjLoad)
		self.OpenProjectDialog.g_listProjects.Bind(wx.EVT_LIST_ITEM_SELECTED, self.cbPrjListSelect)

		self.mainFrame.g_bPrjClear.Bind(wx.EVT_BUTTON,self.cbPrjClear)
		self.mainFrame.g_bPrjUpdate.Bind(wx.EVT_BUTTON,self.cbPrjUpdate)

		self.SettingsDialog.g_spinSCMRetries.Bind(wx.EVT_SPINCTRL,self.cbSCMRetries)

		# Filee tree
		self.mainFrame.g_listFiles.Bind(wx.EVT_TREE_SEL_CHANGED,self.cbFileListSelect)
		self.mainFrame.g_listFiles.Bind(wx.EVT_RIGHT_DOWN,self.cbFileListOperations)
		self.mainFrame.g_bFileClear.Bind(wx.EVT_BUTTON,self.cbFileClear)
		self.mainFrame.g_bFileUpdate.Bind(wx.EVT_BUTTON,self.cbFileUpdate)
		self.mainFrame.g_bFileCancel.Bind(wx.EVT_BUTTON,self.cbFileCancel)
		self.mainFrame.g_bFileContent.Bind(wx.EVT_BUTTON,self.cbFileContent)

		self.Bind(wx.EVT_MENU, self.cbFileUpdate, id=701)
		self.Bind(wx.EVT_MENU, self.cbFileContent, id=702)
		self.Bind(wx.EVT_MENU, self.cbFileClear, id=709)

		# File selection
		self.mainFrame.g_listSelections.Bind(wx.EVT_LISTBOX,self.cbSelectionListSelect)
		self.mainFrame.g_listSelections.Bind(wx.EVT_RIGHT_DOWN,self.cbSelectionListMenu)
		self.Bind(wx.EVT_MENU, self.cbSelectionListMenu_Rename, id=801)
		self.Bind(wx.EVT_MENU, self.cbSelectionListMenu_Delete, id=802)

		# Filters
		self.mainFrame.g_lFilters_Project.Bind(wx.EVT_CHECKLISTBOX,self.cbProjectFilterSelect)

		#--- Settings
		self.SettingsDialog.g_slideMarkerDensity_detail.Bind(wx.EVT_COMMAND_SCROLL_THUMBRELEASE,self.cbMarker4Detail)
		self.SettingsDialog.g_slideMarkerDensity_detail.Bind(wx.EVT_COMMAND_SCROLL_PAGEUP,self.cbMarker4Detail)
		self.SettingsDialog.g_slideMarkerDensity_detail.Bind(wx.EVT_COMMAND_SCROLL_PAGEDOWN,self.cbMarker4Detail)
		self.SettingsDialog.g_slideMarkerDensity_intensity.Bind(wx.EVT_COMMAND_SCROLL_THUMBRELEASE,self.cbMarker4Intensity)
		self.SettingsDialog.g_slideMarkerDensity_intensity.Bind(wx.EVT_COMMAND_SCROLL_PAGEUP,self.cbMarker4Intensity)
		self.SettingsDialog.g_slideMarkerDensity_intensity.Bind(wx.EVT_COMMAND_SCROLL_PAGEDOWN,self.cbMarker4Intensity)
		self.SettingsDialog.g_cbMarkerDensity.Bind(wx.EVT_COMBOBOX,self.cbMarkerDensity)
		self.SettingsDialog.g_cbClusterDistance.Bind(wx.EVT_CHECKBOX,self.cbClusterDistance)
		self.SettingsDialog.g_cbClusterDistanceBut.Bind(wx.EVT_BUTTON,self.cbClusterDistanceBut)
		self.SettingsDialog.g_sliderPlateau.Bind(wx.EVT_SLIDER,self.cbPlateauSize)

		self.SettingsDialog.g_cbVMetric.Bind(wx.EVT_COMBOBOX,self.cbDisplayVMetric)
		self.SettingsDialog.g_ckAttrNameLabel.Bind(wx.EVT_CHECKBOX,self.cbAttrNameLabel)
		self.SettingsDialog.g_ckAttrLabels.Bind(wx.EVT_CHECKBOX,self.cbAttrLabels)
		self.SettingsDialog.g_ckAttrGrid.Bind(wx.EVT_CHECKBOX,self.cbAttrGrid)
		self.SettingsDialog.g_ckAttrTimeLabels.Bind(wx.EVT_CHECKBOX,self.cbAttrTimeLabels)
		self.SettingsDialog.g_ckAttrVScale.Bind(wx.EVT_CHECKBOX,self.cbAttrVScale)
		self.SettingsDialog.g_ckFileLabels.Bind(wx.EVT_CHECKBOX,self.cbFileLabels)

		#--- Corner buttons
		self.mainFrame.bitmap_button_1.Bind(wx.EVT_BUTTON,self.cbFitToScreen)
		self.mainFrame.bitmap_button_2.Bind(wx.EVT_BUTTON,self.cbFitToFile)
		self.mainFrame.bitmap_button_3.Bind(wx.EVT_BUTTON,self.cbHorizontalMetric)
		self.mainFrame.bitmap_button_4.Bind(wx.EVT_BUTTON,self.cbVerticalMetric)


		# Scrollbars project evolution
		self.mainFrame.g_scrollX.Bind(wx.EVT_SCROLL, self.cbScrollX)
		self.mainFrame.g_scrollY.Bind(wx.EVT_SCROLL, self.cbScrollY)
		self.mainFrame.g_scrollX.SetScrollbar(sta_globals.iScrollPosX,sta_globals.iScrollSizeX,sta_globals.iScrollResolution,sta_globals.iScrollSizeX)
		self.mainFrame.g_scrollY.SetScrollbar(sta_globals.iScrollPosY,sta_globals.iScrollSizeY,sta_globals.iScrollResolution,sta_globals.iScrollSizeY)

		self.Bind(wx.EVT_MENU, self.MenuSort, id=150)
		self.Bind(wx.EVT_MENU, self.MenuSort, id=151)
		self.Bind(wx.EVT_MENU, self.MenuSort, id=152)
		self.Bind(wx.EVT_MENU, self.MenuSort, id=153)
		self.Bind(wx.EVT_MENU, self.MenuSort, id=154)
		self.Bind(wx.EVT_MENU, self.MenuSort, id=155)
		self.Bind(wx.EVT_MENU, self.MenuSort, id=156)
		self.Bind(wx.EVT_MENU, self.MenuSort, id=157)

		self.Bind(wx.EVT_MENU, self.Menu107, id=107)
		self.Bind(wx.EVT_MENU, self.Menu108, id=108)
		self.Bind(wx.EVT_MENU, self.Menu109, id=109)
		self.Bind(wx.EVT_MENU, self.Menu110, id=110)
		self.Bind(wx.EVT_MENU, self.Menu111, id=111)
		self.Bind(wx.EVT_MENU, self.Menu114, id=114)
		self.Bind(wx.EVT_MENU, self.Menu115, id=115)
		self.Bind(wx.EVT_MENU, self.Menu116, id=116)
		self.Bind(wx.EVT_MENU, self.Menu117, id=117)
		self.Bind(wx.EVT_MENU, self.Menu118, id=118)
		self.Bind(wx.EVT_MENU, self.Menu119, id=119)

		for i in range(len(sta_globals.lPlugins_Project)):
			self.Bind(wx.EVT_MENU, self.MenuGroup, id=112*10+i)

		self.Bind(wx.EVT_MENU, self.Menu400, id=400)
		self.Bind(wx.EVT_MENU, self.Menu401, id=401)
		self.Bind(wx.EVT_MENU, self.Menu402, id=402)
		self.Bind(wx.EVT_MENU, self.cbShowLog, id=403)

		self.SettingsDialog.g_cbVMetric.SetSelection(1)
		#------------------------------------------------------- Timers ---
		self.cConnectionTimer = wx.Timer()
		self.cConnectionTimer.SetOwner(self,2001)

		self.cServerTimer = wx.Timer(self)
		self.cServerTimer.SetOwner(self,2002)
		self.cServerTimer.Start(3000)
		self.cServerTimerGuard = False

		self.Bind(wx.EVT_TIMER, self.OnTimer)

		#------------------------------------------------------- Image lists ---
		self.lFileImageList = wx.ImageList(13,13)
		self.lFileImageList.Add(wx.Bitmap(sta_globals.sFileList0))
		self.lFileImageList.Add(wx.Bitmap(sta_globals.sFileList1))
		self.lFileImageList.Add(wx.Bitmap(sta_globals.sFileList2))
		self.lFileImageList.Add(wx.Bitmap(sta_globals.sFileList3))
		self.lFileImageList.Add(wx.Bitmap(sta_globals.sFileList4))

		self.mainFrame.g_listFiles.AssignImageList(self.lFileImageList)

		self.iVerticalMetricMode	= 1

		#----------------------------------------------------------------------
		# program data
		#----------------------------------------------------------------------
		sta_globals.cSTAPrj			= sta_data.STAPrj()
		sta_globals.lProjects		= []
		sta_globals.lFiles			= []
		sta_globals.cSelectedFile 	= sta_data.STAFile()
		sta_globals.bSelectedFile 	= False
		sta_globals.cSelectedFolder = sta_data.STAFile()
		sta_globals.sStartDir		= os.getcwd()

		#---- Clustering engine
		if len(sta_globals.lPlugins_Cluster)>0:
			sta_globals.cClusterEngine			= sta_globals.lPlugins_Cluster[0]
		else:
			sta_globals.cClusterEngine			= sta_clusters.CClusterEngine()
		sta_globals.cClusterEngine.SetGUI(self.mainFrame)
		sta_globals.cClusterEngine.gProgress	= self.mainFrame.g_gFile
		sta_globals.cClusterEngine.fResolution = float(sta_globals.iClusterSelectedDetail)/sta_globals.iClusterDetail

		self.bPreserveClusters		= False		# Decide whether the clusters are preserved when sorting or not

		#---- SCM engine
		sta_globals.sSCMRoot					= ''

		sta_globals.cSVNClient					= pysvn.Client()
		sta_globals.cSVNClient.exception_style 	= 1

		sta_globals.cCMLogedFile				= sta_data.STAFile()
		sta_globals.cCMLogCommit				= sta_data.STACommit()
		sta_globals.iCMLogStep					= 0

		self.tfsImporter                        = None

		#------------------------------------------------------- Other state ---
		sta_globals.bActionCancel		= False			# File update Cancel button enabled

		self.bMetricCancel		= False			# Metric generation Cancel button enabled

		self.lFT_dTree	  		= {}			# The file tree of the project
		self.dFileTreeItem  	= {}			# for every file keeps the associated tree item

		self.iFileProgress		= 0				# file info/content progress
		self.iContentProgress	= 0				# file content progress
		self.iPrjProgress		= 0				# project checkout progress (fluctuates as we don't know the completion percentage)
		self.iPrjProgressDir	= 1				# project progress fill direction

		#------------------------------------------------------ Do not touch ---
		self.bTreeHack			= False			#

		self.sDetail			= ['','']		# To avoid flicker in Commit Detail window

		#----------------------------------------------------------------------
		# other initialization
		#----------------------------------------------------------------------

		#-------------------------------- register paths and other settings ---
		sPath = sta_globals.sStartDir
		if os.path.exists(sPath):
			os.environ['PATH'] = os.environ['PATH']+";"+sPath

		try:
		   os.environ['HOME']
		except:
		   os.environ['HOME'] = sPath

		fileHandle = open('./cfg/settings.dat','r')
		l_iMode = 0
		sLine = fileHandle.readline()
		while (sLine != ''):
			sLine = sLine.rstrip()
			if (sLine != ''):
				#------ Mode control ---
				if (sLine == '# Additional Paths'):
					l_iMode = 1
				#--- Mode processing ---
				elif (l_iMode == 1):
					os.environ['PATH'] = os.environ['PATH']+";"+sLine
				#-----------------------
			sLine = fileHandle.readline()
		fileHandle.close()

		#---------------------------------------------------------
		self.mainFrame.g_gFile.SetForegroundColour(self.cPrjProgress)
		self.mainFrame.g_gFile.Refresh()
		self.mainFrame.Show()

		return True

	def CallAsynch(self,p_sCmd):
		evt = sta_globals.STAEvent(sCmd='self.%s'%(p_sCmd))
		wx.PostEvent(self,evt)

	def cbExitApp(self,evt):
		exit_program(0)

	#----------------------------------------------------- Init project data ---
	def projectInfoInit(self):
		sta_globals.lFiles					= []
		sta_globals.lSelectedFiles			= []
		sta_data.ClearSelections()
		sPath = sta_globals.cSTAPrj.storagePath()+"/extra/selections"
		sta_data.LoadSelections(sPath)
		sta_globals.iSelectedFilesStartTime	= 0
		sta_globals.iSelectedFilesEndTime	= 0
		sta_globals.iProjectStartTime		= 0
		sta_globals.iProjectEndTime			= 0
		self.UpdateSelectedFiles(True,False)

#/////////////////////////////////////////////////////////////////////////////////////////
#																	Callbacks
#/////////////////////////////////////////////////////////////////////////////////////////
	def cbExecuteAsynch(self,evt):
		exec (evt.sCmd)

	def MainThreadExec(self,p_sCmd,lParams=[]):
		for i in lParams:
			sta_globals.cMainQueue.put(i)
		p_sCmd = p_sCmd.replace('$STA$','sta_globals.cMainQueue.get()')
		evt = sta_globals.STAEvent(sCmd=p_sCmd)
		wx.PostEvent(self,evt)

	def TFSImporter(self, command, args=[], inputargs=None):
		cmd = ['./support/SolidSCMImporter/SolidSCMImporter.exe', command, '--progress']
		if sta_globals.cSTAPrj.sType:
			cmd.extend(['--type', sta_globals.cSTAPrj.sType])
		if sta_globals.cSTAPrj.sAddress:
			cmd.extend(['--url', sta_globals.cSTAPrj.sAddress])
		if sta_globals.cSTAPrj.sFolder:
			cmd.extend(['--path', sta_globals.cSTAPrj.sFolder])
		if sta_globals.cSTAPrj.sUser:
			cmd.extend(['--user', sta_globals.cSTAPrj.sUser])
		if sta_globals.cSTAPrj.sPass:
			cmd.extend(['--password', sta_globals.cSTAPrj.sPass])
		cmd.extend(['--directory', sta_globals.cSTAPrj.storagePath()])
		cmd.extend(args)

		print "Running command: "
		print ' '.join(cmd)

		self.tfsImporter = subprocess.Popen(cmd, stdin=subprocess.PIPE, stdout=subprocess.PIPE, creationflags=CREATE_NEW_PROCESS_GROUP)

		if inputargs != None:
			extraArgs = "\n".join(inputargs) + "\n.\n"
			print " with extra args: "
			print extraArgs
			self.tfsImporter.stdin.write(extraArgs)

		firstProgress = 0
		secondProgress = 0

		for line in iter(self.tfsImporter.stdout.readline, ''):
			line = line.rstrip()

			sta_utils.dprint('tfsImporter: ' + line)

			if line.startswith('##'):
				index = int(line[2])
				total = int(line[4:])
				if index == 0:
					firstProgress = 0
					self.MainThreadExec('self.mainFrame.g_gFile.SetRange($STA$)', lParams=[total])
					self.MainThreadExec('self.mainFrame.g_gFile.SetValue($STA$)', lParams=[firstProgress])
				elif index == 1:
					secondProgress = 0
					self.MainThreadExec('self.mainFrame.g_gContent.SetRange($STA$)', lParams=[total])
					self.MainThreadExec('self.mainFrame.g_gContent.SetValue($STA$)', lParams=[secondProgress])
				elif index == 2:
					self.MainThreadExec('self.ComputeMetricsDialog.metrics_cProgress.SetRange($STA$)', lParams=[total])
			elif line == '#0':
				firstProgress += 1
				self.MainThreadExec('self.mainFrame.g_gFile.SetValue($STA$)', lParams=[firstProgress])

				# Also reset the second gauge
				secondProgress = 0
				self.MainThreadExec('self.mainFrame.g_gContent.SetValue($STA$)', lParams=[secondProgress])
			elif line == '#1':
				secondProgress += 1
				self.MainThreadExec('self.mainFrame.g_gContent.SetValue($STA$)', lParams=[secondProgress])
			elif line == '#2':
				self.MainThreadExec('self.cbGeneratorProgressUpdate()')
			else:
				self.MainThreadExec('self.logCommand("Importer: "+$STA$+"\\n")', lParams=[line])

		self.MainThreadExec('self.mainFrame.g_gFile.SetRange(0)', lParams=[])
		self.MainThreadExec('self.mainFrame.g_gFile.SetValue(0)', lParams=[])
		self.MainThreadExec('self.mainFrame.g_gContent.SetRange(0)', lParams=[])
		self.MainThreadExec('self.mainFrame.g_gContent.SetValue(0)', lParams=[])

		status = self.tfsImporter.wait()
		self.tfsImporter = None

		if status == 1:
			self.MainThreadExec('self.logCommand("Importing from TFS cancelled\\n")')
		elif status == 2:
			self.MainThreadExec('self.logCommand("Importing from TFS failed\\n")')
		elif status == 3:
			self.MainThreadExec('self.logCommand("Could not connect to TFS server\\n")')
		elif status == 4:
			self.MainThreadExec('self.logCommand("Authentication credentials invalid.\\n")')

		return status

	def cancelTFSImporter(self):
		if self.tfsImporter != None:
			ctypes.windll.kernel32.GenerateConsoleCtrlEvent(CTRL_BREAK_EVENT, self.tfsImporter.pid)
			return True
		else:
			return False

#===============================================================================
#																Main Menu
#===============================================================================
	def cbMainMenu(self,evt):

		l_iTool = evt.GetId()

		if (l_iTool == 10101):						# Open an existing project
			self.loadProjects()
			self.OpenProjectDialog.Show(True)
		elif (l_iTool == 10100):					# New project
			self.cbPrjNew_2()
		elif (l_iTool == 10102):					# Export
			self.cbExportProject()
		elif (l_iTool == 10103):					# Import
			self.cbImportProject()
		elif (l_iTool == 10110):					# Exit
			sys.exit(0)
		elif (l_iTool == 10800):					# Display settings window
			self.SettingsDialog.Show(True)
		elif (l_iTool == 10700):					# Display metric generators window
			self.ComputeMetricsDialog.Show(True)
		elif (l_iTool == 10701):
			thread.start_new_thread(self.cbUpdateAll,())
		elif (l_iTool == 10900):					# Display help window
			self.mainFrame.cHelp.Show(True)
		elif (l_iTool == 10901):					# About box
			info = TAboutBox.TAboutBox(self.mainFrame,sta_globals.dBranding)

#===============================================================================
#														Metric generation engine
#===============================================================================
	def cbCancelMetric(self,evt):
		if not self.cancelTFSImporter():
			self.bMetricCancel = True

	def cbSelectGenerator(self,evt):
		self.ComputeMetricsDialog.metrics_bRemove.Disable()
		i = self.ComputeMetricsDialog.metrics_lMetrics.GetSelection()
		if i != wx.NOT_FOUND:
			self.ComputeMetricsDialog.metrics_lMetrics.Deselect(i)

		i = self.ComputeMetricsDialog.metrics_lGenerators.GetSelection()
		if i != wx.NOT_FOUND:
			self.ComputeMetricsDialog.metrics_bGenerate.Enable()
			self.ComputeMetricsDialog.metrics_tInfo.SetPage(sta_globals.lPlugins_MetricGenerator[i].sInfo)
		else:
			self.ComputeMetricsDialog.metrics_tInfo.SetPage('')

	def preGenerator(self):
		self.mainFrame.enableActivityButtons(False)
		self.ComputeMetricsDialog.metrics_lGenerators.Disable()
		self.ComputeMetricsDialog.metrics_lMetrics.Disable()
		self.ComputeMetricsDialog.metrics_bGenerate.Disable()

		self.ComputeMetricsDialog.metrics_bCancel.Enable()

		self.ComputeMetricsDialog.metrics_cProgress.SetForegroundColour(sta_globals.GUI.cFileContentProgress)
		self.ComputeMetricsDialog.metrics_cProgress.Refresh()
		self.ComputeMetricsDialog.metrics_cProgress.SetRange(len(sta_globals.lSelectedFiles))
		self.iGeneratorProgress = 0

	def postGenerator(self):

		self.mainFrame.enableActivityButtons(True)
		self.ComputeMetricsDialog.metrics_lGenerators.Enable()
		self.ComputeMetricsDialog.metrics_lMetrics.Enable()
		self.ComputeMetricsDialog.metrics_bGenerate.Enable()

		self.ComputeMetricsDialog.metrics_bCancel.Disable()
		self.bMetricCancel = False
		self.ComputeMetricsDialog.metrics_cProgress.SetRange(0)
		self.ComputeMetricsDialog.metrics_cProgress.Refresh()

	def cbGeneratorProgressUpdate(self):
		self.iGeneratorProgress = self.iGeneratorProgress + 1
		self.ComputeMetricsDialog.metrics_cProgress.SetValue(self.iGeneratorProgress)

	def cbRunGenerator(self,evt):

		self.preGenerator()

		i = self.ComputeMetricsDialog.metrics_lGenerators.GetSelection()
		l_cGenerator = sta_globals.lPlugins_MetricGenerator[i]
		self.logCommand('Generate '+l_cGenerator.sName+' metrics for selected files\n')

		if l_cGenerator.preGenerate():
			thread.start_new_thread(l_cGenerator.generate,(sta_globals.sDBPath,))
		else:
			self.postGenerator()

	def cbSelectMetric(self,evt):
		self.ComputeMetricsDialog.metrics_bGenerate.Disable()
		i = self.ComputeMetricsDialog.metrics_lGenerators.GetSelection()
		if i != wx.NOT_FOUND:
			self.ComputeMetricsDialog.metrics_lGenerators.Deselect(i)

		i = self.ComputeMetricsDialog.metrics_lMetrics.GetSelection()
		if i != wx.NOT_FOUND:
			self.ComputeMetricsDialog.metrics_bRemove.Enable()
			l_cMetric = self.ComputeMetricsDialog.metrics_lMetrics.GetClientData(i)
			self.ComputeMetricsDialog.metrics_tInfo.SetPage(l_cMetric.sDescription)
		else:
			self.ComputeMetricsDialog.metrics_tInfo.SetPage('')

	def cbRemoveMetric(self,evt):

		i = self.ComputeMetricsDialog.metrics_lMetrics.GetSelection()
		if i != wx.NOT_FOUND:

			l_cMetric = self.ComputeMetricsDialog.metrics_lMetrics.GetClientData(i)

			cDB = sqlite.connect(sta_globals.sDBPath)
			cCursorDB = cDB.cursor()

			# remove dependencies
			for i in l_cMetric.lDependencies:
				l_iCount = 0
				for j in sta_globals.lMetrics:
					if i in j.lDependencies:
						l_iCount = l_iCount+1
				if (l_iCount == 1):
					if sta_utils.isValidTable(cCursorDB,i):
						sCmd = "drop table "+i
						cCursorDB.execute(sCmd)

			# remove metric itself
			if sta_utils.isValidTable(cCursorDB,l_cMetric.sID):
				sCmd = "drop table "+l_cMetric.sID
				cCursorDB.execute(sCmd)

			# remove metric registration
			if sta_utils.isValidTable(cCursorDB,'Metrics'):
				sCmd = "delete from Metrics where ID='"+l_cMetric.sID+"'"
				cCursorDB.execute(sCmd)

			#clean-up display
			self.ComputeMetricsDialog.metrics_tInfo.SetPage('')

			cDB.commit()
			cCursorDB.close()
			cDB.close()

			self.UpdateFiltersList()

#===============================================================================
#																Pop-up menus
#===============================================================================

	#--------------------------------------- Group by selected filter values ---
	def MenuGroup(self,evt):

		l_iIdx = evt.GetId() - 1120
		sta_globals.sMenuGroup = sta_globals.lPlugins_Project[l_iIdx].sClass
		#---------------------------------------------- version filter ---
		if sta_globals.lPlugins_Project[l_iIdx].iMetricType == 0:
			if (self.bPreserveClusters) and sta_globals.cClusterEngine.HasClusters():
				self.glCanvas.bShowClusters = True
				sta_globals.lSelectedFiles = sta_globals.cClusterEngine.SortPreserve(sta_data_manip.cmpFile_FilterVersion)
			else:
				self.glCanvas.bShowClusters = False
				sta_globals.lSelectedFiles.sort(sta_data_manip.cmpFile_FilterVersion)
			sta_globals.lSelectedFiles.reverse()
		#------------------------------------------------- file filter ---
		elif sta_globals.lPlugins_Project[l_iIdx].iMetricType == 1:
			if (self.bPreserveClusters) and sta_globals.cClusterEngine.HasClusters():
				self.glCanvas.bShowClusters = True
				sta_globals.lSelectedFiles = sta_globals.cClusterEngine.SortPreserve(sta_data_manip.cmpFile_FilterFile)
			else:
				self.glCanvas.bShowClusters = False
				sta_globals.lSelectedFiles.sort(sta_data_manip.cmpFile_FilterFile)
			sta_globals.lSelectedFiles.reverse()
		#-----------------------------------------------------------------
		self.glCanvas.updatePosition()
		self.glCanvas.RefreshEx()
		self.glVerticalCanvas.RefreshEx()

	#------------------------------------------------------------------ Sort ---

	#----------------------- Exceptions ---
	def MenuSort_simlarity(self):
		if (sta_globals.cSelectedFile.sName != "-"):
			for i in sta_globals.lSelectedFiles:
				i.lValues['similarity'] = sta_data_manip.delta_FileCommit(sta_globals.cSelectedFile,i)

	def MenuSort_transaction(self):
		if not self.glCanvas.bFullCurrentInfo:
			return

		for i in sta_globals.lSelectedFiles:
			i.lValues['transaction'] = sta_data_manip.cmpFile_SimilarTransaction(i,self.glCanvas.cCurrentCommit)

	def MenuSort_hits(self):
		for i in sta_globals.lSelectedFiles:
			i.lValues['texthits'] = sta_data_manip.cmpFile_TextHits(i)

	def MenuSort_activity(self):
		for i in sta_globals.lSelectedFiles:
			i.lValues['activity'] = sta_data_manip.cmpFile_Activity(i)

	#-------------------------- Generic ---
	def MenuSort_aux(self):

		l_pSortFunction = sta_globals.lpSortFunction[sta_globals.iSortMode]

		# Call custom setup if any
		if (l_pSortFunction[5] != ''):
			exec('self.'+l_pSortFunction[5]+'()')

		# Set text for attribute soorting (if any)
		sta_data_manip.sSortAttribute = l_pSortFunction[3]

		# Perform sort (with cluster preservation or not)
		if l_pSortFunction[2] and (self.bPreserveClusters) and sta_globals.cClusterEngine.HasClusters():
			self.glCanvas.bShowClusters = True
			sta_globals.lSelectedFiles = sta_globals.cClusterEngine.SortPreserve(l_pSortFunction[0])
		else:
			self.glCanvas.bShowClusters = False
			sta_globals.lSelectedFiles.sort(l_pSortFunction[0])
			if (sta_globals.bSortInvert):
				sta_globals.lSelectedFiles.reverse()

		# Delete temporary variables (if any)
		if (l_pSortFunction[4]):
			for i in sta_globals.lSelectedFiles:
				try:
					del i.lValues[l_pSortFunction[3]]
				except:
					pass

		# Update windows
		self.glCanvas.updatePosition()
		self.glCanvas.RefreshEx()
		self.glVerticalCanvas.RefreshEx()

	def UpdateSortMode(self, mode):
		sta_globals.iSortMode = mode

		# Set status bar
		self.mainFrame.statusbar.SetStatusText("Sorted "+sta_globals.lpSortFunction[mode][1] + (' (inverted)' if sta_globals.bSortInvert else ''),1)

		# Check correct item
		for i in range(len(sta_globals.lpSortFunction)):
			self.mainFrame.cMenu.Check(150+i, False)
		mi = self.mainFrame.cMenu.Check(150+mode, True)

	def MenuSort(self,event):

		l_iID = event.GetId() - 150

		if (l_iID == 0):
			sta_globals.bSortInvert = not sta_globals.bSortInvert

			self.UpdateSortMode(sta_globals.iSortMode)
			self.mainFrame.cMenu.Check(150, sta_globals.bSortInvert)
		else:
			sta_globals.bSortInvert = False

			self.UpdateSortMode(l_iID)

		self.MenuSort_aux()


	#------------------------------------------------- Filter out transaction ---
	def Menu114(self, event):

		#Check whether mouse coordinates are meaningful
		if not self.glCanvas.bFullCurrentInfo:
			return

		#TODO:for all selected files remove commits in a neigourood of one hour with the same author and commit logs
		for i in sta_globals.lSelectedFiles:
			l_lCommitsToFilter = []
			for j in range(len(i.lRevs)):
				l_cCommit = i.lRevs[j]
				if abs(l_cCommit.iTime - self.glCanvas.cCurrentCommit.iTime) < 3600:
					if self.auxGetComment(l_cCommit) == self.auxGetComment(self.glCanvas.cCurrentCommit):
						if 	self.auxGetAuthor(l_cCommit) == self.auxGetAuthor(self.glCanvas.cCurrentCommit):
							l_lCommitsToFilter.append(j)
			l_lCommitsToFilter.reverse()
			for j in l_lCommitsToFilter:
				del i.lRevs[j]
			if (len(i.lRevs)>0):
				i.iEnd   = i.lRevs[-1].iTime
				i.iStart = i.lRevs[0].iTime
			else:
				i.iEnd   = 0
				i.iStart = 0

		self.PostRemoveTransaction()

	def Menu118(self, event):#------------------------ Filter out selected versions

		if not sta_utils.isValidDB(sta_globals.sDBPath):
			return

		if (sta_globals.sMarker3 == ''):
			return

		self.startTimelyAction()
		self.mainFrame.enableActivityButtons(False)

		self.mainFrame.g_gFile.SetForegroundColour(self.cFileInfoProgress)
		self.mainFrame.g_gFile.Refresh()
		self.mainFrame.g_gFile.SetRange(len(sta_globals.lSelectedFiles))
		self.iFileProgress = 0

		thread.start_new_thread(self.Menu118_asynch,())

	def Menu118_asynch(self):
		l_cUnit = sta_globals.lcUnits_Project[sta_globals.sMarker3]
		if l_cUnit.bActive and (l_cUnit.iAttrType == 0) and l_cUnit.cPlugin.bSelected:
			for l_cFile in sta_globals.lSelectedFiles:
				l_lCommitsToFilter = []
				for i in xrange(len(l_cFile.lRevs)):
					if l_cUnit.cPlugin.isItemSelected(l_cFile.lRevs[i]):
						l_lCommitsToFilter.append(i)
				l_lCommitsToFilter.reverse()
				for i in l_lCommitsToFilter:
					del l_cFile.lRevs[i]
				if (len(l_cFile.lRevs)>0):
					l_cFile.iEnd   = l_cFile.lRevs[-1].iTime
					l_cFile.iStart = l_cFile.lRevs[0].iTime
				else:
					l_cFile.iEnd   = 0
					l_cFile.iStart = 0
				self.MainThreadExec('self.cbProgressFileUpdate_1()')

		self.MainThreadExec('self.mainFrame.g_gFile.SetRange(0)')
		self.MainThreadExec('self.mainFrame.enableActivityButtons(True)')
		self.MainThreadExec('self.PostRemoveTransaction()')
		self.MainThreadExec('self.stopTimelyAction()')

	def Menu116(self, event):#--------------------------- Filter out cross transactions

		if not sta_utils.isValidDB(sta_globals.sDBPath):
			return

		self.startTimelyAction()
		self.mainFrame.enableActivityButtons(False)

		self.mainFrame.g_gFile.SetForegroundColour(self.cFileInfoProgress)
		self.mainFrame.g_gFile.Refresh()
		self.mainFrame.g_gFile.SetRange(len(sta_globals.lSelectedFiles))
		self.iFileProgress = 0

		thread.start_new_thread(self.Menu116_asynch,())

	def Menu116_asynch(self):

		l_bContinue = False

		sta_globals.CT_dMessageLog 	= {}
		sta_globals.CT_dMessageID 	= {}

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()

		if sta_utils.isValidTable(cCursorDB,'M_SS2007010102'):
			l_bContinue = True
			for i in sta_globals.lSelectedFiles:
				for j in i.lRevs:
					sCmd = "select Name from M_SS2007010102 where ID="+str(j.iDBid)
					cCursorDB.execute(sCmd)
					l_sMessage = cCursorDB.fetchone()[0]

					l_iTime = j.iTime / sta_globals.iCommitRadius
					l_iMessageHash = hash('%s%d'%(l_sMessage,l_iTime))

					try:
						sta_globals.CT_dMessageLog[l_iMessageHash] = sta_globals.CT_dMessageLog[l_iMessageHash] + 1
					except:
						sta_globals.CT_dMessageLog[l_iMessageHash] = 1
						sta_globals.CT_dMessageID[l_iMessageHash] = j.iDBid

				self.MainThreadExec('self.cbProgressFileUpdate_1()')

		cCursorDB.close()
		cDB.close()

		# Finish processing
		self.MainThreadExec('self.mainFrame.g_gFile.SetRange(0)')
		self.MainThreadExec('self.stopTimelyAction()')
		if (l_bContinue):
			self.MainThreadExec('self.Menu116_aux()')
		else:
			self.MainThreadExec('self.mainFrame.enableActivityButtons(True)')

	def Menu116_aux_asynch(self):

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()

		if sta_utils.isValidTable(cCursorDB,'M_SS2007010102') and (len(sta_globals.CT_dTintedHash.keys()) != 0):
			for i in sta_globals.lSelectedFiles:

				l_lCommitsToFilter = []

				# Detect relevant commits
				for j in range(len(i.lRevs)):
					sCmd = "select Name from M_SS2007010102 where ID="+str(i.lRevs[j].iDBid)
					cCursorDB.execute(sCmd)
					l_sMessage = cCursorDB.fetchone()[0]

					l_iTime = i.lRevs[j].iTime / sta_globals.iCommitRadius
					l_iMessageHash = hash('%s%d'%(l_sMessage,l_iTime))

					try:
						sta_globals.CT_dTintedHash[l_iMessageHash]
						l_lCommitsToFilter.append(j)
					except:
						pass

				# Remove selected commits
				l_lCommitsToFilter.reverse()
				for j in l_lCommitsToFilter:
					del i.lRevs[j]
					if (len(i.lRevs)>0):
						i.iEnd   = i.lRevs[-1].iTime
						i.iStart = i.lRevs[0].iTime
					else:
						i.iEnd   = 0
						i.iStart = 0

				# Notify progress
				self.MainThreadExec('self.cbProgressFileUpdate_1()')

		cCursorDB.close()
		cDB.close()

		self.MainThreadExec('self.mainFrame.g_gFile.SetRange(0)')
		self.MainThreadExec('self.mainFrame.enableActivityButtons(True)')
		self.MainThreadExec('self.PostRemoveTransaction()')
		self.MainThreadExec('self.stopTimelyAction()')

	def Menu116_aux(self):

		l_dlg = sta_gui.CCrossTransactionDlg('Remove cross transactions',self.mainFrame)
		l_iRetCode = l_dlg.ShowModal()
		l_dlg.Destroy()
		if (l_iRetCode == wx.ID_OK):

			self.startTimelyAction()

			self.mainFrame.g_gFile.SetForegroundColour(self.cFileInfoProgress)
			self.mainFrame.g_gFile.Refresh()
			self.mainFrame.g_gFile.SetRange(len(sta_globals.lSelectedFiles))
			self.iFileProgress = 0

			thread.start_new_thread(self.Menu116_aux_asynch,())

		else:
			self.mainFrame.enableActivityButtons(True)

	def PostRemoveTransaction(self):

		self.glCanvas.RefreshEx()
		self.glVerticalCanvas.RefreshEx()

		for i in sta_globals.lPlugins_Project:
			if i.bGUIDisplayed:
				for j in i.cGUIList.lObservers:
					j.Refresh()

	#---------------------------------------------------- Calculate clusters ---
	# Cluster sort
	def auxMenu107_02(self):
		# Sort files according to in-order cluster hierarchy traversal
		sta_globals.lSelectedFiles = sta_globals.cClusterEngine.Sort()

		self.UpdateSortMode(5)
		self.glCanvas.bShowClusters = True

		self.glCanvas.updatePosition()
		self.glCanvas.RefreshEx()
		self.glVerticalCanvas.RefreshEx()
		self.glClusterCanvas.RefreshEx()

	#----------------------------
	# Cluster computation task
	def auxMenu107_01(self):
		sta_globals.cClusterEngine.Compute(sta_globals.lSelectedFiles)

		# Save clusters
		if (sta_globals.bFolderSelection):
			l_sPath = sta_globals.cSTAPrj.storagePath()+"/extra/clusters"+sta_globals.cSelectedFolder.sPath
			sta_globals.cClusterEngine.Save(l_sPath)

		# Sort files according to in-order cluster hierarchy traversal
		self.MainThreadExec('self.auxMenu107_02()')

	#----------------------------
	def Menu107(self, event):

		if len(sta_globals.lPlugins_Cluster) == 0:
			return

		# If clusters are already computed and loaded redo the sorting
		if sta_globals.cClusterEngine.HasClusters():
			# Sort files according to in-order cluster hierarchy traversal
			self.auxMenu107_02()
			return

		# If clusters are computed but not loaded load then redo display and sort
		if (sta_globals.bFolderSelection):
			l_sPath = sta_globals.cSTAPrj.storagePath()+"/extra/clusters"+sta_globals.cSelectedFolder.sPath
			if sta_globals.cClusterEngine.Load(l_sPath,sta_globals.lSelectedFiles):

				# Sort files according to in-order cluster hierarchy traversal
				self.auxMenu107_02()

				self.glClusterCanvas.RefreshEx()

				return

		# If clusters are not computed redo everything
		thread.start_new_thread(self.auxMenu107_01,())

	#----------------------------------------------------- Preserve clusters ---
	def Menu108(self, event):
		mi = self.mainFrame.cMenu.FindItemById(108)
		if (self.bPreserveClusters):
			self.bPreserveClusters = False
			mi.Check(False)
		else:
			self.bPreserveClusters = True
			mi.Check()
		self.MenuSort_aux()
	#---------------------------------------------- Compute local similarity ---
	def Menu109(self, event):
		if (sta_globals.cSelectedFile.sName != "-"):

			for i in sta_globals.lSelectedFiles:
				i.lValues['similarity'] = sta_data_manip.delta_FileCommit(sta_globals.cSelectedFile,i)

			self.glVerticalCanvas.RefreshEx()

	#-------------------------------------------------------- Clear clusters ---
	def Menu110(self,event):
		l_sPath = sta_globals.cSTAPrj.storagePath()+"/extra/clusters"+sta_globals.cSelectedFolder.sPath
		for i in sta_globals.lSelectedFiles:
			i.lValues['cluster'] = 0
		sta_globals.cClusterEngine.Clear(l_sPath)
		self.glCanvas.RefreshEx()
		self.glVerticalCanvas.RefreshEx()

	#-------------------------------------------------------- Get clustering score ---
	def Menu111(self,event):
		l_sMsg = sta_globals.cClusterEngine.pScore()
		dlg = wx.MessageDialog(self.mainFrame, l_sMsg,'Clustering score',wx.OK )
		dlg.ShowModal()
		dlg.Destroy()


	#-------------------------------------------------------- Save frequency table
	def getChangeImpact(self,p_cFile,p_iCommit):

		l_fImpact = sta_globals.lChangeImpact[0]

		try:
			l_sCurrentDeveloper	= p_cFile.lRevs[p_iCommit].lValues['author_name']
		except:
			l_sCurrentDeveloper	= '-'

		l_iCommit = p_iCommit-1
		while (l_iCommit>=0):

			try:
				l_sDeveloper	= p_cFile.lRevs[p_iCommit].lValues['author_name']
			except:
				l_sDeveloper	= '-'

			if (l_sCurrentDeveloper == l_sDeveloper):
				l_iTime = p_cFile.lRevs[p_iCommit].iTime - p_cFile.lRevs[l_iCommit].iTime
				if (l_iTime > 7776000): # 30 *24 * 3600
					l_fImpact = sta_globals.lChangeImpact[0]
				elif (l_iTime > 5184000):
					l_fImpact = sta_globals.lChangeImpact[1]
				elif (l_iTime > 2592000):
					l_fImpact = sta_globals.lChangeImpact[2]
				elif (l_iTime > 1296000):
					l_fImpact = sta_globals.lChangeImpact[3]
				elif (l_iTime > 648000):
					l_fImpact = sta_globals.lChangeImpact[4]
				else:
					l_fImpact = sta_globals.lChangeImpact[5]
				break

			l_iCommit = l_iCommit-1

		return l_fImpact,l_sCurrentDeveloper


	def Menu119(self,evt):	# Save selection
		l_iSelection = self.mainFrame.g_listSelections.GetSelection()
		if (l_iSelection != wx.NOT_FOUND):
			cSelection = self.mainFrame.g_listSelections.GetClientData(l_iSelection)
			cSelection.LoadCurrent(True,cSelection.sName)
		else:
			sPath			= sta_globals.cSTAPrj.storagePath()+"/extra/selections"
			cSelection		= sta_data.STASelection(sPath)
			cSelection.iID	= sta_data.GetFreeSelectionID()
			cSelection.LoadCurrent(False,'')
			sta_data.AddSelection(cSelection)
			l_iSelection = self.mainFrame.g_listSelections.GetCount()-1
			self.mainFrame.g_listSelections.SetSelection(l_iSelection)
			self.cbSelectionListMenu_Rename(0)

	def Menu117(self,event):
		l_cDlg = wx.FileDialog(sta_globals.GUI.mainFrame,wildcard="Report (*.csv)|*.csv",style=wx.FD_SAVE)
		if (l_cDlg.ShowModal() == wx.ID_OK):
			sFilePath = l_cDlg.GetPath()
			l_fileHandle = open(sFilePath, 'w')
			l_fileHandle.write('File,Number of changes,Change weight,Number of developers,Chief developer,Text hits\n')

			l_iStartTime = sta_globals.iStartFocusInterval
			if (l_iStartTime < 0):
				l_iStartTime = sta_globals.iSelectedFilesStartTime

			l_iEndTime = sta_globals.iEndFocusInterval
			if (l_iEndTime < 0):
				l_iEndTime = sta_globals.iSelectedFilesEndTime

			l_dDevelopers			= {}
			for l_cFile in sta_globals.lSelectedFiles:
				l_iCount			= 0
				l_fTotalImpact		= 0
				l_iDevelopers		= 0
				l_sChiefDeveloper	= '-'
				l_iHits				= 0
				l_dDevelopers.clear()

				for l_iCommit in xrange(len(l_cFile.lRevs)):
					l_cCommit = l_cFile.lRevs[l_iCommit]
					if (l_cCommit.iTime >= l_iStartTime) and (l_cCommit.iTime <=l_iEndTime):

						l_iCount += 1

						l_fImpact,l_sDeveloper = self.getChangeImpact(l_cFile,l_iCommit)
						l_fTotalImpact += l_fImpact

						try:
							l_iHitValue		= l_cCommit.lValues['pextFind']
							if (l_iHitValue == -1):
								l_iHitValue = 0
							else:
								l_iHitValue = 1
						except:
							l_iHitValue = 0
						l_iHits += l_iHitValue

						try:
							l_dDevelopers[l_sDeveloper] += 1
						except:
							l_dDevelopers[l_sDeveloper] = 1

				l_iDevelopers = len(l_dDevelopers.values())
				for l_sDeveloper in l_dDevelopers.keys():
					if (float(l_dDevelopers[l_sDeveloper]) / l_iCount > 0.79):
						l_sChiefDeveloper = l_sDeveloper
						break

				l_fileHandle.write('%s,%d,%.3f,%d,%s,%d\n'%(l_cFile.sPath,l_iCount,l_fTotalImpact,l_iDevelopers,l_sChiefDeveloper,l_iHits))

			l_fileHandle.close()
	#-------------------------------------------------------- Take snaphot
	def Menu115(self,event):
		l_cDlg = wx.FileDialog(sta_globals.GUI.mainFrame,style = wx.FD_SAVE, wildcard = "PNG files (*.png)|*.png")
		if (l_cDlg.ShowModal() == wx.ID_OK):
			sFilePath = l_cDlg.GetPath()

			pixels = sta_utils.flatten(sta_globals.lPixelsEvolution)
			pixels.extend(sta_utils.flatten(sta_globals.lPixelsHorizontal))

			l_ImageHeight = sta_globals.fSizeY+sta_globals.iHorizontalBar
			l_ImageWidth  = sta_globals.fSizeX

			l_offset 	= 0
			l_step 		= 3*l_ImageWidth

			l_lRawData	= range(l_ImageHeight)
			for i in range(l_ImageHeight):
				l_lRawData[i] = pixels[l_offset:l_offset+l_step]
				l_offset = l_offset+l_step
			l_lRawData.reverse()

			import png
			l_fileHandle = open(sFilePath, 'wb')
			l_PNGWriter = png.Writer(l_ImageWidth, l_ImageHeight)
			l_PNGWriter.write(l_fileHandle, l_lRawData)
			l_fileHandle.close()
#===============================================================================
#														View modes from toolbar
#===============================================================================

	#---------------------------------------------------------------- Details ---
	def Menu400(self,event):
		if self.mainFrame.g_toolViews.GetToolState(400):
			self.InfoDialog.Show()
		else:
			self.InfoDialog.Show(False)

	#-------------------------------------------------------------- Tree view ---
	def Menu401(self,event):
		if self.mainFrame.g_toolViews.GetToolState(401):
			self.mainFrame.window_main.SplitVertically(self.mainFrame.window_tree,self.mainFrame.window_display_holder,200)
		else:
			self.mainFrame.window_main.Unsplit(self.mainFrame.window_tree)

	#-------------------------------------------------------- Attribute view ---
	def Menu402(self,event):
		if self.mainFrame.g_toolViews.GetToolState(402):
			self.mainFrame.window_display.SplitHorizontally(self.mainFrame.window_evolution,self.mainFrame.window_graphs,0)
		else:
			self.mainFrame.window_display.Unsplit(self.mainFrame.window_graphs)

#===============================================================================
#															Zoom & Pan Project
#===============================================================================

	#---------------------------------------------------------------- Zoom X ---
	def cbZoomX(self,evt):
		self.glCanvas.updateRatios()

		fCenterPosition = sta_globals.iScrollPosX + float(sta_globals.iScrollSizeX)/2
		fScrollSize = float(sta_globals.iScrollResolution) / sta_globals.fZoomX
		sta_globals.iScrollSizeX = fScrollSize
		sta_globals.iScrollPosX = fCenterPosition - fScrollSize /2

		# take advantage of already checked boundary conditions
		self.mainFrame.g_scrollX.SetScrollbar(sta_globals.iScrollPosX,sta_globals.iScrollSizeX,sta_globals.iScrollResolution,sta_globals.iScrollSizeX)
		iScrollPos = self.mainFrame.g_scrollX.GetThumbPosition()
		if (iScrollPos != int(sta_globals.iScrollPosX)):
			sta_globals.iScrollPosX = iScrollPos

		sta_globals.fScrollRatioX = float(sta_globals.iScrollPosX) / sta_globals.iScrollResolution
		self.glCanvas.updateOffsetX(sta_globals.fScrollRatioX)

		self.glCanvas.RefreshEx()
		self.glHorizontalCanvas.RefreshEx()
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.RefreshEx()

	#---------------------------------------------------------------- Zoom Y ---
	def cbZoomY(self,evt):
		self.glCanvas.updateRatios()

		fCenterPosition = sta_globals.iScrollPosY + float(sta_globals.iScrollSizeY)/2
		fScrollSize = float(sta_globals.iScrollResolution) / sta_globals.fZoomY
		sta_globals.iScrollSizeY = fScrollSize
		sta_globals.iScrollPosY = fCenterPosition - fScrollSize /2
		self.mainFrame.g_scrollY.SetScrollbar(sta_globals.iScrollPosY,sta_globals.iScrollSizeY,sta_globals.iScrollResolution,sta_globals.iScrollSizeY)

		# take advantage of already checked boundary conditions
		iScrollPos = self.mainFrame.g_scrollY.GetThumbPosition()
		if (iScrollPos != int(sta_globals.iScrollPosY)):
			sta_globals.iScrollPosY = iScrollPos

		sta_globals.fScrollRatioY = float(sta_globals.iScrollPosY) / sta_globals.iScrollResolution
		self.glCanvas.updateOffsetY(sta_globals.fScrollRatioY)

		self.glCanvas.RefreshEx()
		self.glVerticalCanvas.RefreshEx()

	#-------------------------------------------------------------- Scroll X ---
	def cbScrollX(self,evt):
		sta_globals.iScrollPosX = self.mainFrame.g_scrollX.GetThumbPosition()
		sta_globals.fScrollRatioX = float(sta_globals.iScrollPosX) / sta_globals.iScrollResolution
		self.glCanvas.updateOffsetX(sta_globals.fScrollRatioX)

		self.glCanvas.RefreshEx()
		self.glHorizontalCanvas.RefreshEx()
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.RefreshEx()

	#-------------------------------------------------------------- Scroll Y ---
	def cbScrollY(self,evt):
		sta_globals.iScrollPosY = self.mainFrame.g_scrollY.GetThumbPosition()
		sta_globals.fScrollRatioY = float(sta_globals.iScrollPosY) / sta_globals.iScrollResolution
		self.glCanvas.updateOffsetY(sta_globals.fScrollRatioY)

		self.glCanvas.RefreshEx()
		self.glVerticalCanvas.RefreshEx()

	#--------------------------------------------------------- Fit to screen ---
	def cbFitToScreen_aux(self,evt):
		sta_globals.fZoomY	= 1
		sta_globals.fZoomX	= 1
		self.glCanvas.updateRatios()

		sta_globals.iScrollSizeX = sta_globals.iScrollResolution
		self.mainFrame.g_scrollX.SetScrollbar(sta_globals.iScrollPosX,sta_globals.iScrollSizeX,sta_globals.iScrollResolution,sta_globals.iScrollSizeX)
		sta_globals.iScrollPosX = 0
		sta_globals.fScrollRatioX = 0
		self.glCanvas.updateOffsetX(sta_globals.fScrollRatioX)

		sta_globals.iScrollSizeY = sta_globals.iScrollResolution
		self.mainFrame.g_scrollY.SetScrollbar(sta_globals.iScrollPosY,sta_globals.iScrollSizeY,sta_globals.iScrollResolution,sta_globals.iScrollSizeY)
		sta_globals.iScrollPosY = 0
		sta_globals.fScrollRatioY = 0
		self.glCanvas.updateOffsetY(sta_globals.fScrollRatioY)

	def cbFitToScreen(self,evt):

		self.cbFitToScreen_aux(evt)

		self.glCanvas.RefreshEx()
		self.glVerticalCanvas.RefreshEx()
		self.glHorizontalCanvas.RefreshEx()
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.RefreshEx()

	#----------------------------------------------------------- Fit to file ---
	def cbFitToFile(self,evt):

		#fZoomY = float(self.SettingsDialog.g_sFitToSize.GetValue()*len(sta_globals.lSelectedFiles)) / sta_globals.fSizeY
		fZoomY = float(self.SettingsDialog.g_sFitToSize.GetValue()*sta_globals.fUnitY)

		if fZoomY >= 1:
			sta_globals.fZoomY = fZoomY
			self.glCanvas.updateRatios()

			sta_globals.iScrollSizeY = sta_globals.iScrollResolution / sta_globals.fZoomY
			self.mainFrame.g_scrollY.SetScrollbar(sta_globals.iScrollPosY,sta_globals.iScrollSizeY,sta_globals.iScrollResolution,sta_globals.iScrollSizeY)

			iScrollPos = self.mainFrame.g_scrollY.GetThumbPosition()
			if (iScrollPos != sta_globals.iScrollPosY):
				sta_globals.iScrollPosY = iScrollPos
				sta_globals.fScrollRatioY = float(sta_globals.iScrollPosY) / sta_globals.iScrollResolution
				self.glCanvas.updateOffsetY(sta_globals.fScrollRatioY)

			self.glCanvas.RefreshEx()
			self.glVerticalCanvas.RefreshEx()

#===============================================================================
#																GUI Settings
#===============================================================================

	#-------------------------------------------------------- Set resolution ---
	def cbClusterDetail(self,evt):

		sta_globals.iClusterLevel				= sta_globals.iClusterDetail - sta_globals.iClusterSelectedDetail
		sta_globals.cClusterEngine.fResolution	= float(sta_globals.iClusterLevel)/sta_globals.iClusterDetail

		if not sta_globals.cClusterEngine.HasClusters():
			return

		if (sta_globals.iSortMode == 5):
			self.glCanvas.RefreshEx()
			self.glVerticalCanvas.RefreshEx()
		elif (self.bPreserveClusters):
			self.MenuSort_aux()
		self.glClusterCanvas.RefreshEx()

	#------------------------------------------ Update cluster distance mode ---
	def cbClusterDistance(self,event):
		if len(sta_globals.lPlugins_Cluster)>0:
			l_iDistanceMode = self.SettingsDialog.g_cbClusterDistance.GetSelection()

			sta_globals.cClusterEngine = sta_globals.lPlugins_Cluster[l_iDistanceMode]
			sta_globals.cClusterEngine.SetGUI(self.mainFrame)
			sta_globals.cClusterEngine.gProgress	= self.mainFrame.g_gFile
			sta_globals.cClusterEngine.fResolution	= float(sta_globals.iClusterSelectedDetail)/sta_globals.iClusterDetail
			if (sta_globals.lPlugins_Cluster[l_iDistanceMode].bHasGUI):
				self.g_cbClusterDistanceBut.Enable(True)

			sta_globals.cClusterEngine.Reset()
			self.glCanvas.updatePosition()
			self.glCanvas.RefreshEx()
			self.glVerticalCanvas.RefreshEx()

	def cbClusterDistanceBut(self,event):
		if (sta_globals.cClusterEngine.bHasGUI) and (sta_globals.cClusterEngine.cGUI != None):
			sta_globals.cClusterEngine.cGUI.Show(True)

	#--------------------------------------------------------- Marker 4 size ---
	def cbMarker4Detail(self,evt):
		sta_globals.fMarker4Detail = self.SettingsDialog.g_slideMarkerDensity_detail.GetValue()
		self.glCanvas.RefreshEx()

	#---------------------------------------------------- Marker 4 intensity ---
	def cbMarker4Intensity(self,evt):
		sta_globals.fMarker4Intensity = float(1*self.SettingsDialog.g_slideMarkerDensity_intensity.GetValue())/1000
		self.glCanvas.RefreshEx()

	#--------------------------------------------------------- Mode marker 4 ---
	def cbMarkerDensity(self,evt):
		sta_globals.iMode4 = self.SettingsDialog.g_cbMarkerDensity.GetSelection()
		if sta_globals.sMarker4 != '':
			self.glCanvas.RefreshEx()
			self.glMixerCanvas_Project.RefreshEx()

	#------------------------------------------------------ Plateau cushions ---
	def cbPlateauSize(self,evt):
		sta_globals.iNrPixelsClusterEdge =  self.SettingsDialog.g_sliderPlateau.GetValue()
		self.glCanvas.RefreshEx()

	#----------------------------------------------------------- File labels ---
	def cbFileLabels(self,evt):
		sta_globals.bFileLabels = evt.IsChecked()
		self.glCanvas.RefreshEx()

	#------------------------------------------ Vertical metric display mode ---
	def cbDisplayVMetric(self,event):
		self.glVerticalCanvas.display = self.SettingsDialog.g_cbVMetric.GetSelection()
		self.glVerticalCanvas.RefreshEx()
	#------------------------------------------------------- Vertical metric ---
	def cbVerticalMetric(self,event):
		self.iVerticalMetricMode = self.iVerticalMetricMode+1
		if (self.iVerticalMetricMode == len(self.glVerticalCanvas.lsNames)):
			self.iVerticalMetricMode = 0
		self.glVerticalCanvas.show(self.iVerticalMetricMode)
		self.glVerticalCanvas.RefreshEx()
		l_sMetricName = self.glVerticalCanvas.getDescription()
		self.mainFrame.statusbar.SetStatusText("Vertical metric: "+l_sMetricName,0)
		self.gVerticalCanvasTip.SetTip(l_sMetricName)


	#----------------------------------------------------- Horizontal metric ---
	def cbHorizontalMetric(self,event):
		sta_globals.iStartFocusInterval		= -1
		sta_globals.iEndFocusInterval		= -1
		self.glHorizontalCanvas.RefreshEx()

	#--------------------------------------------------------- Show log info ---
	def cbShowLog(self,evt):
		if evt.IsChecked():
			self.LogDialog.Show()
		else:
			self.LogDialog.Hide()
	#------------------------------------------------------- Animation timer ---
	def OnTimer(self,evt):

		l_iId = evt.GetId()
		#-------------------------------- Server connection ---
		if (l_iId == 2001):
			if (sta_globals.bConnectionOpen == False):
				self.cConnectionTimer.Stop()
				self.mainFrame.g_cConnection.Rest()
		#--------------------------------------------------------

	def cbSCMRetries(self,evt):			# SCM retries
		sta_globals.iSVNRetries = self.SettingsDialog.g_spinSCMRetries.GetValue()

#===============================================================================
#												List of projects action buttons
#===============================================================================
	def startTimelyAction(self):
		sta_globals.bConnectionOpen = True
		self.mainFrame.SetCursor(wx.HOURGLASS_CURSOR)

	def stopTimelyAction(self):
		self.mainFrame.SetCursor(wx.STANDARD_CURSOR)
		sta_globals.bConnectionOpen = False

#--------------------------------------------------------------- New project ---
	def cbPrjNew_1(self, evt):
		if self.cbPrjNew():
			self.updateProjects(1)

	def cbPrjNew_2(self):
		if self.cbPrjNew():
			l_cPrj = sta_globals.lProjects[-1]
			l_iItem = self.OpenProjectDialog.AddProject(l_cPrj)
			self.OpenProjectDialog.g_listProjects.SetItemState(l_iItem, wx.LIST_STATE_SELECTED, wx.LIST_STATE_SELECTED)
			self.cbPrjLoad(0)

	def cbPrjNew(self):

		l_bResult = False

		l_cSTAPrj = sta_data.STAPrj()
		dlg = sta_gui.CProjectDlg(l_cSTAPrj,self.mainFrame)
		dlg.SetTitle("Add a new project")

		val = dlg.ShowModal()
		if val == wx.ID_OK:

			dlg.cSTAPrj.calculatePath()

			if not os.path.exists("data/"+dlg.cSTAPrj.sPath):
				sta_globals.lProjects.append(dlg.cSTAPrj)
				self.saveProject(dlg.cSTAPrj)
				l_bResult = True
			else:
				sta_utils.logError(self.mainFrame,"The combination address + module already exists !\nProject not added.")

		dlg.Destroy()

		return l_bResult

#-------------------------------------------------------------- Edit project ---
	def cbPrjEdit(self, evt):
		idx = self.OpenProjectDialog.GetSelection()
		if (idx == wx.NOT_FOUND):
			return

		l_sPrjPath = sta_globals.lProjects[idx].sPath
		dlg = sta_gui.CProjectDlg(sta_globals.lProjects[idx],self.mainFrame)
		dlg.SetTitle("Edit project settings")

		val = dlg.ShowModal()
		if val == wx.ID_OK:

			dlg.cSTAPrj.calculatePath()

			if (l_sPrjPath != dlg.cSTAPrj.sPath):
				if not os.path.exists(dlg.cSTAPrj.sPath):
					os.rename("data/"+l_sPrjPath,"data/"+dlg.cSTAPrj.sPath)
					self.saveProject(dlg.cSTAPrj)
				else:
				 sta_utils.logError(self.mainFrame,"The combination address + module already exists !\nProject not modified.")
			else:
				self.saveProject(dlg.cSTAPrj)
				pass

		self.updateProjects(1)
		dlg.Destroy()

#------------------------------------------------------------ Delete project ---
	def cbPrjDelete(self, evt):

		idx = self.OpenProjectDialog.GetSelection()
		if (idx == wx.NOT_FOUND):
			return

		dlg = sta_gui.CYesNoDialog("	 Are you sure you want to delete \'"+sta_globals.lProjects[idx].sName+"\' ?	 ",self.mainFrame)
		dlg.SetTitle("Delete project")

		val = dlg.ShowModal()
		if val == wx.ID_OK:
			self.xPrjDelete(sta_globals.lProjects[idx])

			self.logCommand("Delete project: "+sta_globals.lProjects[idx].sName+" \n")
			if sta_globals.lProjects[idx].sPath == sta_globals.cSTAPrj.sPath:
				sta_globals.cSTAPrj = sta_data.STAPrj()
				self.projectInfoInit()							# Evolution
				self.mainFrame.g_listFiles.DeleteAllItems()	# File structure
				self.mainFrame.enableCurrentPrjButtons(False)
				self.mainFrame.enableFileButtons(False)
				self.OpenProjectDialog.enablePrjButtons(False)

			del sta_globals.lProjects[idx]
			self.updateProjects(1)

		dlg.Destroy()

#-------------------------------------------------------------- Load project ---

	def cbPrjLoad_aux(self):

		self.startTimelyAction()

		if sta_globals.cClusterEngine.HasClusters():
			sta_globals.cClusterEngine.Reset()

		self.projectInfoInit()								# Evolution
		self.mainFrame.g_listFiles.Enable()
		sta_globals.cSelectedFile = sta_data.STAFile()
		sta_globals.bSelectedFile = False

		self.mainFrame.enableCurrentPrjButtons(True)
		self.mainFrame.enableFileButtons(False)
		self.loadFileTree()									# File structure

		self.UpdateTitle()
		self.LogDialog.g_tInfo.Clear()

		# TFS doesn't need a password when no user is specified
		if sta_globals.cSTAPrj.sType not in ('GIT', 'TFS') or sta_globals.cSTAPrj.sUser != '':
			l_dlg = sta_gui.CPassDlg(sta_globals.cSTAPrj,self.mainFrame)
			l_iRetCode = l_dlg.ShowModal()
			l_dlg.Destroy()
		else:
			l_iRetCode = 0
		"""
		if (sta_globals.cSTAPrj.sPass == "###STA###NoPass"):
			self.mainFrame.enableCurrentPrjButtons(False)
			self.mainFrame.enableFileButtons(False)
		"""

		#------------------------------------------------------ Load SVN project ---
		if (sta_globals.cSTAPrj.sType == "SVN"):
			sta_globals.cSVNClient.callback_get_login						= sta_svn.SVN_get_login
			sta_globals.cSVNClient.callback_cancel							= sta_svn.SVN_command_cancel
			sta_globals.cSVNClient.callback_get_log_message					= sta_svn.SVN_get_log_message
			sta_globals.cSVNClient.callback_notify							= sta_svn.SVN_notify
			sta_globals.cSVNClient.callback_ssl_client_cert_password_prompt	= sta_svn.SVN_ssl_client_cert_password_prompt
			sta_globals.cSVNClient.callback_ssl_client_cert_prompt			= sta_svn.SVN_ssl_client_cert_prompt
			sta_globals.cSVNClient.callback_ssl_server_trust_prompt			= sta_svn.SVN_ssl_server_trust_prompt

			if sta_globals.cSTAPrj.sProtocol == "file":
				l_sAddPath = "/"
			else:
				l_sAddPath = ""
			sta_globals.sSCMRoot = sta_globals.cSTAPrj.sProtocol+"://"+l_sAddPath+sta_globals.cSTAPrj.sAddress

		self.stopTimelyAction()

	def cbPrjLoad(self, evt):

		idx = self.OpenProjectDialog.GetSelection()
		if (idx == wx.NOT_FOUND):
			return
		sta_globals.cSTAPrj = sta_globals.lProjects[idx]
		self.OpenProjectDialog.Hide()

		self.cbPrjLoad_aux()

#===============================================================================
#												Selected project action buttons
#===============================================================================
#------------------------------------------------------------- Clear project ---
	def cbPrjClear(self, evt):

		self.startTimelyAction()

		self.mainFrame.g_listFiles.DeleteAllItems()
		self.dFileTreeItem = {}
		self.mainFrame.g_listFiles.Disable()
		self.mainFrame.enableFileButtons(False)

		self.xPrjClear(sta_globals.cSTAPrj)
		self.projectInfoInit()				# Evolution
		self.loadFileTree()					# Folder structure

		self.stopTimelyAction()

	def xPrjClear(self,cPrj):

		self.logCommand("Clear project: "+cPrj.sName+" \n")

		#------- delete paths ---
		sPath = cPrj.storagePath()+"/extra"
		if os.path.exists(sPath):
			sta_utils.del_dir(sPath)

		sPath = cPrj.storagePath()+"/taskbuffer"
		if os.path.exists(sPath):
			sta_utils.del_dir(sPath)

		sPath = cPrj.storagePath()+"/statistics.dat"
		if os.path.exists(sPath):
			os.remove(sPath)

		sPath = cPrj.storagePath()+"/history.db"
		if os.path.exists(sPath):
			os.remove(sPath)
		#------------------------
		cPrj.iFiles = 0
		cPrj.sDate = "-"
#------------------------------------------------------------ Delete project ---
	def xPrjDelete(self,cPrj):

		self.xPrjClear(cPrj)
		self.logCommand("Delete project: "+cPrj.sName+" \n")
		sPath = cPrj.storagePath()

		if os.path.exists(sPath):
			sta_utils.del_dir(sPath)

#------------------------------------------------------------ Select project ---
	def cbPrjListSelect(self,evt):
		idx = self.OpenProjectDialog.GetSelection()
		if (idx != wx.NOT_FOUND) and (not sta_globals.bConnectionOpen):
			self.OpenProjectDialog.enablePrjButtons(True)

#------------------------------------------------------------ Update project ---
	def prjUpdate_result(self,l_lsNewFiles,l_iTime):

		l_lcExistingFiles	= []	# Files that exist already (no folders)
		l_lsExistingFiles	= {}	# Name of existing files
		l_lcFilesToAdd	 	= []	# Files that need to be added
		l_lcFilesToRemove	= []	# Files that need to be removed
		l_lcFilesToModify 	= []	# Files that need to be modified
		l_iDBid			 	= sta_utils.getCurrentFileDBid()
									# ID of the file in the DB

		#----------------------------- Add new files to the existing tree ---

		for i in sta_globals.lFiles:
			if i.iType == 0:
				l_lcExistingFiles.append(i)
				l_lsExistingFiles[i.sPath] = i

				if (i.iTime < l_iTime):
					try:
						l_lsNewFiles[i.sPath]
					except:
						i.iStatus = 1


		sta_globals.lFiles = l_lcExistingFiles

		for i in l_lsNewFiles.keys():

			l_sFile = i
			try:
				l_cExistingFile = l_lsExistingFiles[l_sFile]
				if (l_lsNewFiles[i] != l_iTime) and (l_cExistingFile.iStatus == 0):
					l_cExistingFile.iStatus = 1
				else:
					l_cExistingFile.iTime = l_iTime
				l_lcFilesToModify.append(l_cExistingFile)

			except:

				l_cFile			= sta_data.STAFile()
				l_cFile.iTime	= l_lsNewFiles[i]

				if (l_cFile.iTime != l_iTime):
					l_cFile.iStatus = 1	# Obsolete

				l_cFile.sPath	= l_sFile
				l_cFile.iDBid	= l_iDBid
				l_iDBid		   	= l_iDBid + 1

				l_iNamePos = l_cFile.sPath.rfind("/")+1
				l_cFile.sName = l_cFile.sPath[l_iNamePos:]

				l_lcFilesToAdd.append(l_cFile)

				sta_globals.lFiles.append(l_cFile)
				self.appendFile(l_cFile)   # Here the file tree is constructed

		#------------------------------------------- Remove deleted files ---
		"""
		l_dsNewFiles = {}
		for i in l_lsNewFiles:
			l_dsNewFiles[i] = 1

		l_lcExistingFiles = []
		for i in sta_globals.lFiles:
			try:
				l_dsNewFiles[i.sPath]
				l_lcExistingFiles.append(i)
			except:
				l_lcFilesToRemove.append(i)
				#TODO: Remove files from the data tree
				self.removeFile(i.sPath)

		sta_globals.lFiles = l_lcExistingFiles
		"""

		self.saveFileTree(l_lcFilesToAdd,l_lcFilesToRemove,l_lcFilesToModify)		# Save new files

		self.prjUpdate_aux();


	def prjUpdate_aux(self):
		#----------------------------------------- Populate existing tree ---
		self.mainFrame.g_listFiles.DeleteAllItems()
		self.dFileTreeItem={}
		tRootItem = self.mainFrame.g_listFiles.AddRoot(sta_globals.cSTAPrj.sName,image=3)

		l_cFile = sta_data.STAFile()
		l_cFile.sPath	= "/"
		l_cFile.iType 	= 1
		self.mainFrame.g_listFiles.SetPyData(tRootItem,l_cFile)

		self.lFT_populate(tRootItem,self.lFT_dTree,"/")  							# Populate tree

		#-------------------------------------- Update project statistics ---

		sta_globals.cSTAPrj.iFiles = len([1 for i in sta_globals.lFiles if int(i.iDBid) > 0])
		sta_globals.cSTAPrj.sDate = datetime.date.today().isoformat()
		self.saveProjectStatistics(sta_globals.cSTAPrj)

		#------------------------------------------------------------ Exit ---
		self.postLoadFileTree()
		self.logCommand(" OK: Project "+sta_globals.sSCMRoot+" updated successfully \n")

	def prePrjUpdate(self):
		self.mainFrame.enableActivityButtons(False)
		self.startTimelyAction()

		self.mainFrame.g_bFileCancel.Enable()
		sta_globals.bActionCancel = False

		self.cConnectionTimer.Start(1000)
		self.mainFrame.g_cConnection.Start()

	def postPrjUpdate(self):
		#self.mainFrame.enableActivityButtons(True)		#Already performed in the prjUpdate_aux by postLoadTree
		self.mainFrame.g_listFiles.Enable()

		self.stopTimelyAction()

	def cbPrjUpdate(self,evt):
		self.prePrjUpdate()
		self.logCommand("Update project: "+sta_globals.cSTAPrj.sName+" \n")
		thread.start_new_thread(self.cbPrjUpdate_asynch,(evt,))

	#---- SCM specific ---
	def cbPrjUpdate_asynch(self, evt):

		#------ Dispatch repository handler ---
		if sta_globals.cSTAPrj.sType == "GIT":
			self.cbPrjUpdate_TFS(evt)
		elif sta_globals.cSTAPrj.sType == "SVN":
			self.cbPrjUpdate_SVN(evt)
		elif sta_globals.cSTAPrj.sType == 'TFS':
			self.cbPrjUpdate_TFS(evt)
		else:
			self.MainThreadExec('self.logCommand(" ERROR: Repository type not supported: "+sta_globals.cSTAPrj.sType+" \\n")')
		#--------------------------------------
		self.MainThreadExec('self.postPrjUpdate()')

	def cbPrjUpdate_SVN(self,evt):

		try:

			sta_utils.dprint('SVN: List file update L1')
			sta_utils.dprint(sta_globals.sSCMRoot)

			# Determine repository root
			l_sPath = urllib.quote(sta_globals.sSCMRoot, ":/*~")
			sta_utils.dprint(l_sPath)

			lEntry = sta_globals.cSVNClient.info2(l_sPath+'/.',recurse=False)
			sta_utils.dprint(lEntry[0][1].repos_root_URL)

			if (len(lEntry)>0):
				iLen = len(lEntry[0][1].repos_root_URL) - len(sta_globals.sSCMRoot)
				if (iLen < 0):
					sPrefix = sta_globals.sSCMRoot[iLen:]
					iLen = len(sPrefix)
			else:
				iLen = 0

			# Find list of files in the project
			l_lTimes			= []
			for l_cSnapshot in sta_globals.cSTAPrj.lSnapshots:
				l_lTimes.append(l_cSnapshot[0])
			l_lTimes.append(time.time())

			l_lsNewFiles		= {}	# List of files in all snaphots

			for l_iTime in l_lTimes:

				l_cRevision = pysvn.Revision( pysvn.opt_revision_kind.date, l_iTime)
				l_lcNewFiles		= sta_globals.cSVNClient.list(l_sPath,peg_revision=l_cRevision,revision=l_cRevision,dirent_fields=pysvn.SVN_DIRENT_KIND,recurse = True)

				for i in l_lcNewFiles:

					if (i[0]['kind'] != pysvn.node_kind.dir):

						#sta_utils.dprint(i[0]['repos_path'])
						l_sFile = i[0]['repos_path'][iLen:]
						l_sFile = l_sFile.replace('\\','/')
						#sta_utils.dprint('> '+l_sFile)
						if (len(l_sFile)==0):
							continue
						if l_sFile[0] != '/':
							l_sFile = '/'+l_sFile

						l_lsNewFiles[l_sFile]=l_iTime

			self.MainThreadExec('self.prjUpdate_result($STA$,$STA$)',lParams=[l_lsNewFiles,l_iTime])

		except pysvn.ClientError, e:
			l_errMsg = ""
			for message, code in e.args[1]:
				l_errMsg = l_errMsg+'Code: '+str(code)+' - '+message+"\n"
			self.MainThreadExec('self.logCommand(" ERROR: SVN\\n"+$STA$)',lParams=[l_errMsg])
			self.MainThreadExec('sta_utils.logError(self.mainFrame,$STA$,"SVN Error")',lParams=[l_errMsg])
			self.MainThreadExec('self.mainFrame.enableActivityButtons(True)')

	def cbPrjUpdate_TFS(self, evt):
		print "cbPrjUpdate_TFS - files"
		args = [str(int(snapshot[0])) for snapshot in sta_globals.cSTAPrj.lSnapshots]
		status = self.TFSImporter('files', args=args)

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()

		if status != 0:
			self.MainThreadExec('self.prjUpdate_aux()')
			return

		# Remove all files which are no longer available
		ids = [int(row[0]) for row in cCursorDB.execute("select ID from Files")]
		for index, item in enumerate(sta_globals.lFiles):
			if int(item.iDBid) > 0 and int(item.iDBid) not in ids:
				del sta_globals.lFiles[index]
				self.removeFile(item.sPath)
				self.removeFileContents(item)

		# Add new file list to the in-memory list of files / file tree
		command = "select ID,Path,Type,Time from Files"
		if len(sta_globals.lFiles) > 0:
			command += " where ID > %d" % max(item.iDBid for item in sta_globals.lFiles)

		for row in cCursorDB.execute(command):
			item = self.createFile(row)
			sta_globals.lFiles.append(item)
			self.appendFile(item)

		cDB.commit()
		cCursorDB.close()
		cDB.close()

		# TODO: Cleanup taskbuffer files for deleted items (probably done in tool)

		self.MainThreadExec('self.prjUpdate_aux()')

#===============================================================================
#												Files tree action buttons
#===============================================================================
	def modDBFiles(self,p_lcFiles):

		if (sta_utils.isValidDB(sta_globals.sDBPath)) and (len(p_lcFiles)>0):
			cDB = sqlite.connect(sta_globals.sDBPath)
			cCursorDB = cDB.cursor()

			#--- Update file entries
			for i in p_lcFiles:

				sCmd = "update Files set Type=%d, Time=%d where ID=%d"%(i.iStatus,i.iTime,i.iDBid)
				cCursorDB.execute(sCmd)

			cDB.commit()
			cCursorDB.close()
			cDB.close()

	def removeFileContents(self,item):
		l_sPath = sta_globals.cSTAPrj.storagePath()+"/extra/evolution/"+item.sPath
		if os.path.exists(l_sPath):
			sta_utils.del_dir(l_sPath)

	def deleteDBFiles(self,p_lcFiles,p_bAllInfo):

		#------------- Remove contents ---
		if (p_bAllInfo):
			for i in p_lcFiles:
				self.removeFileContents(i)

		if (sta_utils.isValidDB(sta_globals.sDBPath)) and (len(p_lcFiles)>0):
			cDB = sqlite.connect(sta_globals.sDBPath)
			cCursorDB = cDB.cursor()

			#----------- Detect installed metrics ---
			l_lTableVMetrics = []
			l_lTableFMetrics = []
			sCmd = "select ID,Type from Metrics"
			cCursorDB.execute(sCmd)
			for i in cCursorDB:
				l_sTableName = i[0]
				if (i[1] == 1):
					l_lTableVMetrics.append(l_sTableName)
				elif (i[1] == 0):
					l_lTableFMetrics.append(l_sTableName)

			#--- Remove file and version entries ---
			for i in p_lcFiles:

				sDBid = str(i.iDBid)

				if p_bAllInfo:
					sCmd = "delete from Files where ID="+sDBid
					cCursorDB.execute(sCmd)

				sCmd = "delete from Versions where File="+sDBid
				cCursorDB.execute(sCmd)

				for j in l_lTableFMetrics:
					sCmd = "delete from "+j+" where ID="+str(i.iDBid)
					cCursorDB.execute(sCmd)

				for j in l_lTableVMetrics:
					for k in i.lRevs:
						sCmd = "delete from "+j+" where ID="+str(k.iDBid)
						cCursorDB.execute(sCmd)

			cDB.commit()
			cCursorDB.close()
			cDB.close()

	def addDBFiles(self,p_lcFiles):

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()

		if not sta_utils.isValidTable(cCursorDB,'Files'):
			sCmd = "create table Files(ID integer primary key,Path text,Type integer,Time integer)"
			cCursorDB.execute(sCmd)

			sCmd = "create table Versions(ID integer primary key,File integer,Name text,Time integer)"
			cCursorDB.execute(sCmd)

			sCmd = "create table Metrics(ID text primary key,Name text,Type integer,Description text,Dependencies text)"
			cCursorDB.execute(sCmd)

		#---- Add files to DB ---
		sCmdRoot = "insert into Files(ID,Path,Type,Time) values (null,'%s',%d,%d)"
		for i in p_lcFiles:

			l_sFile = i.sPath.encode('ascii','ignore')
			#sCmd = sCmdRoot%(base64.b64encode(l_sFile),i.iStatus,i.iTime)
			sCmd = sCmdRoot%(l_sFile,i.iStatus,i.iTime)
			cCursorDB.execute(sCmd)

		cDB.commit()
		cCursorDB.close()
		cDB.close()
#----------------------------------------------- Cancel file / folder action ---
	def cbFileCancel(self,ect):
		if not self.cancelTFSImporter():
			sta_globals.bActionCancel = True
		self.mainFrame.g_bFileCancel.Disable()

#------------------------------------------------------- Clear file / folder ---
	def cbFileClear(self, evt):

		self.preFileUpdate()

		if (sta_globals.bSelectedFile) and (sta_globals.cSelectedFile in sta_globals.lSelectedFiles):
			self.logCommand(">>> Clear info file: "+sta_globals.cSelectedFile.sPath+" \n")
			thread.start_new_thread(self.singleFileClear_asynch,(sta_globals.cSelectedFile,))

		elif len(sta_globals.lSelectedFiles) > 0:
			self.logCommand(">>> Clear info file selection:\n")
			thread.start_new_thread(self.multipleFileClear_asynch,(0,))

	def singleFileClear_asynch(self,l_cFile):
		self.singleFileClear(l_cFile)
		self.MainThreadExec('self.logCommand("Clear info completed\\n")')
		self.MainThreadExec('self.postFileUpdate_selection()')

	def multipleFileClear_asynch(self,p_idummy):

		for i in sta_globals.lSelectedFiles:
			if sta_globals.bActionCancel:
				sta_globals.bActionCancel = False
				break
			else:
				self.singleFileClear(i)
				self.MainThreadExec('self.cbProgressFileUpdate_1()')
		self.MainThreadExec('self.logCommand("Clear info completed\\n")')
		self.MainThreadExec('self.postFileUpdate_selection()')

	def singleFileClear(self,l_cFile):
		self.MainThreadExec('self.logCommand("Clear file: "+$STA$+" \\n")',lParams=[l_cFile.sPath])
		#--------------------------------- Remove data in DB ---
		self.deleteDBFiles([l_cFile],False)
		#----------------------------- Remove data in memory ---
		l_sPath = l_cFile.sPath
		l_sName = l_cFile.sName
		l_iDBid = l_cFile.iDBid
		l_cFile.init()
		l_cFile.sName = l_sName
		l_cFile.sPath = l_sPath
		l_cFile.iDBid = l_iDBid
		#-------------------------- Remove data in File Tree ---
		self.MainThreadExec('self.setFileTreeImage($STA$)',lParams=[l_cFile])
		self.MainThreadExec('self.postFileUpdate_file(True)')

#------------------------------------------------------ Update file / folder ---

	def fileUpdate_aux(self,l_cFile,l_lVersionsToAdd,l_lAuthorsToAdd,l_lCommentsToAdd,l_lReleasesToAdd):

		#------------------------------------------- save file information ---
		if sta_utils.isValidDB(sta_globals.sDBPath):
			cDB = sqlite.connect(sta_globals.sDBPath)
			cCursorDB = cDB.cursor()

			#--------------- Create tables if necessary ---
			if not sta_utils.isValidTable(cCursorDB,'M_SS2007010101'):
				sCmd = "create table M_SS2007010101(ID integer primary key,Name text)"
				cCursorDB.execute(sCmd)

				sCmdRoot = "insert into Metrics(ID,Name,Type,Description,Dependencies) values ('%s','%s',1,'%s',null)"
				sParam = ['M_SS2007010101','Authors','Developer identity']
				sCmd = sCmdRoot%tuple(sParam)
				cCursorDB.execute(sCmd)

			if not sta_utils.isValidTable(cCursorDB,'M_SS2007010102'):
				sCmd = "create table M_SS2007010102(ID integer primary key,Name text)"
				cCursorDB.execute(sCmd)

				sCmdRoot = "insert into Metrics(ID,Name,Type,Description,Dependencies) values ('%s','%s',1,'%s',null)"
				sParam = ['M_SS2007010102','Comments','Version associated message log']
				sCmd = sCmdRoot%tuple(sParam)
				cCursorDB.execute(sCmd)

			if not sta_utils.isValidTable(cCursorDB,'M_SS2007010103'):
				sCmd = "create table M_SS2007010103(ID integer primary key,Name text)"
				cCursorDB.execute(sCmd)

				sCmdRoot = "insert into Metrics(ID,Name,Type,Description,Dependencies) values ('%s','%s',1,'%s',null)"
				sParam = ['M_SS2007010103','Releases','Version associated release']
				sCmd = sCmdRoot%tuple(sParam)
				cCursorDB.execute(sCmd)

			if not sta_utils.isValidTable(cCursorDB,'M_SS2007010104'):
				sCmd = "create table M_SS2007010104(ID integer primary key,LAdd integer, LDel integer, LMov integer)"
				cCursorDB.execute(sCmd)

				sCmdRoot = "insert into Metrics(ID,Name,Type,Description,Dependencies) values ('%s','%s',1,'%s',null)"
				sParam = ['M_SS2007010104','Lines','Report about the changed lines']
				sCmd = sCmdRoot%tuple(sParam)
				cCursorDB.execute(sCmd)

			#------------------------------ Add versions ---
			# Make a list of new version IDs that are allowed based on file and time
			l_lNewVersions = {}
			sCmdRoot = "select ID from Versions where File=%s and Time=%s"
			for i in l_lVersionsToAdd:
				sCmd = sCmdRoot%(l_cFile.iDBid,i.iTime)
				print sCmd
				cCursorDB.execute(sCmd)
				results = cCursorDB.fetchall()
				print results
				if (results != []):
					l_lNewVersions[i.iDBid] = False
				else:
					l_lNewVersions[i.iDBid] = True
			sta_utils.dprint(l_lNewVersions)

			sCmdRoot = "insert into Versions(ID,File,Name,Time) values (%s,%s,'%s',%s)"
			for i in l_lVersionsToAdd:
				if l_lNewVersions[i.iDBid]:
					sCmd = sCmdRoot%(i.iDBid,l_cFile.iDBid,i.sID,i.iTime)
					cCursorDB.execute(sCmd)

					l_cFile.lRevs.append(i)
					l_cFile.iNrRevs = l_cFile.iNrRevs+1

			#----------------------------------- Authors ---
			sCmdRoot = "insert into M_SS2007010101(ID,Name) values (%s,'%s')"
			for i in l_lAuthorsToAdd:
				if l_lNewVersions[i[1]]:
					l_sAuthor = sta_utils.ascii(i[0])
					l_sAuthor = l_sAuthor.replace('\'',' ')
					l_sAuthor = l_sAuthor.replace('"',' ')

					sCmd = sCmdRoot%(i[1],l_sAuthor)
					cCursorDB.execute(sCmd)
			#---------------------------------- Comments ---
			sCmdRoot = "insert into M_SS2007010102(ID,Name) values (%s,'%s')"
			for i in l_lCommentsToAdd:
				if l_lNewVersions[i[1]]:
					l_sComment = sta_utils.ascii(i[0])
					l_sComment = l_sComment.replace('\'','')
					l_sComment = l_sComment.replace('"','')

					sCmd = sCmdRoot%(i[1],l_sComment)
					cCursorDB.execute(sCmd)
			#---------------------------------- Releases ---
			sCmdRoot = "insert into M_SS2007010103(ID,Name) values (%s,'%s')"
			for i in l_lReleasesToAdd:
				if l_lNewVersions[i[1]]:
					sCmd = sCmdRoot%(i[1],i[0])
					cCursorDB.execute(sCmd)

			#----------------------------------- Lines ---
			sCmdRoot = "insert into M_SS2007010104(ID,LAdd,LDel,LMov) values (%s,%s,%s,%s)"
			for i in l_lVersionsToAdd:
				if l_lNewVersions[i.iDBid]:

					sParam = []
					sParam.append(i.iDBid)

					try:
						sParam.append(i.iAdd)
					except:
						sParam.append(0)
					try:
						sParam.append(i.iDel)
					except:
						sParam.append(0)
					try:
						sParam.append(i.iMov)
					except:
						sParam.append(0)

					sCmd = sCmdRoot%tuple(sParam)
					cCursorDB.execute(sCmd)
			#-----------------------------------------------
			cDB.commit()
			cCursorDB.close()
			cDB.close()

			self.fileUpdate_finalize(l_cFile)

	def fileUpdate_finalize(self,l_cFile):
		#------------------------------------------------------ GUI report ---
		sta_data.FinalizeFileInfo(l_cFile)
		self.MainThreadExec('self.logCommand(" OK: File info updated\\n")')

	def preFileUpdate(self):
		self.mainFrame.enableActivityButtons(False)
		self.startTimelyAction()

		self.mainFrame.g_bFileCancel.Enable()
		sta_globals.bActionCancel = False

		self.cConnectionTimer.Start(1000)
		self.mainFrame.g_cConnection.Start()

		self.mainFrame.g_gFile.SetForegroundColour(self.cFileInfoProgress)
		self.mainFrame.g_gFile.Refresh()
		self.mainFrame.g_gFile.SetRange(len(sta_globals.lSelectedFiles))
		self.iFileProgress = 0

	def postFileUpdate_file(self,bCheckRepeatTime):

		l_bUpdate = True

		# Verify whether this actions should be executed
		if (bCheckRepeatTime):
			if (time.time()-sta_globals.iUpdateTime <5):
				l_bUpdate = False
			else:
				sta_globals.iUpdateTime = time.time()


		if (l_bUpdate):

			self.UpdateSelectedFiles(True,False)

			self.glVerticalCanvas.bUpdate		 = True
			self.glHorizontalCanvas.bUpdate		 = True
			for i in sta_globals.dAttrEvolution.values():
				i.g_GLPanel.bUpdate	   = True

			self.glMixerCanvas_Project.RefreshEx()

	def postFileUpdate_selection(self):
		self.mainFrame.g_gFile.SetRange(0)

		self.postFileUpdate_file(False)

		self.mainFrame.enableActivityButtons(True)
		self.stopTimelyAction()
		self.UpdateFilters()

	def cbProgressFileUpdate_1(self):
		self.iFileProgress = self.iFileProgress + 1
		self.mainFrame.g_gFile.SetValue(self.iFileProgress)

	def cbProgressFileUpdate_2(self):
		if (self.iPrjProgress == 100) or (self.iPrjProgress == 0):
			self.iPrjProgressDir = - self.iPrjProgressDir
		self.iPrjProgress = self.iPrjProgress + self.iPrjProgressDir
		self.mainFrame.g_gFile.SetValue(self.iPrjProgress)
		self.mainFrame.g_gFile.Update()
		self.mainFrame.g_gFile.Refresh()

	def cbUpdateAll(self):
		# Files list update
		self.MainThreadExec('self.prePrjUpdate()')
		self.cbPrjUpdate_asynch(0)

		if sta_globals.lSelectedFiles == []:
			sta_globals.lSelectedFiles = sta_globals.lFiles

		# File versions update
		self.MainThreadExec('self.preFileUpdate()')
		if (sta_globals.bSelectedFile) and (sta_globals.cSelectedFile in sta_globals.lSelectedFiles):
			self.singleFileUpdate_asynch(sta_globals.cSelectedFile)

		elif len(sta_globals.lSelectedFiles) > 0:
			self.multipleFileUpdate_asynch()

		# File contents
		#-- Set folders
		l_sDestPath = sta_globals.cSTAPrj.storagePath()+"/extra/snapshots"
		if not os.path.exists(l_sDestPath):
			os.makedirs(l_sDestPath)

		l_sDestPath = sta_globals.cSTAPrj.storagePath()+"/extra/files"
		if not os.path.exists(l_sDestPath):
			os.makedirs(l_sDestPath)

		self.MainThreadExec('self.preFileContent()')

		if (sta_globals.bSelectedFile) and (sta_globals.cSelectedFile in sta_globals.lSelectedFiles):
			self.singleFileContent_asynch(sta_globals.cSelectedFile)

		elif len(sta_globals.lSelectedFiles) > 0:
			self.multipleFileContent_asynch()

		# Basic metric generator
		self.MainThreadExec('self.preGenerator()')

		l_cGenerator = sta_metricgenerator.getMetricGeneratorByID('cccc')
		l_cGenerator.generate(sta_globals.sDBPath)

		# Perform the TFS Importer metric calculation
		# This is done by using the basic metric calculator extension
		# self.metric_Calculation_TFSI_asynch()

	def cbFileUpdate(self, evt):
		if (sta_globals.bSelectedFile) and (sta_globals.cSelectedFile in sta_globals.lSelectedFiles):
			self.preFileUpdate()
			self.logCommand(">>> Update history file: "+sta_globals.cSelectedFile.sPath+" \n")
			thread.start_new_thread(self.singleFileUpdate_asynch,(sta_globals.cSelectedFile,))

		elif len(sta_globals.lSelectedFiles) > 0:
			self.preFileUpdate()
			self.logCommand(">>> Update history file selection:\n")
			thread.start_new_thread(self.multipleFileUpdate_asynch,())

	def multipleFileUpdate_asynch(self):
		# TFS can handle multiple files in one connection
		if sta_globals.cSTAPrj.sType == "GIT" or sta_globals.cSTAPrj.sType == "TFS":
			self.batchFileUpdate_TFS(sta_globals.lSelectedFiles)
		else:
			for i in sta_globals.lSelectedFiles:
				if sta_globals.bActionCancel:
					sta_globals.bActionCancel = False
					break
				else:
					self.singleFileUpdate(i)
				self.MainThreadExec('self.cbProgressFileUpdate_1()')

		self.MainThreadExec('self.updateFileImages($STA$)', lParams=[sta_globals.lSelectedFiles])
		self.MainThreadExec('self.postFileUpdate_selection()')
		self.MainThreadExec('self.logCommand(" Update history completed\\n")')

	def singleFileUpdate_asynch(self,l_cFile):

		self.singleFileUpdate(l_cFile)
		self.MainThreadExec('self.postFileUpdate_selection()')
		self.MainThreadExec('self.logCommand(" Update history completed\\n")')

	#---- SCM specific ---
	def singleFileUpdate(self,l_cFile):
		self.MainThreadExec('self.logCommand("Update file info: "+$STA$+"\\n")',lParams=[l_cFile.sPath])
		if sta_globals.cSTAPrj.sType == "GIT":
			self.singleFileUpdate_TFS(l_cFile)
		elif sta_globals.cSTAPrj.sType == "SVN":
			self.singleFileUpdate_SVN(l_cFile)
		elif sta_globals.cSTAPrj.sType == "TFS":
			self.singleFileUpdate_TFS(l_cFile)
		else:
			self.MainThreadExec('self.logCommand(" ERROR: Repository type not supported: "+sta_globals.cSTAPrj.sType+" \\n")')
		#--- Update GUI (file retrieved)

		self.MainThreadExec('self.setFileTreeImage($STA$)',lParams=[l_cFile])
		self.MainThreadExec('self.postFileUpdate_file(True)')

	def singleFileUpdate_SVN(self,l_cFile):

		#------------------------------------------------ Call the command ---
		l_sPath = urllib.quote(sta_globals.sSCMRoot+l_cFile.sPath, ":/*~")
		sta_utils.dprint(l_sPath)
		l_iAttemptNr	= 0
		l_bRetry		= True
		while (l_bRetry) and (l_iAttemptNr < sta_globals.iSVNRetries) and (not sta_globals.bActionCancel):
			try:
				l_cRevision = pysvn.Revision( pysvn.opt_revision_kind.date, l_cFile.iTime)
				lLogInfo = sta_globals.cSVNClient.log(l_sPath,peg_revision=l_cRevision, revision_start=l_cRevision,strict_node_history=False)
				l_bRetry = False

			except pysvn.ClientError, e:
				l_errMsg = ""
				for message, code in e.args[1]:
					l_errMsg = l_errMsg+'Code: '+str(code)+' - '+message+"\n"
				self.MainThreadExec('self.logCommand(" ERROR: SVN\\n"+$STA$)',lParams=[l_errMsg])
				self.MainThreadExec('self.logCommand(" Retry in "+$STA$+" seconds")',lParams=[str(sta_globals.iSVNSleep)])
				#time.sleep(sta_globals.iSVNSleep)
				l_iAttemptNr = l_iAttemptNr+1

		if (l_bRetry):
			return

		lLogInfo.reverse()
		#------------------------------------------------- Process results ---
		l_lVersionsToAdd		= []
		l_lAuthorsToAdd		 	= []							# (author, version DB ID)
		l_lCommentsToAdd		= []							# (comment, version DB ID)
		l_lReleasesToAdd		= []							# (release name, version DB ID)

		l_iCurrentVersionDBid   = sta_utils.getCurrentVersionDBid()	# Next available versionID

		sta_utils.dprint(l_iCurrentVersionDBid)

		iRev = l_cFile.iNrRevs

		sta_utils.dprint(str(l_cFile.iNrRevs)+'   '+str(len(lLogInfo)))

		for i in range(l_cFile.iNrRevs,len(lLogInfo)):			# Update only new information
			l_cLog = lLogInfo[i]								# Current log
			iRev = iRev + 1
			cCMLogCommit = sta_data.STACommit()

			cCMLogCommit.sID		= "1."+str(iRev)			# Name
			cCMLogCommit.iDBid		= l_iCurrentVersionDBid		# DB id
			l_iCurrentVersionDBid	= l_iCurrentVersionDBid+1

			try: # version
				cCMLogCommit.iTime	= l_cLog.date
				l_lVersionsToAdd.append(cCMLogCommit)
			except:
				sta_utils.dprint("WARNING: Missing date info "+l_cFile.sPath+" "+cCMLogCommit.sID)

			try: # author
				l_lAuthorsToAdd.append((l_cLog.author,cCMLogCommit.iDBid))
			except:
				l_lAuthorsToAdd.append(('missing',cCMLogCommit.iDBid))
				sta_utils.dprint("WARNING: Missing author info "+l_cFile.sPath+" "+cCMLogCommit.sID)

			try: # releases
				l_lReleasesToAdd.append((str((l_cLog.revision).number),cCMLogCommit.iDBid))
			except:
				sta_utils.dprint("WARNING: Missing release info "+l_cFile.sPath+" "+cCMLogCommit.sID)

			try: # comment
				l_lCommentsToAdd.append((l_cLog['message'],cCMLogCommit.iDBid))
			except:
				sta_utils.dprint("WARNING: Missing comment info "+l_cFile.sPath+" "+cCMLogCommit.sID)
				l_lCommentsToAdd.append(('missing',cCMLogCommit.iDBid))

			l_cFile.lRevs.append(cCMLogCommit)
			l_cFile.iNrRevs = l_cFile.iNrRevs+1

		#------------------------------------------- save file information ---
		self.fileUpdate_aux(l_cFile,l_lVersionsToAdd,l_lAuthorsToAdd,l_lCommentsToAdd,l_lReleasesToAdd)

	def batchFileUpdate_TFS(self,items):
		print "batchFileUpdate_TFS - versions"
		inputargs = [str(item.iDBid) for item in items]
		status = self.TFSImporter('versions', inputargs=inputargs)

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()

		self.MainThreadExec('self.mainFrame.g_gFile.SetRange($STA$)', lParams=[len(items)])
		done = 0;

		for item in items:
			# Add new file list to the in-memory list of files / file tree
			command = "select ID,File,Name,Time from Versions where File = %d" % item.iDBid
			if item.iNrRevs > 0:
				command += " and ID > %d" % max(rev.iDBid for rev in item.lRevs)

			for row in cCursorDB.execute(command):
				commit = self.createCommit(row)

				# Add commit to file
				item.lRevs.append(commit)
				item.iNrRevs += 1

			sta_data.FinalizeFileInfo(item)

			done += 1
			self.MainThreadExec('self.mainFrame.g_gFile.SetValue($STA$)', lParams=[done])

		self.MainThreadExec('self.mainFrame.g_gFile.SetRange(0)')

		cDB.commit()
		cCursorDB.close()
		cDB.close()

		self.MainThreadExec('self.logCommand(" OK: File info updated\\n")')

	def singleFileUpdate_TFS(self,item):
		# Just use the batch import routine, it does not have any overhead
		self.batchFileUpdate_TFS([item])

#------------------------------------------------- Get content file / folder ---
	def preFileContent(self):
		self.mainFrame.enableActivityButtons(False)
		self.mainFrame.g_bFileCancel.Enable(True)
		sta_globals.bActionCancel = False

		sta_globals.bConnectionOpen = True
		self.cConnectionTimer.Start(1000)
		self.mainFrame.g_cConnection.Start()

		self.mainFrame.g_gFile.SetForegroundColour(self.cFileContentProgress)
		self.mainFrame.g_gFile.Refresh()
		self.mainFrame.g_gFile.SetRange(len(sta_globals.cSTAPrj.lSnapshots))
		self.iFileProgress = 0

	def postFileContent(self):
		self.mainFrame.enableActivityButtons(True)
		sta_globals.bActionCancel = False
		self.mainFrame.g_gFile.SetRange(0)
		sta_globals.bConnectionOpen = False

	def cbFileContentProgress_Init(self,p_iSize):
		self.mainFrame.g_gContent.SetForegroundColour(self.cFileContentProgress)
		self.mainFrame.g_gContent.Refresh()
		self.mainFrame.g_gContent.SetRange(p_iSize)
		self.iContentProgress = 0

	def cbFileContentProgress_Update(self):
		self.iContentProgress = self.iContentProgress + 1
		self.mainFrame.g_gContent.SetValue(self.iContentProgress)

	def cbFileContent(self,evt):
		#-- Set folders
		l_sDestPath = sta_globals.cSTAPrj.storagePath()+"/extra/snapshots"
		if not os.path.exists(l_sDestPath):
			os.makedirs(l_sDestPath)

		l_sDestPath = sta_globals.cSTAPrj.storagePath()+"/extra/files"
		if not os.path.exists(l_sDestPath):
			os.makedirs(l_sDestPath)

		if (sta_globals.bSelectedFile) and (sta_globals.cSelectedFile in sta_globals.lSelectedFiles):
			self.preFileContent()
			self.logCommand(">>> Update content file: "+sta_globals.cSelectedFile.sPath+" \n")
			thread.start_new_thread(self.singleFileContent_asynch,(sta_globals.cSelectedFile,))

		elif len(sta_globals.lSelectedFiles) > 0:
			self.preFileContent()
			self.logCommand(">>> Update content file selection:\n")
			thread.start_new_thread(self.multipleFileContent_asynch,())

	def singleFileContent_asynch(self,l_cFile):
		if sta_globals.cSTAPrj.sType == 'GIT' or sta_globals.cSTAPrj.sType == 'TFS':
			self.multipleFileContent_TFS([l_cFile])
			return

		#-- Get snapshots
		l_bStop = False
		for l_cSnapshot in sta_globals.cSTAPrj.lSnapshots:

			#-- Check cancel
			if (sta_globals.bActionCancel or l_bStop):
				sta_globals.bActionCancel = False
				break

			#-- Set-up archive
			l_sDate = time.strftime("%Y%m%d_%H%S%M",time.gmtime(l_cSnapshot[0]))
			l_sDestArchive = l_sDestPath+"/"+l_sDate+".zip"
			l_sDestArchive = l_sDestArchive.replace('\\','/')
			l_lFiles = sta_utils.listArchive(l_sDestArchive)

			#-- Process files
			# Skip already retrieved files
			if str(l_cFile.iDBid) in l_lFiles:
				continue

			# Skip deleted files
			if (l_cFile.iStatus > 0) and (l_cFile.iTime < l_cSnapshot[0]):
				continue

			self.singleFileContent(l_cFile,l_cSnapshot[0],l_sDestArchive)

			#-- Progress snapshot
			self.MainThreadExec('self.cbProgressFileUpdate_1()')

		self.MainThreadExec('self.logCommand("Update content completed\\n")')
		self.MainThreadExec('self.postFileContent()')

	def multipleFileContent_asynch(self):
		if sta_globals.cSTAPrj.sType == 'GIT' or sta_globals.cSTAPrj.sType == 'TFS':
			self.multipleFileContent_TFS(sta_globals.lSelectedFiles)
			return

		#-- Set folders
		l_sDestPath = sta_globals.cSTAPrj.storagePath()+"/extra/snapshots"
		if not os.path.exists(l_sDestPath):
			os.makedirs(l_sDestPath)

		#-- Get snapshots
		l_bStop = False
		for l_cSnapshot in sta_globals.cSTAPrj.lSnapshots:

			#-- Check cancel
			if (sta_globals.bActionCancel or l_bStop):
				sta_globals.bActionCancel = False
				break

			#-- Set-up archive
			l_sDate = time.strftime("%Y%m%d_%H%S%M",time.gmtime(l_cSnapshot[0]))
			l_sDestArchive = l_sDestPath+"/"+l_sDate+".zip"
			l_sDestArchive = l_sDestArchive.replace('\\','/')
			l_lFiles = sta_utils.listArchive(l_sDestArchive)

			#-- Process files
			self.MainThreadExec('self.cbFileContentProgress_Init($STA$)',lParams=[len(sta_globals.lSelectedFiles)])
			for l_cFile in sta_globals.lSelectedFiles:
				if (sta_globals.bActionCancel or l_bStop):
					sta_globals.bActionCancel = False
					l_bStop = True
					break
				else:
					# Skip already retrieved files
					if str(l_cFile.iDBid) in l_lFiles:
						continue
					# Skip deleted files
					if (l_cFile.iStatus > 0) and (l_cFile.iTime < l_cSnapshot[0]):
						continue
					self.singleFileContent(l_cFile,l_cSnapshot[0],l_sDestArchive)
					self.MainThreadExec('self.cbFileContentProgress_Update()')
			#-- Progress snapshot
			self.MainThreadExec('self.mainFrame.g_gContent.SetRange(0)')
			self.MainThreadExec('self.cbProgressFileUpdate_1()')

		self.MainThreadExec('self.logCommand("Update content completed\\n")')
		self.MainThreadExec('self.postFileContent()')

	def multipleFileContent_TFS(self, files):
		items = []

		skipped = 0

		#--- Assess file extension
		for item in files:
			_,extension = os.path.splitext(item.sPath)
			if (extension != ''):
				extension = extension[1:].lower()
			if extension in sta_globals.lsContentExtensions:
				items.append(item)
			else:
				skipped += 1

		if skipped > 0:
			self.MainThreadExec('self.logCommand("Skipped "+$STA$+" files: content not supported / binary\\n")', lParams=[str(skipped)])

		inputargs = [str(item.iDBid) for item in items]
		print "multipleFileContent_TFS - contents"
		status = self.TFSImporter('contents', inputargs=inputargs)

		self.MainThreadExec('self.logCommand("Update content completed\\n")')
		self.MainThreadExec('self.postFileContent()')

	#---- SCM specific ---
	def singleFileContent(self,p_cFile,p_iTime,p_sDestArchive):

		self.MainThreadExec('self.logCommand("Update content : "+$STA$+"\\n")',lParams=[p_cFile.sPath])
		#--- Assess file extension
		l_sFile,l_sExtension = os.path.splitext(p_cFile.sPath)
		if (l_sExtension != ''):
			l_sExtension = l_sExtension[1:]
		l_sExtension = l_sExtension.lower()
		if not (l_sExtension in sta_globals.lsContentExtensions):
			self.MainThreadExec('self.logCommand("   Content not supported / binary \\n")')
			return

		#--- Get snapshot revision
		l_cCommit = None
		for l_cRev in p_cFile.lRevs:	# Find first revision before snapshot
			if (l_cRev.iTime <= p_iTime):
				l_cCommit = l_cRev
			else:
				break
		if (l_cCommit is None):
			return

		#--- Repository specific access
		if sta_globals.cSTAPrj.sType == "SVN":
			self.singleFileContent_SVN(p_cFile,l_cCommit,p_sDestArchive)
		else:
			self.MainThreadExec('self.logCommand(" ERROR: Repository type not supported: "+sta_globals.cSTAPrj.sType+" \\n")')

	def singleFileContent_SVN(self,p_cFile,p_cCommit,p_sDestArchive):

		#--- Get release numbers from the DB -------------------
		l_iRevision = None

		if sta_utils.isValidDB(sta_globals.sDBPath):
			cDB = sqlite.connect(sta_globals.sDBPath)
			cCursorDB = cDB.cursor()

			if sta_utils.isValidTable(cCursorDB,'M_SS2007010103'):
				sCmd = "select Name from M_SS2007010103 where ID="+str(p_cCommit.iDBid)
				cCursorDB.execute(sCmd)
				for j in cCursorDB:
					l_iRevision = int(j[0])

			cCursorDB.close()
			cDB.close()

		if (l_iRevision is None):
			return

		#--- Prepare paths -------------------------------------
		l_sTaskPath		= sta_globals.cSTAPrj.storagePath()+"/taskbuffer/svn"
		if not os.path.exists(l_sTaskPath):
			os.makedirs(l_sTaskPath)
		l_sSourceFile	= l_sTaskPath+"/content.dat"
		l_sDestFile		= str(p_cFile.iDBid)

		#--- Get file names -------------------------------------
		sRepPath	= sta_globals.sSCMRoot+p_cFile.sPath
		l_sPath = urllib.quote(sRepPath, ":/*~")
		l_errMsg	= ''

		try:
			l_cRevision = pysvn.Revision( pysvn.opt_revision_kind.date, p_cFile.iTime)
			lLogInfo = sta_globals.cSVNClient.log(l_sPath,peg_revision=l_cRevision, revision_start=l_cRevision,strict_node_history=False,discover_changed_paths=True)
		except pysvn.ClientError, e:
			l_errMsg = ''
			for message, code in e.args[1]:
				l_errMsg = l_errMsg+'Code: '+str(code)+' - '+message+"\n"
			self.MainThreadExec('self.logCommand(" ERROR: SVN\\n"+$STA$)',lParams=[l_errMsg])
			return

		l_sCPath = sRepPath
		l_lsFilePaths = [(-1,l_sCPath)]
		for i in lLogInfo:
			for j in i.changed_paths:
				if (j.copyfrom_path != None):
					if  l_sCPath.find(j.path) >= 0:
						l_sCPath = l_sCPath.replace(j.path,j.copyfrom_path)
						l_lsFilePaths.append(((i.revision).number,l_sCPath))
		l_lsFilePaths.reverse()

		#------------------------- Get files associated to selected releases ---
		sRepPath = l_lsFilePaths[0][1]

		for l_cRev in l_lsFilePaths:
			if (l_cRev[0] <= l_iRevision):
				sRepPath = l_cRev[1]
			else:
				break

		try:
			l_cRev = pysvn.Revision( pysvn.opt_revision_kind.number, l_iRevision)
			l_sPath = urllib.quote(sRepPath, ":/*~")
			l_sContent = sta_globals.cSVNClient.cat(l_sPath,revision = l_cRev,peg_revision=l_cRev)

			fileHandle=open(l_sSourceFile,"wb")
			fileHandle.write(l_sContent)
			fileHandle.close()

			sta_utils.addFileToArchive(p_sDestArchive,l_sSourceFile,l_sDestFile)

		except pysvn.ClientError, e:
			for message, code in e.args[1]:
				l_errMsg = l_errMsg+'Code: '+str(code)+' - '+message+"\n"
			self.MainThreadExec('self.logCommand(" ERROR: SVN\\n"+$STA$)',lParams=[l_errMsg])

#------------------------------------------------------ Select file selection ---
	def cbSelectionListSelect(self,evt):

		self.startTimelyAction()

		idx = self.mainFrame.g_listSelections.GetSelection()
		if (idx != wx.NOT_FOUND):

			self.bTreeHack = True
			self.mainFrame.g_listFiles.Unselect()

			#self.mainFrame.g_listFiles.Unselect()
			cSelection = self.mainFrame.g_listSelections.GetClientData(idx)
			cSelection.Apply()

			#Check if selected file is to be kept
			if sta_globals.bSelectedFile:
				l_bSw = False
				for i in sta_globals.lSelectedFiles:
					if (sta_globals.cSelectedFile.sPath == i.sPath):
						l_bSw = True
						break;
				sta_globals.bSelectedFile = l_bSw

			#------------------------- enable activity buttons ---
			if (len(sta_globals.lSelectedFiles) >0 or sta_globals.bSelectedFile):
				self.mainFrame.enableFileButtons(True)

		self.stopTimelyAction()

	def cbSelectionListMenu(self,evt):
		idx = self.mainFrame.g_listSelections.GetSelection()
		if (idx != wx.NOT_FOUND):
			self.mainFrame.g_listSelections.PopupMenu(self.mainFrame.cMenuSelections)

	def cbSelectionListMenu_Rename(self,evt):
		l_sName = self.mainFrame.g_listSelections.GetStringSelection()
		l_dlg = sta_gui.CInputTextDlg('Selection name','Input name: ',l_sName,self.mainFrame)
		l_iRetCode = l_dlg.ShowModal()
		if (l_iRetCode == wx.ID_OK):
			idx = self.mainFrame.g_listSelections.GetSelection()
			cSelection = self.mainFrame.g_listSelections.GetClientData(idx)
			cSelection.SetName(l_dlg.sText)
			self.mainFrame.g_listSelections.SetString(idx,l_dlg.sText)
		l_dlg.Destroy()

	def cbSelectionListMenu_Delete(self,evt):
		idx = self.mainFrame.g_listSelections.GetSelection()
		cSelection = self.mainFrame.g_listSelections.GetClientData(idx)
		sta_data.DeleteSelection(cSelection)
		self.mainFrame.g_listSelections.Delete(idx)

	def SelectItemAux(self,tItem):

		self.bTreeHack = True
		self.mainFrame.g_listFiles.SelectItem(tItem)

		sPlatform = sys.platform
		if (sPlatform[:5] == 'linux'):
			self.cbFileListSelect(0)

	def cbFileListOperations(self,evt):
		self.mainFrame.g_listFiles.PopupMenu(self.mainFrame.cMenuFileTree)

	def cbFileListSelect_CleanSelection(self,p_iSelection):

		cSelection = self.mainFrame.g_listSelections.GetClientData(p_iSelection)
		cSelection.UnApply()
		self.UpdateFilters()

	def cbFileListSelect(self,evt):

		#---- Hack to cope with double event generation ---

		sPlatform = sys.platform
		if (sPlatform[:3] == 'win'):
			if self.bTreeHack:
				self.bTreeHack	= False
				return

		self.bTreeHack	= False

		#------------------ get a list of selected files ---
		iFile   = self.mainFrame.g_listFiles.GetSelection()
		if iFile.IsOk():

			self.startTimelyAction()

			cFile	= self.mainFrame.g_listFiles.GetPyData(iFile)

			iRoot	= self.mainFrame.g_listFiles.GetRootItem()
			if (iFile != iRoot):
				iParent = self.mainFrame.g_listFiles.GetItemParent(iFile)
				cFolder = self.mainFrame.g_listFiles.GetPyData(iParent)

			l_iSelection = self.mainFrame.g_listSelections.GetSelection()

			#--- folder ---
			if (cFile.iType == 1):

				if (l_iSelection != wx.NOT_FOUND):
					self.mainFrame.g_listSelections.SetSelection(wx.NOT_FOUND)
					self.cbFileListSelect_CleanSelection(l_iSelection)

				sta_globals.bSelectedFile = False

				if sta_globals.cClusterEngine.HasClusters():
					sta_globals.cClusterEngine.Reset()

				for i in sta_globals.lDisplayedFilters_Project:
					i.cGUIList.HideMetric(0)

				self.UpdateTitle("   "+cFile.sPath+"   ")
				sta_globals.cSelectedFile = sta_data.STAFile()
				sta_globals.bSelectedFile = False
				sta_globals.cSelectedFolder = cFile
				sta_globals.lSelectedFiles = []
				for i in range(len(sta_globals.lFiles)):
					if (sta_globals.lFiles[i]).sPath.startswith(cFile.sPath) and (sta_globals.lFiles[i].iType == 0):
						sta_globals.lSelectedFiles.append(sta_globals.lFiles[i])

				self.UpdateSelectedFiles(True,wx.GetKeyState(wx.WXK_CONTROL))

			#--- file ---
			elif (cFile.iType == 0):

				# Verify if the selected files list needs to be updated
				l_bSelected = True
				for i in sta_globals.lSelectedFiles:
					if (cFile.sPath == i.sPath):
						l_bSelected = False
						break;

				if l_bSelected:

					if (l_iSelection != wx.NOT_FOUND):
						self.mainFrame.g_listSelections.SetSelection(wx.NOT_FOUND)
						self.cbFileListSelect_CleanSelection(l_iSelection)

					if sta_globals.cClusterEngine.HasClusters():
						sta_globals.cClusterEngine.Reset()

					for i in sta_globals.lDisplayedFilters_Project:
						i.cGUIList.HideMetric(0)

					self.UpdateTitle("   "+cFolder.sPath+"   ")
					sta_globals.cSelectedFolder = cFolder
					sta_globals.lSelectedFiles = []
					for i in range(len(sta_globals.lFiles)):
						if (sta_globals.lFiles[i]).sPath.startswith(cFolder.sPath) and (sta_globals.lFiles[i].iType == 0):
							sta_globals.lSelectedFiles.append(sta_globals.lFiles[i])
					self.UpdateSelectedFiles(True,False)

				sta_globals.cSelectedFile = cFile
				sta_globals.bSelectedFile = True
				self.RefreshEx()
			#---
			self.stopTimelyAction()
		#------------------------- enable activity buttons ---
		if (len(sta_globals.lSelectedFiles) >0 or sta_globals.bSelectedFile):
			self.mainFrame.enableFileButtons(True)

		self.UpdateTitle(sta_globals.cSelectedFolder.sPath)


#===============================================================================
#																Filter lists
#===============================================================================
	def auxFilterUpdate(self):
		self.mainFrame.project_filters.Layout()
		self.mainFrame.cListsSizer_Project.SetVirtualSizeHints(self.mainFrame.project_filters)

		self.glMixerCanvas_Project.computeContributions()
		self.glMixerCanvas_Project.RefreshEx()
		self.glCanvas.RefreshEx()

#----------------------------------------------------- Select project filter ---
	def cbProjectFilterSelect(self,evt):
		l_idx	   = evt.GetSelection()
		l_bState	= self.mainFrame.g_lFilters_Project.IsChecked(l_idx)

		l_sName	 = self.mainFrame.g_lFilters_Project.GetString(l_idx)

		l_cFilter   = sta_plugin.getPluginByName(sta_globals.lPlugins_Project,l_sName)
		l_sClass	= l_cFilter.sClass

		self.startTimelyAction()

		if l_bState:
			l_cFilter.loadMetric()
		else:
			l_cFilter.unloadMetric()

		l_cFilter.showFilterGUI(l_bState)

		self.glMixerCanvas_Project.lcUnits[l_sClass].bActive = l_bState

		self.auxFilterUpdate()

		self.stopTimelyAction()

#----------------------------------------------- Show attribute filter label ---
	def cbAttrNameLabel(self,evt):
		sta_globals.bAttrNameLabel = self.SettingsDialog.g_ckAttrNameLabel.IsChecked()
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.RefreshEx()
#---------------------------------------------- Show attribute record labels ---
	def cbAttrLabels(self,evt):
		sta_globals.bAttrLabels = self.SettingsDialog.g_ckAttrLabels.IsChecked()
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.RefreshEx()
#------------------------------------------------------- Show attribute grid ---
	def cbAttrGrid(self,evt):
		sta_globals.bAttrGrid   = self.SettingsDialog.g_ckAttrGrid.IsChecked()
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.RefreshEx()
#----------------------------------------------------- Show attribute labels ---
	def cbAttrTimeLabels(self,evt):
		sta_globals.bAttrTimeLabels = self.SettingsDialog.g_ckAttrTimeLabels.IsChecked()
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.RefreshEx()
#------------------------------------------------------- Show vertical scale ---
	def cbAttrVScale(self,evt):
		sta_globals.bAttrVScale = self.SettingsDialog.g_ckAttrVScale.IsChecked()
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.RefreshEx()


#/////////////////////////////////////////////////////////////////////////////////////////
#																		Data management
#/////////////////////////////////////////////////////////////////////////////////////////

#===============================================================================
#																File tree
#===============================================================================
#------------------------------------------------------------- Get file icon ---
	def getFileIcon(self,cFile):
		l_iRet = 0
		if len(cFile.lRevs)>0:
			l_iRet = 1
		return l_iRet

	def setFileTreeImage(self,l_cFile):
		l_iInfo = self.getFileIcon(l_cFile)
		self.mainFrame.g_listFiles.SetItemImage(self.dFileTreeItem[l_cFile.sPath],image=l_iInfo)

	def updateFileImages(self,items):
		for item in items:
			self.setFileTreeImage(item)
#------------------------------------------------------------ Save file tree ---
	def saveFileTree(self,p_lAddFiles,p_lDelFiles,p_lModFiles):
		self.addDBFiles(p_lAddFiles)
		self.modDBFiles(p_lModFiles)
		self.deleteDBFiles(p_lDelFiles,True)

#-------------------------------------------------------- Pre load file tree ---
	def preLoadFileTree(self):

		self.mainFrame.enableActivityButtons(False)
		self.mainFrame.g_bFileCancel.Enable()
		sta_globals.bActionCancel = False
		self.UpdateTitle()

		#------------- Clear displayed filters ---
		for i in sta_globals.lDisplayedFilters_Project:
			i.unloadMetric()

#------------------------------------------------------- Post load file tree ---
	def postLoadFileTree(self):

		sta_globals.bActionCancel = False
		self.mainFrame.enableActivityButtons(True)

		# Refresh filters
		self.UpdateFiltersList()

		# Expand file tree
		tRootItem = self.mainFrame.g_listFiles.GetRootItem()
		self.mainFrame.g_listFiles.Expand(tRootItem)
		self.SelectItemAux(tRootItem)

		# Update all data canvases
		self.glCanvas.bUpdate 		= True
		self.glVerticalCanvas.bUpdate 	= True
		self.glHorizontalCanvas.bUpdate = True
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.bUpdate	   = True

		# Update other canvases
		self.glMixerCanvas_Project.RefreshEx()

#-------------------------------------------------- FT add node to tree DATA ---
	def lFT_addNode(self,p_dNode,p_cFile):
		l_sLevel = self.lFT_lPath[self.lFT_iIndex]
		try:
			p_dNode[l_sLevel]
			if self.lFT_iIndex < self.lFT_iStop:
				self.lFT_iIndex = self.lFT_iIndex + 1
				self.lFT_addNode(p_dNode[l_sLevel],p_cFile)
		except:
			if self.lFT_iIndex < self.lFT_iStop:
				p_dNode[l_sLevel]={}
				self.lFT_iIndex = self.lFT_iIndex + 1
				self.lFT_addNode(p_dNode[l_sLevel],p_cFile)
			else:
				p_dNode[l_sLevel]=p_cFile

#-------------------------------------------------- Append file to tree DATA ---
	def appendFile(self,p_cFile):
		p_sFile = p_cFile.sPath

		# make sure we have a clean input in all situations
		if (p_sFile == ''):
			return
		p_sFile = p_sFile.replace('\\','/')
		if (p_sFile[0] == '/'):
			p_sFile = p_sFile[1:]
		if (p_sFile[-1] == '/'):
			p_sFile = p_sFile[:-1]

		self.lFT_lPath = p_sFile.split('/')

		self.lFT_iIndex = 0
		self.lFT_iStop = len(self.lFT_lPath)-1
		self.lFT_addNode(self.lFT_dTree,p_cFile)

	def removeFile(self,p_sFile):

		# make sure we have a clean input in all situations
		if (p_sFile == ''):
			return
		p_sFile = p_sFile.replace('\\','/')
		if (p_sFile[0] == '/'):
			p_sFile = p_sFile[1:]
		if (p_sFile[-1] == '/'):
			p_sFile = p_sFile[:-1]

		self.lFT_lPath = p_sFile.split('/')

		l_cNode = self.lFT_dTree
		for i in range(len(self.lFT_lPath)-1):
			l_cNode = l_cNode[self.lFT_lPath[i]]
		del l_cNode[self.lFT_lPath[-1]]

#-------------------------------------------- FT populate tree GUI with DATA ---
	def lFT_populate(self,p_tRootItem,p_dNode,p_sPath):
		for i in p_dNode.keys():

			l_tItem = self.mainFrame.g_listFiles.AppendItem(p_tRootItem,i)

			#----------------------------- file ---
			try:
				# if isinstance(p_dNode[i],sta_data.STAFile):
				p_dNode[i].sPath
				l_cFile = p_dNode[i]
				self.mainFrame.g_listFiles.SetPyData(l_tItem,l_cFile)
				self.dFileTreeItem[l_cFile.sPath]=l_tItem
				self.setFileTreeImage(l_cFile)
			#--------------------------- folder ---
			except:
				l_cFile		 = sta_data.STAFile()
				l_cFile.sPath	= p_sPath+i
				l_cFile.iType   = 1
				sta_globals.lFiles.append(l_cFile)

				self.mainFrame.g_listFiles.SetPyData(l_tItem,l_cFile)
				self.dFileTreeItem[l_cFile.sPath]=l_tItem
				self.mainFrame.g_listFiles.SetItemImage(l_tItem,image=4)

				l_cFile.sPath	= l_cFile.sPath + "/"
				self.lFT_populate(l_tItem,p_dNode[i],l_cFile.sPath)
			#--------------------------------------

#----------------------------------------------------------------- Load tree ---
	def loadFileTree(self):

		# Initialize file list
		self.mainFrame.g_listFiles.DeleteAllItems()
		self.dFileTreeItem = {}
		self.lFT_dTree = {}

		# Set root item
		cFile = sta_data.STAFile()
		cFile.sPath = "/"
		cFile.iType = 1
		tRootItem = self.mainFrame.g_listFiles.AddRoot(sta_globals.cSTAPrj.sName,image=3)
		self.mainFrame.g_listFiles.SetPyData(tRootItem,cFile)

		# Progress bar
		self.mainFrame.g_gFile.SetForegroundColour(self.cPrjProgress)
		self.mainFrame.g_gFile.Refresh()

		# Preload activities
		self.preLoadFileTree()

		#========================================= Read non DB data
		self.loadSnapshots()

		#========================================= Read info from history DB ===
		sta_globals.sDBPath = sta_globals.cSTAPrj.storagePath()+"/history.db"

		if not sta_utils.isValidDB(sta_globals.sDBPath):
			print 'DATA: no history information found'
			self.postLoadFileTree()
			return

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()

		#-------------------------------- Determine the number of operations ---
		# Detect number of files
		l_iNrFiles = 0
		if not sta_utils.isValidTable(cCursorDB,'Files'):
			print 'DATA: no files found '
			self.postLoadFileTree()
			cCursorDB.close()
			cDB.close()
			return

		sCmd = "select count(ID) from Files"
		cCursorDB.execute(sCmd)
		l_iNrFiles = cCursorDB.fetchone()[0]

		# Detect number of versions
		l_iNrVersions = 0
		if sta_utils.isValidTable(cCursorDB,'Versions'):
			sCmd = "select count(ID) from Versions"
			cCursorDB.execute(sCmd)
			l_iNrVersions = cCursorDB.fetchone()[0]
		else:
			print 'DATA: no versions found '

		l_iTotalProgress = l_iNrFiles + l_iNrVersions
		self.mainFrame.g_gFile.SetRange(l_iTotalProgress)
		l_iProgress = 0
		l_iProgressPercentage = 0

		#--------------------------------------------- Read file information ---
		self.mainFrame.statusbar.SetStatusText(" Recovering file tree ...",0)

		#Reserve space for the files
		sta_globals.lFiles = [0 for i in range(l_iNrFiles)]

		sCmd = "select ID,Path,Type,Time from Files"
		cCursorDB.execute(sCmd)

		l_iIdx = 0
		for i in cCursorDB:

			#l_sFile = base64.b64decode(i[1])

			l_cFile = self.createFile(i)

			sta_globals.lFiles[l_iIdx] = l_cFile
			self.appendFile(l_cFile)   # Here the file tree is constructed

			l_iProgress = l_iProgress + 1
			self.mainFrame.g_gFile.SetValue(l_iProgress)

			l_iProgressPercentage_new = l_iProgress*10/l_iTotalProgress
			if l_iProgressPercentage != l_iProgressPercentage_new:
				l_iProgressPercentage = l_iProgressPercentage_new
				wx.Yield()

			l_iIdx = l_iIdx + 1

		#------------------------------------------ Read version information ---
		if l_iNrVersions > 0:
			self.mainFrame.statusbar.SetStatusText(" Loading version info ...",0)

			sCmd = "select ID,File,Name,Time from Versions"

			filesMap = dict((int(item.iDBid), item) for item in sta_globals.lFiles)

			cCursorDB.execute(sCmd)
			for i in cCursorDB:
				if sta_globals.bActionCancel:
					 sta_globals.bActionCancel = False
					 break

				l_cCommit = self.createCommit(i)

				#Add commit to file
				l_cFile = filesMap[int(i[1])]
				l_cFile.lRevs.append(l_cCommit)			 #TODO: Speed this up
				l_cFile.iNrRevs = l_cFile.iNrRevs+1

				l_iProgress = l_iProgress + 1
				self.mainFrame.g_gFile.SetValue(l_iProgress)

				l_iProgressPercentage_new = l_iProgress*10/l_iTotalProgress
				if l_iProgressPercentage != l_iProgressPercentage_new:
					l_iProgressPercentage = l_iProgressPercentage_new
					wx.Yield()

		#----------------------------------------- Update file information ---
		if l_iNrVersions > 0:
			for i in sta_globals.lFiles:
				sta_data.FinalizeFileInfo(i)
		#=======================================================================
		cCursorDB.close()
		cDB.close()
		#---------------------------------------- Finalize file tree display ---
		# Stop displaying progress
		self.mainFrame.statusbar.SetStatusText("",0)
		self.mainFrame.g_gFile.SetRange(0)

		# Populate the file tree list with the files
		self.lFT_populate(tRootItem,self.lFT_dTree,"/")

		# Post load activities
		self.postLoadFileTree()

	def createFile(self, row):
		l_cFile		 	= sta_data.STAFile()
		l_cFile.sPath	= row[1]
		l_cFile.iDBid	= row[0]
		l_cFile.iStatus = int(row[2])
		l_cFile.iTime	= int(row[3])

		l_cFile.prepare()

		l_iNamePos = l_cFile.sPath.rfind("/")+1
		if l_iNamePos>=0:
			l_cFile.sName = l_cFile.sPath[l_iNamePos:]
		else:
			l_cFile.sName = l_cFile.sPath

		return l_cFile

	def createCommit(self, row):
		l_cCommit		 = sta_data.STACommit()
		l_cCommit.sID	 = str(row[2])
		l_cCommit.iDBid	 = row[0]
		l_cCommit.iTime	 = row[3]

		return l_cCommit


	def loadSnapshots(self):
		sta_globals.cSTAPrj.lSnapshots = []
		l_sPath = sta_globals.cSTAPrj.storagePath()+"/extra/snapshots/list.dat"
		if os.path.exists(l_sPath):
			fileHandle=open(l_sPath,'r')
			l_lLines = fileHandle.readlines()
			for l_sLine in l_lLines:
				l_sLine = l_sLine.rstrip()
				l_iTime,l_sName = l_sLine.split(',')
				l_iTime = int(l_iTime)
				sta_globals.cSTAPrj.lSnapshots.append([l_iTime,l_sName])
			fileHandle.close()
			sta_globals.cSTAPrj.lSnapshots.sort(cmp=lambda x,y: cmp(x[0],y[0]))

	def saveSnapshots(self):
		if (sta_globals.cSTAPrj.sName == ''):
			return
		l_sPath = sta_globals.cSTAPrj.storagePath()+"/extra/snapshots"
		if not os.path.exists(l_sPath):
			os.makedirs(l_sPath)
		fileHandle=open(l_sPath+"/list.dat",'w')
		for l_cSnapshot in sta_globals.cSTAPrj.lSnapshots:
			fileHandle.write("%d,%s\n"%tuple(l_cSnapshot))
		fileHandle.close()
#===============================================================================
#																Projects
#===============================================================================

#------------------------------------------------- Update project statistics ---
	def saveProjectStatistics(self,l_cPrj):

		sPath = l_cPrj.storagePath()+"/statistics.dat"
		fileHandle=open(sPath,"w")
		fileHandle.write("%d\n"%l_cPrj.iFiles)
		fileHandle.write("%s\n"%l_cPrj.sDate)
		fileHandle.close()

#--------------------------------------------------- Load project statistics ---
	def loadProjectStatistics(self,l_cPrj):
		sPath = l_cPrj.storagePath()+"/statistics.dat"
		if os.path.exists(sPath):
			fileHandle=open(sPath,"r")

			sLine = fileHandle.readline()
			sLine = sLine.rstrip()
			l_cPrj.iFiles = int(sLine)

			sLine = fileHandle.readline()
			sLine = sLine.rstrip()
			l_cPrj.sDate = sLine

			fileHandle.close()

#----------------------------------------------------------- Update projects ---
	def updateProjects(self,iUpdate = 0):
		self.loadProjects(iUpdate)
#-------------------------------------------------------------- Save project ---
	def saveProject(self,cPrj):

		l_sPath = cPrj.storagePath()
		if not os.path.exists(l_sPath):
			os.makedirs(l_sPath)

		fileHandle=open(l_sPath+"/prj.dat","w")
		fileHandle.write(cPrj.sName+"\n")
		fileHandle.write(cPrj.sType+"\n")
		fileHandle.write(cPrj.sAddress+"\n")
		fileHandle.write(cPrj.sFolder+"\n")
		fileHandle.write(cPrj.sProtocol+"\n")
		fileHandle.write(cPrj.sModule+"\n")
		fileHandle.write(cPrj.sUser+"\n")
		fileHandle.close()
#------------------------------------------------------------- Load projects ---
	def loadProjects(self,iUpdate = 0):
		sta_globals.lProjects = []

		sPath = sta_globals.sStartDir+"/data"
		if not os.path.exists(sPath):
				os.makedirs(sPath)

		l_lProjects = os.listdir("data")
		for l_sProjectPath in l_lProjects:

			if os.path.exists(sPath+'/'+l_sProjectPath+"/prj.dat"):

				fileHandle=open("data/"+l_sProjectPath+"/prj.dat","r")
				l_cSTAPrj = sta_data.STAPrj()

				sLine = fileHandle.readline()
				sLine = sLine.rstrip()
				l_cSTAPrj.sName = sLine

				sLine = fileHandle.readline()
				sLine = sLine.rstrip()
				l_cSTAPrj.sType = sLine

				sLine = fileHandle.readline()
				sLine = sLine.rstrip()
				l_cSTAPrj.sAddress = sLine

				sLine = fileHandle.readline()
				sLine = sLine.rstrip()
				l_cSTAPrj.sFolder = sLine

				sLine = fileHandle.readline()
				sLine = sLine.rstrip()
				l_cSTAPrj.sProtocol = sLine

				sLine = fileHandle.readline()
				sLine = sLine.rstrip()
				l_cSTAPrj.sModule = sLine

				sLine = fileHandle.readline()
				sLine = sLine.rstrip()
				l_cSTAPrj.sUser = sLine

				l_cSTAPrj.sPass = ""

				l_cSTAPrj.calculatePath()

				self.loadProjectStatistics(l_cSTAPrj)

				sta_globals.lProjects.append(l_cSTAPrj)
				fileHandle.close()

		self.OpenProjectDialog.g_listProjects.DeleteAllItems()
		for i in sta_globals.lProjects:
			self.OpenProjectDialog.AddProject(i)
		self.OpenProjectDialog.InitView()

		if iUpdate == 0:
			self.OpenProjectDialog.g_listProjects.Enable(True)
			self.mainFrame.cMenuFile.Enable(10102,True)

#------------------------------------------------------------ Export project ---
	def cbExportProject(self):

		if (sta_globals.cSTAPrj.sName == ''):
			l_sMsg = 'WARNING: No project data available for export!'
			l_cDlg = wx.MessageDialog(self.mainFrame, l_sMsg, caption = 'Import project data', style = wx.OK | wx.ICON_ERROR)
			l_cDlg.ShowModal()
			l_cDlg.Destroy()
			return

		self.mainFrame.enableActivityButtons(False)
		l_cDlg = wx.FileDialog(self.mainFrame,wildcard="SolidSTA archive (*.sta)|*.sta",style=wx.FD_SAVE)
		if (l_cDlg.ShowModal() == wx.ID_OK):
			l_sArchivePath = l_cDlg.GetPath()
			if os.path.exists(l_sArchivePath):
				os.remove(l_sArchivePath)
			l_sSrcPath = sta_globals.cSTAPrj.storagePath()
			l_iLenPath = len(sta_globals.sStartDir+"/data/")
			l_lFiles = []
			for root, dirs, files in os.walk(l_sSrcPath):
				for name in files:
					l_sSrcFile = os.path.join(root, name)
					l_sSrcFile = os.path.realpath(l_sSrcFile)
					l_lFiles.append(l_sSrcFile)
			self.mainFrame.g_gFile.SetRange(len(l_lFiles))
			l_iProgress = 0
			for l_sSrcFile in l_lFiles:
					l_sDestFile = l_sSrcFile[l_iLenPath:]
					sta_utils.addFileToArchive(l_sArchivePath,l_sSrcFile,l_sDestFile)
					l_iProgress += 1
					self.mainFrame.g_gFile.SetValue(l_iProgress)
					self.Yield()
			self.mainFrame.g_gFile.SetRange(0)
		l_cDlg.Destroy()
		self.mainFrame.enableActivityButtons(True)
#------------------------------------------------------------ Import project ---
	def cbImportProject(self):

		self.mainFrame.enableActivityButtons(False)

		l_bError = False
		l_cDlg = wx.FileDialog(self.mainFrame,wildcard="SolidSTA archive (*.sta)|*.sta",style=wx.FD_OPEN)
		if (l_cDlg.ShowModal() == wx.ID_OK):
			l_sArchivePath = l_cDlg.GetPath()
			try:
				l_lFiles = sta_utils.listArchive(l_sArchivePath)
				l_sDstPath = sta_globals.sStartDir+"/data/"
				self.mainFrame.g_gFile.SetRange(len(l_lFiles))
				l_iProgress = 0
				for l_sSrcFile in l_lFiles:
					l_sDestFile = l_sDstPath+l_sSrcFile
					l_sDstFolder = os.path.dirname(l_sDestFile)
					if not(os.path.exists(l_sDstFolder)):
						os.makedirs(l_sDstFolder)
					l_sContent = sta_utils.readFile(l_sArchivePath,l_sSrcFile)
					fileHandle = open(l_sDestFile,'wb')
					fileHandle.write(l_sContent)
					fileHandle.close()
					l_iProgress += 1
					self.mainFrame.g_gFile.SetValue(l_iProgress)
					self.Yield()
			except:
				l_bError = True

			l_cDlg.Destroy()
			self.mainFrame.g_gFile.SetRange(0)
			self.mainFrame.enableActivityButtons(True)
		else:
			l_cDlg.Destroy()
			self.mainFrame.g_gFile.SetRange(0)
			self.mainFrame.enableActivityButtons(True)
			return

		if (l_bError):
			l_sMsg = 'ERROR: Could not import SolidSTA archive'
			l_cDlg = wx.MessageDialog(self.mainFrame, l_sMsg, caption = 'Import project data', style = wx.OK | wx.ICON_ERROR)
			l_cDlg.ShowModal()
			l_cDlg.Destroy()
			return

		l_bError = True
		l_sSampleFile = l_lFiles[0]
		self.updateProjects(1)
		for l_cProject in sta_globals.lProjects:
			l_cProject.calculatePath()
			if l_sSampleFile.startswith(l_cProject.sPath):
				sta_globals.cSTAPrj = l_cProject
				l_bError = False
				break

		if (l_bError):
			l_sMsg = 'ERROR: Could not load imported project'
			l_cDlg = wx.MessageDialog(self.mainFrame, l_sMsg, caption = 'Import project data', style = wx.OK | wx.ICON_ERROR)
			l_cDlg.ShowModal()
			l_cDlg.Destroy()
			return

		self.cbPrjLoad_aux()

#/////////////////////////////////////////////////////////////////////////////////////////
#																		Utils
#/////////////////////////////////////////////////////////////////////////////////////////
	def cbWorkerFileDialog(self):

		sFilePath = ''
		l_cDlg = wx.FileDialog(sta_globals.GUI.mainFrame)
		if (l_cDlg.ShowModal() == wx.ID_OK):
			sFilePath = l_cDlg.GetPath()
		sta_globals.cWorkersQueue.put(sFilePath)

#===============================================================================
#															Update selections
#===============================================================================

#----------------------------------------------------- Update selected files ---
	def UpdateSelectedFiles(self,p_bSelectionKind,p_bSave,p_bFitToScreen=True):

		sta_globals.bFolderSelection = p_bSelectionKind

		if p_bSave:
			sPath = sta_globals.cSTAPrj.storagePath()+"/extra/selections"
			if not os.path.exists(sPath):
				os.makedirs(sPath)

			bSave = True
			if sta_globals.bFolderSelection:
				if sta_data.IsSelectionSaved(sta_globals.cSelectedFolder.sPath):
					bSave = False

					cSelection = sta_data.GetSelectionByName(sta_globals.cSelectedFolder.sPath)
					cSelection.Refresh()
					cSelection.Save()

			if bSave:
				cSelection		= sta_data.STASelection(sPath)
				cSelection.iID	= sta_data.GetFreeSelectionID()
				cSelection.LoadCurrent(p_bSelectionKind,sta_globals.cSelectedFolder.sPath)
				sta_data.AddSelection(cSelection)

			l_iItem = self.mainFrame.g_listSelections.FindString(cSelection.sName)
			if (l_iItem != wx.NOT_FOUND):
				self.mainFrame.g_listSelections.SetSelection(l_iItem)

		self.UpdateSortMode(1)
		sta_globals.cClusterEngine.Cancel()

		#---------- find start / stop times for the list ---
		sta_globals.iSelectedFilesStartTime	= 0
		sta_globals.iSelectedFilesEndTime 	= 0
		sta_globals.iSelectedFilesInterval	= 0

		for i in sta_globals.lSelectedFiles:
			if (sta_globals.iSelectedFilesStartTime == 0) or ((sta_globals.iSelectedFilesStartTime > i.iStart) and (i.iStart!=0)):
				sta_globals.iSelectedFilesStartTime = i.iStart
			if (sta_globals.iSelectedFilesEndTime == 0) or (sta_globals.iSelectedFilesEndTime < i.iEnd):
				sta_globals.iSelectedFilesEndTime = i.iEnd
		sta_globals.iSelectedFilesInterval = sta_globals.iSelectedFilesEndTime - sta_globals.iSelectedFilesStartTime

		# speculative update of iProjectEndTime and iProjectStartTime
		if sta_globals.iProjectEndTime < sta_globals.iSelectedFilesEndTime:
			sta_globals.iProjectEndTime = sta_globals.iSelectedFilesEndTime

		if (sta_globals.iProjectStartTime > sta_globals.iSelectedFilesStartTime) and (sta_globals.iSelectedFilesStartTime != 0):
			sta_globals.iProjectStartTime = sta_globals.iSelectedFilesStartTime

		#---------------------------------------------------
		self.mainFrame.statusbar.SetStatusText(" Displayed files: "+str(len(sta_globals.lSelectedFiles)),2)

		self.glCanvas.bUpdate = p_bFitToScreen
		if not self.glCanvas.bUpdate:
			self.glCanvas.updateRatios()
			self.glCanvas.updatePosition()

		self.glCanvas.RefreshEx()			# Solve horizontal metric month display issue
		self.glVerticalCanvas.RefreshEx()

		self.glHorizontalCanvas.bUpdate = True
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.bUpdate	   = True

		workItems = sta_plugin.getPluginByName(sta_globals.lPlugins_Project, 'TFS Work Items')
		if workItems != 0:
			workItems.ReloadTable()

		self.RefreshEx()

#------------------------------------------------------------ Update filters ---
	def UpdateFiltersList(self):						# Updates the list of available filters
		self.ComputeMetricsDialog.metrics_lMetrics.Clear()
		sta_globals.lMetrics = []
		if not sta_utils.isValidDB(sta_globals.sDBPath):
			self.UpdateFilters()
			return

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()

		if sta_utils.isValidTable(cCursorDB,'Metrics'):

			sCmd = "select ID,Name,Description,Dependencies from Metrics"
			cCursorDB.execute(sCmd)
			for i in cCursorDB:
				l_cMetric = sta_data.STAMetric(i[0],i[1],i[2],i[3])
				l_idx = self.ComputeMetricsDialog.metrics_lMetrics.Append(l_cMetric.sName)
				self.ComputeMetricsDialog.metrics_lMetrics.SetClientData(l_idx,l_cMetric)
				sta_globals.lMetrics.append(l_cMetric)

		cDB.commit()
		cCursorDB.close()
		cDB.close()

		self.UpdateFilters()

	def UpdateFilters(self):							# Update filters contents
		# TODO: Change the list style for filters
		#--------------------- Project filters ---
		for i in sta_globals.lPlugins_Project:
			if i.enableFilter():
				if i.bGUIDisplayed:		 	# Reload displayed filters
					i.reloadMetric()
		#------------------------------------------
		self.auxFilterUpdate()
	def HideFilterMetrics(self):						# Hide filter metrics
		for i in sta_globals.lPlugins_Project:
			if i.bGUIDisplayed:
				i.cGUIList.HideMetric(0)

	def RefreshFilterMetrics(self):					# Refresh filter metrics
		for i in sta_globals.lPlugins_Project:
			if i.bGUIDisplayed:
				i.cGUIList.RefreshMetric()

#===============================================================================
#															Refresh windows
#===============================================================================
	def RefreshEx(self):
		self.glCanvas.RefreshEx()
		self.glHorizontalCanvas.RefreshEx()
		self.glVerticalCanvas.RefreshEx()
		self.glMixerCanvas_Project.RefreshEx()
		for i in sta_globals.dAttrEvolution.values():
			i.g_GLPanel.RefreshEx()

	def UpdateTitle(self,sFolder=""):

		if sta_globals.bSelectedFile:
			sFile = sta_globals.cSelectedFile.sName
		else:
			sFile = ''

		if sFolder != "":
			self.mainFrame.SetTitle(sta_globals.sProjectName+": "+sta_globals.cSTAPrj.sName+" ("+sFolder+") "+sFile)
		else:
			self.mainFrame.SetTitle(sta_globals.sProjectName+": "+sta_globals.cSTAPrj.sName+" "+sFile)

	def SetPluginMarkers(self,nr):
		for i in sta_globals.lPlugins_Project:
			mi = i.cGUIList.cMenu.FindItemById(209+nr)
			if mi.IsChecked():
				mi.Check(False)


#===============================================================================
#																Info Display
#===============================================================================
	def auxGetAuthor(self,cCommit):
		if 'author_name' in cCommit.lValues.keys():
			return cCommit.lValues['author_name']
		else:
			l_sAuthor = ''
			if not sta_utils.isValidDB(sta_globals.sDBPath):
				return l_sAuthor

			cDB = sqlite.connect(sta_globals.sDBPath)
			cCursorDB = cDB.cursor()

			if sta_utils.isValidTable(cCursorDB,'M_SS2007010101'):
				sCmd = "select Name from M_SS2007010101 where ID="+str(cCommit.iDBid)
				cCursorDB.execute(sCmd)
				l_sAuthor = cCursorDB.fetchone()[0]

			cCursorDB.close()
			cDB.close()

			return l_sAuthor

	def auxGetComment(self,cCommit):
		if 'comment_data' in cCommit.lValues.keys():
			return cCommit.lValues['comment_data']

		l_sComment = ''
		if not sta_utils.isValidDB(sta_globals.sDBPath):
			return l_sComment

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()

		if sta_utils.isValidTable(cCursorDB,'M_SS2007010102'):
			sCmd = "select Name from M_SS2007010102 where ID="+str(cCommit.iDBid)
			cCursorDB.execute(sCmd)
			l_sComment = cCursorDB.fetchone()[0]
			if l_sComment is None:
				l_sComment = ''
			cCommit.lValues['comment_data'] = l_sComment

		cCursorDB.close()
		cDB.close()

		return l_sComment

	def cbBrush(self,cFile,cCommit,sPointDate,bFull):

		#--------------------------------------------- Flicker free ---
		if bFull:
			if ((cCommit.sID == self.sDetail[1]) and (cFile.sPath == self.sDetail[0])):
				self.mainFrame.statusbar.SetStatusText(sPointDate,6)
				return
			else:
				self.sDetail[0] = cFile.sPath
				self.sDetail[1] = cCommit.sID
		else:
			if ((cFile.sPath == self.sDetail[0]) and (cFile.sPath == '')):
				self.mainFrame.statusbar.SetStatusText(sPointDate,6)
				return
			else:
				self.sDetail[0] = cFile.sPath
				self.sDetail[1] = ''

		#--------------------------- Verify presence of Find filter ---
		l_cFindFilter = sta_plugin.getPluginByName(sta_globals.lPlugins_Project,'Find text')
		if l_cFindFilter != 0:
			if l_cFindFilter.bGUIDisplayed:
				l_FindFilterAvailable = True
				l_lFind = l_cFindFilter.cGUIList.GetSelections()
			else:
				l_FindFilterAvailable = False
		else:
			l_FindFilterAvailable = False

		#-------------------------- Get DATA for author and Comment ---
		if bFull:
			l_sDATA_Comment = self.auxGetComment(cCommit)
			l_sDATA_Author  = self.auxGetAuthor(cCommit)

		#--------------------------------------- Display information ---
		self.mainFrame.statusbar.SetStatusText(cFile.sName,0)
		self.InfoDialog.g_tInfo.SetValue("")
		if bFull:
			self.mainFrame.statusbar.SetStatusText("Version: "+cCommit.sID,3)
			if l_sDATA_Author  != '':
				self.mainFrame.statusbar.SetStatusText("Author : "+l_sDATA_Author,4)

			l_iPos = cCommit.sID.rfind('.')+1

			self.mainFrame.statusbar.SetStatusText(sta_utils.getDate(cCommit.iTime),5)

			self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr2)
			self.InfoDialog.g_tInfo.AppendText("File\t: ")
			self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr1)
			self.InfoDialog.g_tInfo.AppendText(cFile.sName+"\n")

			self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr2)
			self.InfoDialog.g_tInfo.AppendText("Path\t: ")
			self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr1)
			self.InfoDialog.g_tInfo.AppendText(cFile.sPath+"\n")

			if l_sDATA_Author  != '':
				self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr2)
				self.InfoDialog.g_tInfo.AppendText("User\t: ")
				self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr1)
				self.InfoDialog.g_tInfo.AppendText(l_sDATA_Author+"\n")

			self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr2)
			self.InfoDialog.g_tInfo.AppendText("Ver.\t: ")
			self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr1)
			self.InfoDialog.g_tInfo.AppendText(cCommit.sID+"\n\n")

			if not l_FindFilterAvailable:
			#-------------------------------- Find information NOT available ---
				self.InfoDialog.g_tInfo.AppendText(l_sDATA_Comment)
			#------------------------------------ Find information available ---
			else:
				l_sComment 			= l_sDATA_Comment
				l_sOriginalComment	  = l_sDATA_Comment
				l_bSw 	= True
				while l_bSw:
					l_bSw 		= False
					l_iMinIdx 			= -1
					l_sMinElement 	= ''

					for i in l_lFind:
						l_iIdx = l_sComment.find(i)
						if ((l_iIdx > 0) and (l_iIdx<l_iMinIdx)) or (l_iMinIdx<0):
							l_iMinIdx = l_iIdx
							l_sMinElement = i

					if l_iMinIdx >= 0:
						l_bSw = True
						l_sWord = l_sMinElement
						l_sOutput = l_sComment[:l_iMinIdx]
						self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr1)
						self.InfoDialog.g_tInfo.AppendText(l_sOutput)

						l_lColor = l_cFindFilter.cGUIList.lColors[l_cFindFilter.cGUIList.dColors[l_sWord]]
						l_cColour = wx.Colour(l_lColor[0]*255,l_lColor[1]*255,l_lColor[2]*255)
						self.cAttr3.SetBackgroundColour(l_cColour)

						self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr3)
						self.InfoDialog.g_tInfo.AppendText(l_sWord)
						l_sComment = l_sComment[(l_iMinIdx+len(l_sWord)):]
				if l_sComment == l_sOriginalComment:
					self.InfoDialog.g_tInfo.AppendText(l_sComment)
				else:
					self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr1)
					self.InfoDialog.g_tInfo.AppendText(l_sComment)
				#--------------------------------------------------

			workItems = sta_plugin.getPluginByName(sta_globals.lPlugins_Project, 'TFS Work Items')
			if workItems != 0:
				workItems.HighlightWorkItems(cCommit)
		else:
			self.mainFrame.statusbar.SetStatusText("",3)
			self.mainFrame.statusbar.SetStatusText("",4)
			self.mainFrame.statusbar.SetStatusText("",5)

			self.InfoDialog.g_tInfo.SetValue("")

			workItems = sta_plugin.getPluginByName(sta_globals.lPlugins_Project, 'TFS Work Items')
			if workItems != 0:
				workItems.UnhighlightAll()

			self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr2)
			self.InfoDialog.g_tInfo.AppendText("File\t: ")
			self.InfoDialog.g_tInfo.SetDefaultStyle(self.cAttr1)
			self.InfoDialog.g_tInfo.AppendText(cFile.sName+"\n")

		self.mainFrame.statusbar.SetStatusText(sPointDate,6)
		self.InfoDialog.g_tInfo.ShowPosition(0)



	def cbBrushClear(self):
		self.mainFrame.statusbar.SetStatusText("",0)
		self.mainFrame.statusbar.SetStatusText("",2)
		self.mainFrame.statusbar.SetStatusText("",3)
		self.mainFrame.statusbar.SetStatusText("",4)
		self.mainFrame.statusbar.SetStatusText("",5)
		self.mainFrame.statusbar.SetStatusText("",6)

		self.InfoDialog.g_tInfo.SetValue("")

		workItems = sta_plugin.getPluginByName(sta_globals.lPlugins_Project, 'TFS Work Items')
		if workItems != 0:
			workItems.UnhighlightAll()

		self.iCommentLinePosition = 0

	def logCommand(self,p_sMsg):

		sta_utils.dprint(p_sMsg)
		self.LogDialog.logCommand(p_sMsg)

#/////////////////////////////////////////////////////////////////////////////////////////
#																			Start program
#/////////////////////////////////////////////////////////////////////////////////////////
if __name__ == "__main__":

	import psyco
	psyco.full()

	sta_globals.fileDebug = open('./cfg/debug.log','w')

	#----------------------------------------------- Launch GUI
	cSTA = STA(0)
	cSTA.MainLoop()
	os.chdir(sStartPath)

	#----- Close program
	exit_program(0)

#///////////////////////////////////////////////////////////////////////////////
#										E N D
#///////////////////////////////////////////////////////////////////////////////
