#*****************************************************************************************
# Name			: TFS C# Dependencies
# File			: mextDependencies.py
# Description	: A plugin for extracting dependencies from C# from TFS
# Version		: 1.0
#*****************************************************************************************

import wx
import sta_metricgenerator
import sys
import os
import sta_utils
import sta_globals

class CAnalyzeDialog(wx.Dialog):
	def __init__(self, *args, **kwds):
		# begin wx.Glade: CAnalyzeDialog.__init__
		self.cParentFrame = args[0]

		kwds["style"] = wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)

		self.box = wx.StaticBox(self, -1, "Optionally specify which versions to analyze")

		self.startVersionLabel = wx.StaticText(self, -1, "Start version	")
		self.startVersionField = wx.TextCtrl(self, -1, "")
		self.everyNthLabel = wx.StaticText(self, -1, "Only every N-th version")
		self.everyNthField = wx.TextCtrl(self, -1, "")

		self.okButton = wx.Button(self, -1, "Ok")
		self.cancelButton = wx.Button(self, -1, "Cancel")

		self.okButton.Bind(wx.EVT_BUTTON,self.OnOK)
		self.cancelButton.Bind(wx.EVT_BUTTON,self.OnCancel)

		self.__set_properties()
		self.__do_layout()
		# end wx.Glade

	def __set_properties(self):
		# begin wx.Glade: CAnalyzeDialog.__set_properties
		self.SetTitle("Analyze settings")
		self.startVersionField.SetMinSize((150, -1))
		self.everyNthField.SetMinSize((150, -1))
		# end wx.Glade

	def __do_layout(self):
		# begin wx.Glade: CAnalyzeDialog.__do_layout
		grid_sizer_1 = wx.FlexGridSizer(2, 1, 0, 0)
		sizer_4 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_11 = wx.StaticBoxSizer(self.box, wx.HORIZONTAL)
		self.grid_sizer_3_copy = wx.FlexGridSizer(8, 2, 0, 0)
		self.grid_sizer_3_copy.Add(self.startVersionLabel, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.startVersionField, 0, wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.everyNthLabel, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.everyNthField, 0, wx.ADJUST_MINSIZE, 0)

		self.grid_sizer_3_copy.AddGrowableCol(1)
		sizer_11.Add(self.grid_sizer_3_copy, 1, wx.EXPAND, 0)
		grid_sizer_1.Add(sizer_11, 1, wx.ALL|wx.EXPAND, 4)
		sizer_4.Add(self.okButton, 0, wx.RIGHT|wx.FIXED_MINSIZE, 5)
		sizer_4.Add(self.cancelButton, 0, wx.LEFT|wx.FIXED_MINSIZE, 5)
		grid_sizer_1.Add(sizer_4, 1, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 4)
		self.SetSizer(grid_sizer_1)
		grid_sizer_1.Fit(self)
		grid_sizer_1.SetSizeHints(self)
		grid_sizer_1.AddGrowableRow(0)
		grid_sizer_1.AddGrowableCol(0)
		self.Layout()
		# end wx.Glade

	def OnCancel(self,event):
		self.EndModal(wx.ID_CANCEL)

	def OnOK(self,event):
		self.EndModal(wx.ID_OK)

#===============================================================================
#												  Basic metric generator plugin
#===============================================================================
class MetricGenerator(sta_metricgenerator.MetricGenerator):
	def __init__(self,*args, **kwds):
		sta_metricgenerator.MetricGenerator.__init__(self,*args, **kwds)
		self.sName		= 'C# dependencies extractor'
		self.sAuthor	= 'Robbert-Jan Pijpker & Joost Koehoorn extended for GIT by Timon Back & Klaas Kliffen'
		self.sVersion	= '1.0'
		self.sID		= 'TFSDeps'

		self.sInfo		= '<strong>Description:</strong><br />'
		self.sInfo		= self.sInfo + 'Extracts C# dependencies by static analysis of C# repositories.<br /><br />'

		self.sInfo		= self.sInfo + '<strong>Requires:</strong><br />'
		self.sInfo		= self.sInfo + 'A C# repository with .sln file<br /><br />'

#===============================================================================
#																	 Generate
#===============================================================================

	#---------------------------------------------------------------- Main entry ---

	def preGenerate(self):
		if not sta_utils.isValidDB(sta_globals.sDBPath):
			sta_globals.GUI.MainThreadExec('self.logCommand(" ERROR: no history information found\\n")')
			sta_globals.GUI.MainThreadExec('self.postGenerator()')
			return False

		if sta_globals.cSTAPrj.sType != 'GIT' and sta_globals.cSTAPrj.sType != 'TFS':
			sta_globals.GUI.MainThreadExec('self.logCommand(" ERROR: dependencies may only be extracted for TFS repos.\\n")')
			sta_globals.GUI.MainThreadExec('self.postGenerator()')
			return False

		dlg = CAnalyzeDialog(sta_globals.GUI.mainFrame)

		result = dlg.ShowModal() == wx.ID_OK

		self.sVersion = dlg.startVersionField.GetValue()
		self.sEveryNth = dlg.everyNthField.GetValue()

		dlg.Destroy()

		return result

	def generate(self,p_sDBPath):
		sta_globals.GUI.TFSImporter('dependencies', args=['--version', self.sVersion, '--every', self.sEveryNth])

		sta_globals.GUI.MainThreadExec('self.UpdateFiltersList()')
		sta_globals.GUI.MainThreadExec('self.logCommand(" Finished: "+$STA$+" generation completed\\n")',lParams=[self.sName])

		sta_globals.GUI.MainThreadExec('self.postGenerator()')
