import wx
import wx.calendar

class CCalendar(wx.Dialog):
	def __init__(self,p_iTime,*args, **kwds):
		
		self.iTime = p_iTime
		
		wx.Dialog.__init__(self, *args, **kwds)
		
		#------------------- GUI
		self.cal = wx.calendar.CalendarCtrl(self, -1, wx.DateTime_Now(),
							style = wx.calendar.CAL_SHOW_HOLIDAYS
							| wx.calendar.CAL_SUNDAY_FIRST
							| wx.calendar.CAL_SEQUENTIAL_MONTH_SELECTION
							)
		l_cDate = wx.DateTime()
		l_cDate.SetTimeT(p_iTime)
		self.cal.SetDate(l_cDate)
							 
		#------------------- Ok/Cancel Buttons
		l_gButOk 		= wx.Button(self,-1,'Select')
		l_gButCancel 	= wx.Button(self,-1,'Cancel')
		szButtons = wx.BoxSizer(wx.HORIZONTAL)		
		szButtons.Add(l_gButOk,0,wx.FIXED_MINSIZE|wx.ALL,2) 
		szButtons.Add(l_gButCancel,0,wx.FIXED_MINSIZE|wx.ALL,2) 
		
		#------------------- Main sizer
		szMain			= wx.BoxSizer(wx.VERTICAL)
		szMain.Add(self.cal,1, wx.EXPAND|wx.ALL, 10)
		szMain.Add(szButtons,0, wx.ALIGN_CENTER |wx.ALL, 10)
		self.SetSizer(szMain)
		self.SetAutoLayout(True)
		szMain.Fit(self)
		self.Layout()
		
		#------------------- Callbacks
		self.Bind(wx.EVT_BUTTON, self.OnOk, l_gButOk)
		self.Bind(wx.EVT_BUTTON, self.OnCancel, l_gButCancel)
		self.Bind(wx.calendar.EVT_CALENDAR_SEL_CHANGED,self.OnCalSel, self.cal)
		
	def OnCalSel(self,evt):
		self.iTime = evt.GetDate().GetTicks()+24*3600
	
	def OnOk(self,evt):
		self.EndModal(wx.ID_OK)
	
	def OnCancel(self,evt):
		self.EndModal(wx.ID_CANCEL)