import wx
import cushions
import sta_utils
import sta_globals
from OpenGL.GL import *
from OpenGL.GLUT import *
import pysqlite2.dbapi2 as sqlite

#///////////////////////////////////////////////////////////////////////////////
#						Project Class
#///////////////////////////////////////////////////////////////////////////////
class STAPrj:

	def __init__(self,*args,**kwds):
		self.sName = ""
		self.sType = "SVN"
		self.sAddress = ""
		self.sFolder = ""
		self.sProtocol = "svn"
		self.sModule = ""
		self.sUser = ""
		self.sPass = ""
		self.iFiles = 0
		self.sDate = "-"
		self.sPath = ""
		self.lSnapshots = []
#---------------------------------------------------------------------------
#					Verify is information is complete
#---------------------------------------------------------------------------
	def GetValid(self):
		result = 0
		if (self.sUser == ""):
			sUser = "anonymous"
		if (self.sAddress == ""):
			result = 4
		if (self.sName == ""):
			result = 5
		return result

#---------------------------------------------------------------------------
#						Calculate the project path
#---------------------------------------------------------------------------
	def calculatePath(self):
		l_sLine = self.sAddress+self.sFolder
		l_sLine = sta_utils.normalize(l_sLine)
		self.sPath = l_sLine

	def storagePath(self):
		# folder = '_'+sta_utils.normalize(self.sFolder) if self.sFolder != '' else ''
		return sta_globals.sStartDir+"/data/"+self.sPath # +folder

#///////////////////////////////////////////////////////////////////////////////
#						File Class
#///////////////////////////////////////////////////////////////////////////////
class STAFile:
	def __init__(self,*args,**kwds):
		#-----------------------------------# File ID
		self.sPath 		= "-"		# file path
		self.sName 		= "-"		# file name
		self.iDBid		= 0			# ID in the DB
		self.iStatus	= 0			# 0=ok, 1=obsolete/deleted
		self.iTime		= 0			# Last update time
		#-----------------------------------# main file attributes
		self.init()
		#---------------------------------- # other file attributes
		self.lValues		= {}
		self.lValues['similarity']   = 0

		#----------------------------------- Draw state
		self.iPos 	= 0

	def prepare(self):
		# Ditch the dollar on TFS paths
		if len(self.sPath) >= 2 and self.sPath[0:2] == '$/':
			self.sPath = self.sPath[1:]

	def init(self):
		self.iNrRevs 	= 0		# total numer of versions (used in construction)
		self.iStart		= 0		# time when it starts
		self.iEnd		= 0		# time when it ends
		self.lRevs		= []	# list of Commit
		self.iType		= 0		# 0 = file, 1= folder

	def __str__(self):
		sResult = self.sPath
		return sResult

#///////////////////////////////////////////////////////////////////////////////
#					                       	Commit Class
#///////////////////////////////////////////////////////////////////////////////
class STACommit:
	def __init__(self,*args,**kwds):
		self.sID 		= "-"	# revision ID
		self.iTime		= 0		# commit time in seconds
		self.iDBid		= 0		# ID in the DB

		#-------------------------- # commit attributes
		self.lValues	= {}

	def __cmp__(self, other):
		return cmp(self.iTime,other.iTime)

#---------------------------------------------------------------------------
#			String representation for a commit (i.e. revision)
#---------------------------------------------------------------------------
	def __str__(self):
		return self.sID

#///////////////////////////////////////////////////////////////////////////////
#              												Metric Info Class
#///////////////////////////////////////////////////////////////////////////////
class STAMetric:
	def __init__(self,p_sID,p_sName,p_sDescription,p_sDependencies,*args,**kwds):
		self.sID			= p_sID
		self.sName			= 'Unknown'
		self.sDescription	= ''
		self.lDependencies	= []

		if (p_sName != None):
			self.sName			= p_sName
		if (p_sDescription != None):
			self.sDescription	= p_sDescription
		if (p_sDependencies != None):
			self.lDependencies	= p_sDependencies.split(':')

	def __str__(self):
		sResult = self.sName+'\n'+self.sDescription
#///////////////////////////////////////////////////////////////////////////////
#              												Selection Class
#///////////////////////////////////////////////////////////////////////////////

#----------------------- populate list of selections based on a project path ---
def LoadSelections(p_sPath):
	if os.path.exists(p_sPath):
		lsFiles = os.listdir(p_sPath)
		for i in lsFiles:
			cSelection = STASelection(p_sPath)
			cSelection.LoadFromFile(p_sPath+'/'+i)
			AddSelection(cSelection)

#-------------------------------------- return the first unused selection ID ---
def GetFreeSelectionID():
	j = 0
	bSw = True
	while bSw:
		j = j+1
		bSw = False
		iID = j
		for i in sta_globals.lSelections:
			if (iID == i.iID):
				bSw = True
				break;
	return j
#------------------------------------------------------------- Add selection ---
def AddSelection(p_cSelection):
	sta_globals.lSelections.append(p_cSelection)
	idx = sta_globals.GUI.mainFrame.g_listSelections.Append(p_cSelection.sName)
	sta_globals.GUI.mainFrame.g_listSelections.SetClientData(idx,p_cSelection)

#---------------------------------------------------------- Delete selection ---
def DeleteSelection(p_cSelection):
	for i in range(len(sta_globals.lSelections)):
		if sta_globals.lSelections[i].iID == p_cSelection.iID:
			sta_globals.lSelections[i].Delete()
			del sta_globals.lSelections[i]
			break

#---------------------------------------------------------- Clear selections ---
def ClearSelections():
	sta_globals.lSelections = []
	sta_globals.GUI.mainFrame.g_listSelections.Clear()

#----------------------------------------------- Is folder selection saved ? ---
def IsSelectionSaved(p_sPath):
	bSw = False
	for i in sta_globals.lSelections:
		if (i.sName == p_sPath):
			bSw = True
			break
	return bSw
#------------------------------------------------------ Get selection by name ---
def GetSelectionByName(p_sName):
	for i in sta_globals.lSelections:
		if (i.sName == p_sName):
			return i
	return 0

#------------------------------------------------------ Class implementation ---
class STASelection:
	def __init__(self,p_sSavePath):
		self.sName		= ''			# Selection name
		self.iID		= 0				# Unique selection ID inside a project
		self.dFiles		= {}			# paths of files in selection
		self.sSavePath	= p_sSavePath	# folder where this selection is saved

	#---------------------------------------- Load a selection from a folder ---
	def LoadCurrent(self,p_bNamed, p_sName):

		self.dFiles.clear()
		for i in sta_globals.lSelectedFiles:
			if (i.iType == 0):
				self.dFiles[i.iDBid] = 1

		if (p_bNamed):
			self.sName	= p_sName
		else:
			self.sName	= 'Selection '+str(self.iID)

		self.Save()

	#--------------------------------------- Refresh selection from a folder ---
	def Refresh(self):

		self.dFiles.clear()
		for i in sta_globals.lSelectedFiles:
			if (i.iType == 0):
				self.dFiles[i.iDBid] = 1

	#---------------------------------------- Load a selection from a folder ---
	def LoadFromFile(self,p_sPath):
		fileHandle = open(p_sPath,'r')

		sLine = fileHandle.readline()
		self.sName = sLine.rstrip()

		sLine = fileHandle.readline()
		self.iID = int(sLine.rstrip())

		self.dFiles.clear()
		sLine = fileHandle.readline()
		sLine = sLine.rstrip()
		l_lFiles = sLine.split(',')
		if len(l_lFiles)>0:
			del l_lFiles[-1]
		for l_iFile in l_lFiles:
			self.dFiles[int(l_iFile)] = 1

		fileHandle.close()

	#---------------------------------------- Delete selection from the disk ---
	def Delete(self):

		self.dFiles.clear()

		try:
			os.remove(self.sSavePath+'/'+str(self.iID))
		except:
			pass

		#---
		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()
		l_sTableName = "SSEL_%d_V"%self.iID
		if sta_utils.isValidTable(cCursorDB,l_sTableName):
			sCmd = "DROP TABLE %s"%l_sTableName
			cCursorDB.execute(sCmd)
		cDB.commit()
		cCursorDB.close()
		cDB.close()

	#-------------------------------------- Apply a selection on a file list ---
	def Apply(self):

		sta_globals.lSelectedFiles = []

		for l_cFile in sta_globals.lFiles:
			if self.dFiles.has_key(l_cFile.iDBid):
				l_cFile.lRevs	= []
				sta_globals.lSelectedFiles.append(l_cFile)

		sta_globals.GUI.mainFrame.g_gFile.SetRange(len(sta_globals.lSelectedFiles))
		l_iProgress = 0
		sta_globals.GUI.mainFrame.g_gFile.SetValue(l_iProgress)
		l_iFile = -1

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()
		l_sTableName = "SSEL_%d_V"%self.iID
		sCmd = "select v.ID,File,Name,Time from Versions v JOIN %s b ON v.ID=b.ID"%l_sTableName
		cCursorDB.execute(sCmd)
		for i in cCursorDB:

			if sta_globals.bActionCancel:
				 sta_globals.bActionCancel = False
				 break

			l_cCommit			= STACommit()
			l_cCommit.sID		= str(i[2])
			l_cCommit.iDBid		= i[0]
			l_cCommit.iTime		= i[3]

			#Add commit to file
			l_cFile = sta_globals.lFiles[i[1]-1]
			l_cFile.lRevs.append(l_cCommit)

			if (l_iFile != i[1]):
				l_iFile == i[1]
				l_iProgress += 1
				sta_globals.GUI.mainFrame.g_gFile.SetValue(l_iProgress)
				wx.Yield()

		for l_cFile in sta_globals.lSelectedFiles:
			FinalizeFileInfo(l_cFile,bUpdateRevs = False)

		sta_globals.GUI.UpdateSelectedFiles(False,False)
		sta_globals.GUI.UpdateFilters()
		#sta_globals.GUI.RefreshFilterMetrics()
		cCursorDB.close()
		cDB.close()

		sta_globals.GUI.mainFrame.g_gFile.SetRange(0)

	#-------------------------------------- UnApply a selection ---
	def UnApply(self):

		sta_globals.lSelectedFiles = []

		for l_cFile in sta_globals.lFiles:
			if self.dFiles.has_key(l_cFile.iDBid):
				l_cFile.lRevs	= []
				sta_globals.lSelectedFiles.append(l_cFile)

		sta_globals.GUI.mainFrame.g_gFile.SetRange(len(sta_globals.lSelectedFiles))
		l_iProgress = 0
		sta_globals.GUI.mainFrame.g_gFile.SetValue(l_iProgress)
		l_iFile = -1

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()
		l_sTableName = "SSEL_%d_V"%self.iID

		sCmd = "create temporary view unapply as select distinct v.File from Versions v JOIN %s b ON v.ID=b.ID"%l_sTableName
		cCursorDB.execute(sCmd)

		sCmd = "select ID,v.File,Name,Time from Versions v JOIN unapply b ON v.File=b.File"
		cCursorDB.execute(sCmd)
		for i in cCursorDB:

			if sta_globals.bActionCancel:
				 sta_globals.bActionCancel = False
				 break

			l_cCommit			= STACommit()
			l_cCommit.sID		= str(i[2])
			l_cCommit.iDBid		= i[0]
			l_cCommit.iTime		= i[3]

			#Add commit to file
			l_cFile = sta_globals.lFiles[i[1]-1]
			l_cFile.lRevs.append(l_cCommit)

			if (l_iFile != i[1]):
				l_iFile == i[1]
				l_iProgress += 1
				sta_globals.GUI.mainFrame.g_gFile.SetValue(l_iProgress)
				wx.Yield()

		for l_cFile in sta_globals.lSelectedFiles:
			FinalizeFileInfo(l_cFile,bUpdateRevs = False)

		cCursorDB.close()
		cDB.close()

		sta_globals.GUI.mainFrame.g_gFile.SetRange(0)

	#---------------------------------------------------- Set selection name ---
	def SetName(self,p_sName):
		self.sName = p_sName
		self.Save(False)

	#-------------------------------------------------------- Save selection ---
	def Save(self,p_bFull = True):

		if not os.path.exists(self.sSavePath):
			os.makedirs(self.sSavePath)
		sPath = self.sSavePath+'/'+str(self.iID)
		fileHandle = open(sPath,'w')
		fileHandle.write(self.sName+'\n')
		fileHandle.write(str(self.iID)+'\n')
		for i in self.dFiles.keys():
				fileHandle.write('%d,'%i)
		fileHandle.write('\n')
		fileHandle.close()

		#---
		if (p_bFull):

			cDB = sqlite.connect(sta_globals.sDBPath)
			cCursorDB = cDB.cursor()

			l_sTableName = "SSEL_%d_V"%self.iID
			if sta_utils.isValidTable(cCursorDB,l_sTableName):
				sCmd = "DROP TABLE %s"%l_sTableName
				cCursorDB.execute(sCmd)
			sCmd = "CREATE TABLE %s(ID integer primary key)"%l_sTableName
			cCursorDB.execute(sCmd)

			sCmdRoot = "INSERT INTO %s(ID) VALUES (%d)"
			for l_cFile in sta_globals.lFiles:
				if self.dFiles.has_key(l_cFile.iDBid):
					for l_cCommit in l_cFile.lRevs:
						sCmd = sCmdRoot%(l_sTableName,l_cCommit.iDBid)
						cCursorDB.execute(sCmd)

			cDB.commit()
			cCursorDB.close()
			cDB.close()

#///////////////////////////////////////////////////////////////////////////////
#																		Utils
#///////////////////////////////////////////////////////////////////////////////

#------------------------------------------------------- Finalize File Info ---
def FinalizeFileInfo(cFile,bUpdateRevs = True):
	# sort commits according to time
	cFile.lRevs.sort()
	if (bUpdateRevs):
		cFile.iNrRevs = len(cFile.lRevs)
	# commit iteration
	if len(cFile.lRevs) > 0:
		cFile.iStart = cFile.lRevs[0].iTime		# file start
		cFile.iEnd   = cFile.lRevs[-1].iTime	# file last
	else:
		cFile.iStart = 0
		cFile.iEnd   = 0

#------------------------------------------------ Find commit with given ID ---
def FindCommit(cFile,sID):
	for i in cFile.lRevs:
		if (i.sID == sID):
			return (1,i)
	return (0,0)


