import sta_globals

#===============================================================================
#							File comparison
#===============================================================================

#--------------------------------------------------------------- On activity ---
def cmpFile_NrCommit(file1,file2):
	return cmp(len(file2.lRevs),len(file1.lRevs))

#---------------------------------------------------------- On creation time ---
def cmpFile_Creation(file1,file2):
	return -cmp(file1.iStart,file2.iStart)

#------------------------------------------------------------ Alphabetically ---
def cmpFile_Alphabetically(file1,file2):
	return cmp(file1.sPath,file2.sPath)

#------------------------------------------------------------------- On type ---
def cmpFile_Type(file1,file2):
	#--- Extension first file
	l_iIdx = file1.sPath.rfind('.')
	if l_iIdx > 0:
		l_sExt1 = file1.sPath[l_iIdx:]
	else:
		l_sExt1 = file1.sPath
	#--- Extension second file
	l_iIdx = file2.sPath.rfind('.')
	if l_iIdx > 0:
		l_sExt2 = file2.sPath[l_iIdx:]
	else:
		l_sExt2 = file2.sPath
	# compare
	return cmp(l_sExt1,l_sExt2)

#----------------------------------------------------- On file filter values ---
def cmpFile_FilterFile(file1,file2):
	l_iVal1 = -1
	l_iVal2 = -1
	try:
		if file1.lValues[sta_globals.sMenuGroup] != -1:
			l_iVal1 = 1
		if file2.lValues[sta_globals.sMenuGroup] != -1:
			l_iVal2 = 1
		return cmp(l_iVal1,l_iVal2)
	except:
		return cmp(1,0)

#-------------------------------------------------- On version filter values ---
def cmpFile_FilterVersion(file1,file2):

	l_iVal1 = -1
	l_iVal2 = -1
	for i in file1.lRevs:
		try:
			if i.lValues[sta_globals.sMenuGroup] != -1:
				l_iVal1 = 1
				break
		except:
			pass
	for i in file2.lRevs:
		try:
			if i.lValues[sta_globals.sMenuGroup] != -1:
				l_iVal2 = 1
				break
		except:
			pass
	return cmp(l_iVal1,l_iVal2)

#-------------------------------------------------------- On attribute value ---
sSortAttribute	= 'type'
def cmpFile_Attr(file1,file2):
	try:
		return -cmp(file1.lValues[sSortAttribute],file2.lValues[sSortAttribute])
	except:
		print 'E'
		return 0

#------------------------------------------------------ On commit similarity ---
def delta_FileCommit(file1,file2):
	delta = 0
	if (file1 == file2):
		return len(file1.lRevs)

	l_commits = []
	for i in file1.lRevs:
		l_commits.append((1,i.iTime))
	for i in file2.lRevs:
		l_commits.append((2,i.iTime))
	l_commits.sort(cmp=lambda x,y: cmp(x[1], y[1]))

	i=0
	l_len = len(l_commits)-1
	while (i < l_len):
		if (l_commits[i][0] != l_commits[i+1][0]):
			l_distance = l_commits[i+1][1] - l_commits[i][1]
			if ( l_distance < sta_globals.iCommitRadius):
				if (l_distance == 0):
					delta = delta + 1
				else:
					delta = delta + float(1)/l_distance
			i = i+1
		i = i +1

	return delta

#---------------------------------------------------- on similar transaction ---
def cmpFile_SimilarTransaction(file,commit):
	l_MinDelta = sta_globals.iSelectedFilesInterval
	for i in file.lRevs:
		l_iDelta = abs(i.iTime - commit.iTime)
		if (l_iDelta < l_MinDelta):
			l_MinDelta = l_iDelta
	return l_MinDelta

#---------------------------------------------------- on similar transaction ---
def cmpFile_TextHits(file):
	l_iHits = 0

	l_iStartTime = sta_globals.iStartFocusInterval
	if (l_iStartTime < 0):
		l_iStartTime = sta_globals.iSelectedFilesStartTime

	l_iEndTime = sta_globals.iEndFocusInterval
	if (l_iEndTime < 0):
		l_iEndTime = sta_globals.iSelectedFilesEndTime

	for i in file.lRevs:
		try:
			if (i.iTime >= l_iStartTime) and (i.iTime <= l_iEndTime) and (i.lValues['pextFind'] != -1):
				l_iHits = l_iHits+1
		except:
			pass
	return l_iHits
#--------------------------------------------------------------- on activity ---
def cmpFile_Activity(file):

	l_iStartTime = sta_globals.iStartFocusInterval
	if (l_iStartTime < 0):
		l_iStartTime = sta_globals.iSelectedFilesStartTime

	l_iEndTime = sta_globals.iEndFocusInterval
	if (l_iEndTime < 0):
		l_iEndTime = sta_globals.iSelectedFilesEndTime

	l_iCommits = 0
	for i in file.lRevs:
		if (i.iTime >= l_iStartTime) and (i.iTime <= l_iEndTime):
			l_iCommits = l_iCommits+1
	return l_iCommits
