from sta_gl 			import CanvasBase
from OpenGL.GL 			import *
from OpenGL.GLUT 		import *
from OpenGL.GLU 		import *

import cushions
import sta_globals
import sta_utils
import wx

#/////////////////////////////////////////////////////////////////////////
#					Custom cluster level of detail
#/////////////////////////////////////////////////////////////////////////

class ClusterCanvas(CanvasBase):

	def __init__(self, parent, *args, **kwds):
		CanvasBase.__init__(self, *args, **kwds)
		
		self.bGetInfo	= True
		self.iMx		= 0
		self.iMy		= 0	
		self.iMLevel	= 0
		
	def InitGL(self):
		glMatrixMode(GL_MODELVIEW)
		glClearColor(1, 1, 1, 1.0)
		cushions.generateClusterTextures(sta_globals.cClusterCushions)
		
#========================================================================
# 							OnMouseDown
#========================================================================
	def pGetClusterCoordinates(self,p_iDetailLevel,p_iY): 
		
		l_iLevel = sta_globals.getClusterLevelTableIdx(p_iDetailLevel)
		l_lLevels = sta_globals.cClusterEngine.lLayout[l_iLevel]
		l_iOldLevel		= 0
		l_iCurentLevel	= 0
		l_fLevel		= 0
		for j in l_lLevels:
			l_iOldLevel = l_iCurentLevel
			l_fLevel = l_fLevel + float(j[0]) / sta_globals.cClusterEngine.iFiles*self.fSizeY
			l_iCurentLevel = l_iCurentLevel + j[0]
			if l_fLevel > p_iY:
				break
		
		return (l_iCurentLevel,l_iOldLevel)

	def OnLeftMouseDown(self, evt):
		sta_globals.iClusterSelectedDetail		= int(float(self.iMx)/(self.size.width) * sta_globals.iClusterDetail)+1
		sta_globals.GUI.cbClusterDetail(0)
		self.Refresh()

#========================================================================
# 							OnKey
#========================================================================
	def OnKeyDown(self,evt):
		if self.bMouseIn:
			if (evt.GetKeyCode() == wx.WXK_CONTROL):
				if (self.bGetInfo) and (sta_globals.cClusterEngine.HasClusters()):
					self.bGetInfo = False
					(sta_globals.GUI.glCanvas.fClusterHintY2,sta_globals.GUI.glCanvas.fClusterHintY1) = self.pGetClusterCoordinates(self.iMLevel,self.iMy)
					sta_globals.GUI.glCanvas.bShowClusterHint = True
					sta_globals.GUI.glCanvas.Refresh()
					self.Refresh()

	def OnKeyUp(self,evt):
		if self.bMouseIn:
			if evt.GetKeyCode() == wx.WXK_CONTROL:
				self.bGetInfo = True
				sta_globals.GUI.glCanvas.bShowClusterHint = False
				sta_globals.GUI.glCanvas.Refresh()
			self.Refresh()
 
#========================================================================
# 							OnMouseWheel
#========================================================================
	def OnMouseWheel(self,evt):
	  
		if not self.bMouseIn:
			return
		
		l_fOldPos = float(sta_globals.iClusterSelectedDetail)/sta_globals.iClusterDetail
		
		if evt.m_wheelRotation < 0:
			sta_globals.iClusterDetail = sta_globals.iClusterDetail - sta_globals.iClusterDetailStep
			if sta_globals.iClusterDetail<1:
				sta_globals.iClusterDetail = 1
		else:
			sta_globals.iClusterDetail = sta_globals.iClusterDetail + sta_globals.iClusterDetailStep           
			if sta_globals.iClusterDetail>sta_globals.iTotalLevels-1:
				sta_globals.iClusterDetail = sta_globals.iTotalLevels-1
		
		sta_globals.iClusterSelectedDetail		= int(l_fOldPos * sta_globals.iClusterDetail)
		sta_globals.GUI.cbClusterDetail(0)
		self.Refresh()

#========================================================================
# 							OnMouseMotion
#========================================================================
	def OnMouseMotion(self, evt):
		
		self.iMx, self.iMy = evt.GetPosition()
		self.iMx = max(self.iMx,0)
		self.iMx = min(self.iMx,self.size.width)
		self.iMy = max(self.iMy,0)
		self.iMy = min(self.iMy,self.size.height)
		
		self.iMLevel = sta_globals.iClusterDetail - int(float(self.iMx)/(self.size.width)*(sta_globals.iClusterDetail+1))
		
		if evt.m_controlDown:
			if sta_globals.cClusterEngine.HasClusters():
				(sta_globals.GUI.glCanvas.fClusterHintY2,sta_globals.GUI.glCanvas.fClusterHintY1) = self.pGetClusterCoordinates(self.iMLevel,self.iMy)
				sta_globals.GUI.glCanvas.bShowClusterHint = True
				self.RefreshEx()
				sta_globals.GUI.glCanvas.Refresh()

#========================================================================
# 								OnDraw
#========================================================================
	def OnDraw(self):         
		
		if self.bRendering:
			return
		self.glListSetup()
		
		glScalef(-1,-1,1)
		glTranslatef(-self.size.width,-self.size.height,0)
		
		#---------------- Begin drawing ---
		if sta_globals.cClusterEngine.HasClusters():
			
			l_fRatioX 		= float(self.fSizeX) / (sta_globals.iClusterDetail)
			l_fLayerRatio	= float(sta_globals.iTotalLevels)/sta_globals.iClusterDetail
			
			for i in range(sta_globals.iClusterDetail):
				
				l_iLevel = sta_globals.getClusterLevelTableIdx(i)
				l_lLevels = sta_globals.cClusterEngine.lLayout[l_iLevel]
				
				l_fCurentLevel		= 0
				l_fSubUnitLevel		= 0
				for j in l_lLevels:
					l_fOldLevel		= l_fCurentLevel
					l_fCurentLevel	= l_fCurentLevel + float(j[0]) / sta_globals.cClusterEngine.iFiles*self.fSizeY
					
					if j[2]:
						glColor3f(0.85,0.85,0.75)
					else:
						glColor3fv(sta_utils.getBiColormap(j[1],2))
					
					glRectf(\
						l_fRatioX*i,\
						l_fOldLevel,\
						l_fRatioX*(i+1),\
						l_fCurentLevel)	 
					
					#---------------------------------------------
					if l_fCurentLevel - 3 >= l_fOldLevel:
						
						glBlendFunc(GL_ZERO,GL_SRC_ALPHA)
						glEnable(GL_BLEND)
						cushions.drawCushion1DH(\
							l_fRatioX*i,\
							l_fOldLevel,\
							l_fRatioX*(i+1),\
							l_fCurentLevel,\
							sta_globals.cClusterCushions,0,True)
						glDisable(GL_BLEND)
						
						l_fSubUnitLevel = l_fCurentLevel
					
					#---------------------------------------------
					elif l_fCurentLevel - 3 >= l_fSubUnitLevel:
						
						glBlendFunc(GL_ZERO,GL_SRC_ALPHA)
						glEnable(GL_BLEND)
						cushions.drawCushion1DH(\
							l_fRatioX*i,\
							l_fSubUnitLevel,\
							l_fRatioX*(i+1),\
							l_fCurentLevel,\
							sta_globals.cClusterCushions,0,True)
						glDisable(GL_BLEND)
						
						l_fSubUnitLevel = l_fCurentLevel
						
				#glColor3f(0.85,0.85,0.85)
				glColor3f(0.25,0.25,0.25)
				glRectf(l_fRatioX*i,0,l_fRatioX*i+1,self.fSizeY)
			#----------------------------------- draw selected level ---
			l_x1 = l_fRatioX*sta_globals.iClusterLevel
			l_x2 = l_fRatioX*(sta_globals.iClusterLevel+1)
			glColor3f(0.75,0,0)
			sta_utils.drawRectangle(l_x1,0,l_x2,self.fSizeY,3)
			glColor3f(1.0,1.0,1.0)
			sta_utils.drawRectangle(l_x1,0,l_x2,self.fSizeY,1)
			glColor3f(0.75,0,0)
			
			glBegin(GL_TRIANGLES)
			glVertex2f(l_x1,0)
			glVertex2f((l_x2+l_x1)/2,5)
			glVertex2f(l_x2,0)
			glVertex2f(l_x1,self.fSizeY)
			glVertex2f((l_x2+l_x1)/2,self.fSizeY-10)
			glVertex2f(l_x2,self.fSizeY)
			glEnd()
			
			#------------------------------------ draw hinted cluster ---
			if sta_globals.GUI.glCanvas.bShowClusterHint:
				l_fY1 = float(sta_globals.GUI.glCanvas.fClusterHintY1) / sta_globals.cClusterEngine.iFiles*self.fSizeY
				l_fY2 = float(sta_globals.GUI.glCanvas.fClusterHintY2) / sta_globals.cClusterEngine.iFiles*self.fSizeY	        	        
				glColor3f(1.0,1.0,1.0)
				sta_utils.drawRectangle(\
					l_fRatioX*self.iMLevel,\
					l_fY1, 
					l_fRatioX*(self.iMLevel+1),\
					l_fY2, 
					3)
				glColor3f(1.0,0.0,0.0)
				sta_utils.drawRectangle(\
					l_fRatioX*self.iMLevel,\
					l_fY1, 
					l_fRatioX*(self.iMLevel+1),\
					l_fY2, 
					1)
				
		#---------------- End drawing ---
		self.glListRun()
