import wx
import wx.html
import os
import sta_gl
import sta_gl_list
import sta_utils
import sta_globals
import sta_data_manip
import sta_help

import throbber
import pysqlite2.dbapi2 as sqlite

#================================================================================
#						Test for OpenGl libraries
#================================================================================
from wx import glcanvas
import wx.lib.mixins.listctrl  as  listmix

from OpenGL.GL import *
from OpenGL.GLUT import *

class ExListCtrl(wx.ListCtrl, listmix.ListCtrlAutoWidthMixin):
	def __init__(self, parent, ID, pos=wx.DefaultPosition,	size=wx.DefaultSize, style=0):
		wx.ListCtrl.__init__(self, parent, ID, pos, size, style)
		listmix.ListCtrlAutoWidthMixin.__init__(self)

#///////////////////////////////////////////////////////////////////////////////
#								Project password dialog
#///////////////////////////////////////////////////////////////////////////////

class CTwoButt(wx.Dialog):
	def __init__(self, p_sCaption,p_sMsg, p_sBut1, p_sBut2, *args, **kwds):
		kwds["style"] = wx.DEFAULT_DIALOG_STYLE | wx.STAY_ON_TOP

		wx.Dialog.__init__(self, *args, **kwds)

		self.CenterOnParent(wx.BOTH)
		self.SetFocus()

		self.SetTitle(p_sCaption)
		l_gMsg = wx.StaticText(self, -1,p_sMsg )

		l_gBut1 		= wx.Button(self, 1, p_sBut1)
		l_gBut2 		= wx.Button(self, 2, p_sBut2)

		l_gBut1.Bind(wx.EVT_BUTTON,self.OnBut)
		l_gBut2.Bind(wx.EVT_BUTTON,self.OnBut)

		l_sizerButtons = wx.BoxSizer(wx.HORIZONTAL)
		l_sizerButtons.Add(l_gBut1, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE|wx.ALL, 5)
		l_sizerButtons.Add(l_gBut2, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE|wx.ALL, 5)

		l_sizer = wx.BoxSizer(wx.VERTICAL)
		l_sizer.Add(l_gMsg,1,wx.ALIGN_CENTER_HORIZONTAL|wx.ALL, 15)
		l_sizer.Add(l_sizerButtons,0,wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE|wx.ALL, 5)
		self.SetSizer(l_sizer)
		l_sizer.Fit(self)

	def OnBut(self, event):
		self.EndModal(event.GetId())

class CPassDlg(wx.Dialog):
	def __init__(self, l_cSTAPrj, *args, **kwds):
		kwds["style"] = wx.DEFAULT_DIALOG_STYLE

		wx.Dialog.__init__(self, *args, **kwds)
		self.label_4 = wx.StaticText(self, -1, "   Account: "+l_cSTAPrj.sUser+' @ '+l_cSTAPrj.sName)
		self.g_txtPassword = wx.TextCtrl(self, -1, "", style=wx.TE_PASSWORD|wx.TE_PROCESS_ENTER)

		self.cSTAPrj = l_cSTAPrj

		self.__set_properties()
		self.__do_layout()

		self.g_txtPassword.Bind(wx.EVT_TEXT_ENTER,self.OnTextEnter)
		self.g_txtPassword.Bind(wx.EVT_KEY_DOWN,self.OnKey)

	def __set_properties(self):
		self.SetTitle("Enter password")
		self.g_txtPassword.SetMinSize((150, -1))


	def __do_layout(self):
		sizer_6 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_6.Add(self.label_4, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		sizer_6.Add(self.g_txtPassword, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 10)
		self.SetSizer(sizer_6)
		sizer_6.Fit(self)
		sizer_6.SetSizeHints(self)
		self.Layout()

	def OnTextEnter(self, event):
		self.cSTAPrj.sPass = self.g_txtPassword.GetValue()
		self.EndModal(wx.ID_OK)

	def OnKey(self, event):
		if event.GetKeyCode() == 27:
			self.cSTAPrj.sPass = "###STA###NoPass"
			self.EndModal(wx.ID_CANCEL)
		else:
			event.Skip()

#///////////////////////////////////////////////////////////////////////////////
#								Cross transactions dialog
#///////////////////////////////////////////////////////////////////////////////

class CCrossTransactionDlg(wx.Dialog):
	def __init__(self,p_sTitle,*args, **kwds):

		kwds["style"] = wx.DEFAULT_DIALOG_STYLE

		wx.Dialog.__init__(self, *args, **kwds)

		self.label_1 = wx.StaticText(self, -1, '   Recurrence range')
		self.label_2 = wx.StaticText(self, -1, '   Transactions')
		self.label_3 = wx.StaticText(self, -1, '   Full log message')

		self.g_bAll 	= wx.Button(self, -1, "Select all")
		self.g_bOk 		= wx.Button(self, -1, "Remove")
		self.g_bCancel	= wx.Button(self, -1, "Cancel")

		self.g_sliderRange 		= wx.Slider(self, -1, sta_globals.CT_iLevel, 5, 100, style= wx.SL_LABELS)
		self.g_lTransactions 	= wx.CheckListBox(self, -1)
		self.g_tInfo 			= wx.TextCtrl(self, -1, "", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_RICH2|wx.BORDER_SUNKEN)

		self.lIndexes = []
		self.sTitle = p_sTitle

		self.__set_properties()
		self.__do_layout()

		# Populate dialog box with messages
		self.Populate()

		self.g_bCancel.Bind(wx.EVT_BUTTON,self.OnCancel)
		self.g_bOk.Bind(wx.EVT_BUTTON,self.OnOk)
		self.g_bAll.Bind(wx.EVT_BUTTON,self.OnAll)
		self.g_sliderRange.Bind(wx.EVT_COMMAND_SCROLL_THUMBRELEASE,self.cbSlider)
		self.g_sliderRange.Bind(wx.EVT_COMMAND_SCROLL_PAGEUP,self.cbSlider)
		self.g_sliderRange.Bind(wx.EVT_COMMAND_SCROLL_PAGEDOWN,self.cbSlider)
		self.g_lTransactions.Bind(wx.EVT_LISTBOX,self.cbSelect)
		self.Bind(wx.EVT_KEY_DOWN,self.OnKey)

	def Populate(self):

		self.g_lTransactions.Clear()
		self.lIndexes = []

		cDB = sqlite.connect(sta_globals.sDBPath)
		cCursorDB = cDB.cursor()

		l_lSortedKeys = sta_globals.CT_dMessageLog.keys()
		l_lSortedKeys.sort(cmp = lambda x,y: cmp(sta_globals.CT_dMessageLog[y],sta_globals.CT_dMessageLog[x]))

		for i in l_lSortedKeys:
			if (sta_globals.CT_dMessageLog[i] >= sta_globals.CT_iLevel):

				sCmd = "select Name from M_SS2007010102 where ID="+str(sta_globals.CT_dMessageID[i])
				cCursorDB.execute(sCmd)
				l_sMessage = cCursorDB.fetchone()[0]

				self.g_lTransactions.Append(str(sta_globals.CT_dMessageLog[i])+' '+l_sMessage[:50])
				self.lIndexes.append(i)

		cCursorDB.close()
		cDB.close()


	def __set_properties(self):
		self.SetTitle(self.sTitle)

		self.g_bOk.SetMinSize((50, -1))
		self.g_bCancel.SetMinSize((50, -1))
		self.g_sliderRange.SetMinSize((300, -1))
		self.g_lTransactions.SetMinSize((300, 150))
		self.g_tInfo.SetMinSize((300, 150))


	def __do_layout(self):

		l_sizerButtons = wx.BoxSizer(wx.HORIZONTAL)
		l_sizerButtons.Add(self.g_bAll, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE|wx.ALL, 5)
		l_sizerButtons.Add(self.g_bOk, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE|wx.ALL, 5)
		l_sizerButtons.Add(self.g_bCancel, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE|wx.ALL, 5)

		l_sizer = wx.BoxSizer(wx.VERTICAL)
		l_sizer.Add(self.label_1, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		l_sizer.Add(self.g_sliderRange, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		l_sizer.Add(self.label_2, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		l_sizer.Add(self.g_lTransactions, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		l_sizer.Add(self.label_3, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		l_sizer.Add(self.g_tInfo, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		l_sizer.Add(l_sizerButtons, 0, wx.ALIGN_CENTER_VERTICAL|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)

		self.SetSizer(l_sizer)
		l_sizer.Fit(self)
		l_sizer.SetSizeHints(self)
		self.Layout()

	def cbSelect(self,evt):
		l_iIdx = self.g_lTransactions.GetSelection()
		if (l_iIdx != wx.NOT_FOUND):
			l_iHash = self.lIndexes[l_iIdx]
			l_iDBid = sta_globals.CT_dMessageID[l_iHash]

			cDB = sqlite.connect(sta_globals.sDBPath)
			cCursorDB = cDB.cursor()

			sCmd = "select Name from M_SS2007010102 where ID="+str(l_iDBid)
			cCursorDB.execute(sCmd)
			l_sMessage = cCursorDB.fetchone()[0]

			self.g_tInfo.SetValue(l_sMessage)

			cCursorDB.close()
			cDB.close()

	def cbSlider(self,evt):
		sta_globals.CT_iLevel = self.g_sliderRange.GetValue()
		self.Populate()


	def OnKey(self, event):
		if event.GetKeyCode() == 27:
			self.EndModal(wx.ID_CANCEL)
		else:
			event.Skip()

	def OnAll(self, event):
		l_iItems = self.g_lTransactions.GetCount()
		for l_iItem in xrange(l_iItems):
			self.g_lTransactions.Check(l_iItem,True)

	def OnCancel(self, event):
		self.EndModal(wx.ID_CANCEL)

	def OnOk(self,evt):

		sta_globals.CT_dTintedHash = {}
		l_iNr = self.g_lTransactions.GetCount()
		for i in range(l_iNr):
			if self.g_lTransactions.IsChecked(i):
				sta_globals.CT_dTintedHash[self.lIndexes[i]] = 1

		self.EndModal(wx.ID_OK)

#///////////////////////////////////////////////////////////////////////////////
#								Project password dialog
#///////////////////////////////////////////////////////////////////////////////

class CInputTextDlg(wx.Dialog):
	def __init__(self,p_sTitle,p_sMsg,sValue, *args, **kwds):
		# begin wx.Glade: CPassDlg.__init__
		kwds["style"] = wx.DEFAULT_DIALOG_STYLE

		wx.Dialog.__init__(self, *args, **kwds)
		self.label_4 = wx.StaticText(self, -1, '  '+p_sMsg)
		self.g_txt = wx.TextCtrl(self, -1, "", style=wx.TE_PROCESS_ENTER)
		self.g_txt.SetValue(sValue)

		self.sText = sValue
		self.sTitle = p_sTitle

		self.__set_properties()
		self.__do_layout()

		self.g_txt.Bind(wx.EVT_TEXT_ENTER,self.OnTextEnter)
		self.g_txt.Bind(wx.EVT_KEY_DOWN,self.OnKey)

	def __set_properties(self):
		self.SetTitle(self.sTitle)
		self.g_txt.SetMinSize((150, -1))


	def __do_layout(self):
		sizer_6 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_6.Add(self.label_4, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		sizer_6.Add(self.g_txt, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 10)
		self.SetSizer(sizer_6)
		sizer_6.Fit(self)
		sizer_6.SetSizeHints(self)
		self.Layout()

	def OnTextEnter(self, event):
		self.sText = self.g_txt.GetValue()
		self.EndModal(wx.ID_OK)
	def OnKey(self, event):
		if event.GetKeyCode() == 27:
		   self.EndModal(wx.ID_CANCEL)
		else:
		   event.Skip()

#////////////////////////////////////////////////////////////////////////////////
#							Project Dialog
#////////////////////////////////////////////////////////////////////////////////

class CProjectDlg(wx.Dialog):
	def __init__(self, l_cSTAPrj, *args, **kwds):
		# begin wx.Glade: CProjectDlg.__init__

		self.cParentFrame = args[0]

		kwds["style"] = wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		self.sizer_11_staticbox = wx.StaticBox(self, -1, "Project details")
		self.label_1 = wx.StaticText(self, -1, "Project name	")
		self.g_dPrjName = wx.TextCtrl(self, -1, "")
		self.label_23 = wx.StaticText(self, -1, "Project type	")

		self.g_dPrjType = wx.ComboBox(self, -1, choices=["GIT", "SVN", "TFS"], style=wx.CB_DROPDOWN|wx.CB_READONLY)

		self.label_1_copy = wx.StaticText(self, -1, "URL   ")
		self.g_dPrjAddress = wx.TextCtrl(self, -1, "")
		self.g_txtT1 = wx.StaticText(self, -1, "Root folder	")
		self.g_dPrjFolder = wx.TextCtrl(self, -1, "")
		self.g_txtT2 = wx.StaticText(self, -1, " Protocol	")
		self.g_dPrjProtocol = wx.ComboBox(self, -1, choices=["pserver", "ext"], style=wx.CB_DROPDOWN|wx.CB_READONLY)
		self.g_txtT3 = wx.StaticText(self, -1, "Module	")
		self.g_dPrjModule = wx.TextCtrl(self, -1, "")
		self.label_5_copy = wx.StaticText(self, -1, "User name	 ")
		self.g_dPrjUser = wx.TextCtrl(self, -1, "")
		self.g_dHelp = wx.Button(self, -1, "Help")
		self.g_dPrjOk = wx.Button(self, -1, "Ok")
		self.g_dPrjCancel = wx.Button(self, -1, "Cancel")

		self.cSTAPrj = l_cSTAPrj

		self.g_dHelp.Bind(wx.EVT_BUTTON,self.OnHelp)
		self.g_dPrjOk.Bind(wx.EVT_BUTTON,self.OnOK)
		self.g_dPrjCancel.Bind(wx.EVT_BUTTON,self.OnCancel)
		self.g_dPrjType.Bind(wx.EVT_COMBOBOX,self.OnSelectType)

		self.__set_properties()
		self.__do_layout()
		self.__load_settings()
		# end wx.Glade

	def __set_properties(self):
		# begin wx.Glade: CProjectDlg.__set_properties
		self.SetTitle("Project")
		self.g_dPrjName.SetMinSize((150, -1))
		self.g_dPrjType.SetMinSize((150, -1))
		self.g_dPrjType.SetSelection(-1)
		self.g_dPrjAddress.SetMinSize((150, -1))
		self.g_dPrjFolder.SetMinSize((150, -1))
		self.g_dPrjProtocol.SetMinSize((150, -1))
		self.g_dPrjProtocol.SetSelection(-1)
		self.g_dPrjModule.SetMinSize((150, -1))
		self.g_dPrjUser.SetMinSize((150, -1))
		# end wx.Glade

	def __do_layout(self):
		# begin wx.Glade: CProjectDlg.__do_layout
		grid_sizer_1 = wx.FlexGridSizer(2, 1, 0, 0)
		sizer_4 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_11 = wx.StaticBoxSizer(self.sizer_11_staticbox, wx.HORIZONTAL)
		self.grid_sizer_3_copy = wx.FlexGridSizer(8, 2, 0, 0)
		self.grid_sizer_3_copy.Add(self.label_1, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_dPrjName, 0, wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.label_23, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_dPrjType, 0, wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_txtT2, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_dPrjProtocol, 0, wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.label_1_copy, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_dPrjAddress, 0, wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_txtT1, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_dPrjFolder, 0, wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_txtT3, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_dPrjModule, 0, wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.label_5_copy, 0, wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 0)
		self.grid_sizer_3_copy.Add(self.g_dPrjUser, 0, wx.ADJUST_MINSIZE, 0)
		self.grid_sizer_3_copy.AddGrowableCol(1)
		sizer_11.Add(self.grid_sizer_3_copy, 1, wx.EXPAND, 0)
		grid_sizer_1.Add(sizer_11, 1, wx.ALL|wx.EXPAND, 4)
		sizer_4.Add(self.g_dHelp, 0, wx.RIGHT|wx.FIXED_MINSIZE, 5)
		sizer_4.Add(self.g_dPrjOk, 0, wx.RIGHT|wx.FIXED_MINSIZE, 5)
		sizer_4.Add(self.g_dPrjCancel, 0, wx.LEFT|wx.FIXED_MINSIZE, 5)
		grid_sizer_1.Add(sizer_4, 1, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 4)
		self.SetSizer(grid_sizer_1)
		grid_sizer_1.Fit(self)
		grid_sizer_1.SetSizeHints(self)
		grid_sizer_1.AddGrowableRow(0)
		grid_sizer_1.AddGrowableCol(0)
		self.Layout()
		# end wx.Glade


	def   setUpDynamic(self,sType):
		if sType == "GIT":
		   self.g_txtT1.Show(False)
		   self.g_dPrjFolder.Show(False)
		   self.g_txtT2.Show(True)
		   self.g_dPrjProtocol.Show(True)
		   self.g_txtT3.Show(False)
		   self.g_dPrjModule.Show(False)
		   self.g_dPrjProtocol.Clear()
		   self.g_dPrjProtocol.Append("git")
		   self.g_dPrjProtocol.Append("http")
		   self.g_dPrjProtocol.Append("https")
		   self.g_dPrjProtocol.Append("file")
		   self.g_dPrjProtocol.Append("git+ssh")
		   self.g_dPrjProtocol.SetSelection(0)
		elif sType == "SVN":
		   self.g_txtT1.Show(False)
		   self.g_dPrjFolder.Show(False)
		   self.g_txtT2.Show(True)
		   self.g_dPrjProtocol.Show(True)
		   self.g_txtT3.Show(False)
		   self.g_dPrjModule.Show(False)
		   self.g_dPrjProtocol.Clear()
		   self.g_dPrjProtocol.Append("svn")
		   self.g_dPrjProtocol.Append("http")
		   self.g_dPrjProtocol.Append("https")
		   self.g_dPrjProtocol.Append("file")
		   self.g_dPrjProtocol.Append("svn+ssh")
		   self.g_dPrjProtocol.SetSelection(0)
		elif sType == "TFS":
		   self.g_txtT1.Show(True)
		   self.g_dPrjFolder.Show(True)
		   self.g_txtT2.Show(False)
		   self.g_dPrjProtocol.Show(False)
		   self.g_txtT3.Show(False)
		   self.g_dPrjModule.Show(False)
		self.grid_sizer_3_copy.Layout()

	def __load_settings(self):

		self.setUpDynamic(self.cSTAPrj.sType)
		self.g_dPrjName.SetValue(self.cSTAPrj.sName)
		self.g_dPrjType.SetValue(self.cSTAPrj.sType)
		self.g_dPrjAddress.SetValue(self.cSTAPrj.sAddress)
		self.g_dPrjFolder.SetValue(self.cSTAPrj.sFolder)
		self.g_dPrjProtocol.SetValue(self.cSTAPrj.sProtocol)
		self.g_dPrjModule.SetValue(self.cSTAPrj.sModule)
		self.g_dPrjUser.SetValue(self.cSTAPrj.sUser)


	def OnOK(self,event):
		self.cSTAPrj.sName	 = self.g_dPrjName.GetValue()
		self.cSTAPrj.sType	 = self.g_dPrjType.GetValue()
		self.cSTAPrj.sAddress  = self.g_dPrjAddress.GetValue()
		self.cSTAPrj.sFolder   = self.g_dPrjFolder.GetValue()
		self.cSTAPrj.sProtocol = self.g_dPrjProtocol.GetValue()
		self.cSTAPrj.sModule   = self.g_dPrjModule.GetValue()
		self.cSTAPrj.sUser	 = self.g_dPrjUser.GetValue()

		iValid = self.cSTAPrj.GetValid()

		print iValid

		if  iValid == 0:
			self.EndModal(wx.ID_OK)
		elif iValid == 1:
			sta_utils.logError(self,"Please enter first an user name!")
		elif iValid == 2:
			sta_utils.logError(self,"Please enter first a module name!")
		elif iValid == 3:
			sta_utils.logError(self,"Please enter first a root folder!")
		elif iValid == 4:
			sta_utils.logError(self,"Please enter first a project address!")
		elif iValid == 5:
			sta_utils.logError(self,"Please enter first a name for the project!")
		else:
			sta_utils.logError(self,"This is not a valid project configuration!")

	def OnHelp(self,evt):
		self.cParentFrame.cHelp.html.ScrollToAnchor('s3.2.1')
		self.cParentFrame.cHelp.Show(True)

	def OnCancel(self,event):
		self.EndModal(wx.ID_CANCEL)

	def OnSelectType(self,event):
		self.setUpDynamic(self.g_dPrjType.GetValue())

#=================================================================================
#																	CSettings
#=================================================================================
class CSettingsDialog(wx.Dialog):
	def __init__(self,p_cParent, *args, **kwds):
		#--------------------------------- Data ---

		self.cParent		= p_cParent

		#------------------------------------ GUI
		wx.Dialog.__init__(self, *args, **kwds)

		self.SetTitle('Settings')

		notebook = wx.Notebook(self, -1, style=0)
		notebook_pane_proc = wx.Panel(notebook, -1)
		notebook_pane_vis = wx.Panel(notebook, -1)
		notebook_pane_scm = wx.Panel(notebook, -1)

		notebook.AddPage(notebook_pane_vis, "Visualization")
		notebook.AddPage(notebook_pane_proc, "Processing")
		notebook.AddPage(notebook_pane_scm, "Repository access")

		#------------------------------------ Visualization
		self.g_ckFileLabels		= wx.CheckBox(notebook_pane_vis, -1, "File labels")
		self.g_ckFileLabels.SetValue(True)
		self.g_ckFileLabels.SetInitialSize((-1, 15))
		self.g_ckAttrNameLabel	= wx.CheckBox(notebook_pane_vis, -1, "Metric label")
		self.g_ckAttrNameLabel.SetValue(True)
		self.g_ckAttrNameLabel.SetInitialSize((-1, 15))
		self.g_ckAttrLabels		= wx.CheckBox(notebook_pane_vis, -1, "Record labels")
		self.g_ckAttrLabels.SetValue(True)
		self.g_ckAttrLabels.SetInitialSize((-1, 15))
		self.g_ckAttrGrid		= wx.CheckBox(notebook_pane_vis, -1, "Time grid")
		self.g_ckAttrGrid.SetValue(True)
		self.g_ckAttrGrid.SetInitialSize((-1, 15))
		self.g_ckAttrTimeLabels	= wx.CheckBox(notebook_pane_vis, -1, "Time labels")
		self.g_ckAttrTimeLabels.SetValue(True)
		self.g_ckAttrTimeLabels.SetInitialSize((-1, 15))
		self.g_ckAttrVScale		= wx.CheckBox(notebook_pane_vis, -1, "Vertical scale")
		self.g_ckAttrVScale.SetValue(True)
		self.g_ckAttrVScale.SetInitialSize((-1, 15))

		#-- Markers
		l_cbMarkerDensity = wx.StaticText(notebook_pane_vis, -1, "Marker density")
		self.g_cbMarkerDensity = wx.ComboBox(notebook_pane_vis, -1, choices=[], style=wx.CB_DROPDOWN|wx.CB_READONLY)
		self.g_cbMarkerDensity.Append("Color spots")
		self.g_cbMarkerDensity.Append("Red spots")
		self.g_cbMarkerDensity.SetSelection(0)
		self.g_cbMarkerDensity.SetMinSize((100,-1))

		l_slideMarkerDensity_detail = wx.StaticText(notebook_pane_vis, -1, "Marker size")
		self.g_slideMarkerDensity_detail = wx.Slider(notebook_pane_vis, -1, 40, 5, 50)

		l_slideMarkerDensity_intensity = wx.StaticText(notebook_pane_vis, -1, "Marker intensity")
		self.g_slideMarkerDensity_intensity = wx.Slider(notebook_pane_vis, -1, 10, 1, 99)

		sizer_marker = wx.FlexGridSizer(3,2,1,1)
		sizer_marker.Add(l_cbMarkerDensity, 0, wx.EXPAND,0)
		sizer_marker.Add(self.g_cbMarkerDensity, 1, wx.EXPAND,0)
		sizer_marker.Add(l_slideMarkerDensity_detail, 0, wx.EXPAND, 0)
		sizer_marker.Add(self.g_slideMarkerDensity_detail, 1, wx.EXPAND, 0)
		sizer_marker.Add(l_slideMarkerDensity_intensity, 0, wx.EXPAND, 0)
		sizer_marker.Add(self.g_slideMarkerDensity_intensity, 1, wx.EXPAND, 0)
		sizer_marker.AddGrowableCol(1)

		#-- Clusters
		l_sLine_1 = wx.StaticLine(notebook_pane_vis)

		l_sFitToSize = wx.StaticText(notebook_pane_vis, -1, "File size")
		self.g_sFitToSize = wx.SpinCtrl(notebook_pane_vis, -1, "")
		self.g_sFitToSize.SetRange(1,30)
		self.g_sFitToSize.SetValue(14)
		self.g_sFitToSize.SetInitialSize((100,-1))

		l_cbVMetric = wx.StaticText(notebook_pane_vis, -1, "Vertical metric")
		self.g_cbVMetric = wx.ComboBox(notebook_pane_vis, -1, choices=[], style=wx.CB_DROPDOWN)
		self.g_cbVMetric.Append("Bars")
		self.g_cbVMetric.Append("Rainbow")

		l_sliderPlateau = wx.StaticText(notebook_pane_vis, -1, "Cluster edge")
		self.g_sliderPlateau = wx.Slider(notebook_pane_vis, -1, 15, 0, 100)

		sizer_cluster = wx.FlexGridSizer(1,2,1,1)
		sizer_cluster.Add(l_sFitToSize, 0, wx.EXPAND,0)
		sizer_cluster.Add(self.g_sFitToSize, 1, wx.EXPAND,0)
		sizer_cluster.Add(l_cbVMetric, 0, wx.EXPAND,0)
		sizer_cluster.Add(self.g_cbVMetric, 1, wx.EXPAND,0)
		sizer_cluster.Add(l_sliderPlateau, 0, wx.EXPAND,0)
		sizer_cluster.Add(self.g_sliderPlateau, 1, wx.EXPAND,0)
		sizer_cluster.AddGrowableCol(1)

		#-- Sizers
		sizer_vis_1_sb = wx.StaticBox(notebook_pane_vis, -1, "Labels")
		sizer_vis_1 = wx.StaticBoxSizer(sizer_vis_1_sb, wx.VERTICAL)
		sizer_vis_1.Add(self.g_ckFileLabels, 0, wx.TOP|wx.ADJUST_MINSIZE, 5)
		sizer_vis_1.Add(self.g_ckAttrNameLabel, 0, wx.TOP|wx.FIXED_MINSIZE, 0)
		sizer_vis_1.Add(self.g_ckAttrLabels, 0, wx.TOP|wx.FIXED_MINSIZE, 0)
		sizer_vis_1.Add(self.g_ckAttrGrid, 0, wx.TOP|wx.FIXED_MINSIZE, 0)
		sizer_vis_1.Add(self.g_ckAttrTimeLabels, 0, wx.TOP|wx.FIXED_MINSIZE, 0)
		sizer_vis_1.Add(self.g_ckAttrVScale, 0, wx.TOP|wx.FIXED_MINSIZE, 0)

		sizer_vis_2 = wx.BoxSizer(wx.VERTICAL)
		sizer_vis_2.Add(sizer_cluster, 0, wx.EXPAND, 0)
		sizer_vis_2.Add(l_sLine_1, 0,  wx.TOP| wx.BOTTOM | wx.EXPAND, 10)
		sizer_vis_2.Add(sizer_marker, 0, wx.EXPAND, 0)
		sizer_vis_2.AddStretchSpacer()

		sizer_vis = wx.BoxSizer(wx.HORIZONTAL)
		sizer_vis.Add(sizer_vis_2, 0, wx.ALL|wx.EXPAND, 5)
		sizer_vis.Add(sizer_vis_1, 1, wx.ALL|wx.EXPAND, 5)

		notebook_pane_vis.SetSizer(sizer_vis)
		sizer_vis.Fit(notebook_pane_vis)

		#------------------------------------ Processing
		l_cbClusterDistance = wx.StaticText(notebook_pane_proc, -1, " Cluster distance function   ")
		l_cbClusterDistance.SetMinSize((150, -1))
		self.g_cbClusterDistance = wx.ComboBox(notebook_pane_proc, -1, choices=[], style=wx.CB_DROPDOWN|wx.CB_READONLY)
		self.g_cbClusterDistanceBut = wx.Button(notebook_pane_proc,-1,'Settings')
		self.g_cbClusterDistanceBut.Enable(False)
		sizer_cluster_1 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_cluster_1.Add(self.g_cbClusterDistance, 0, wx.ADJUST_MINSIZE, 0)
		sizer_cluster_1.Add(self.g_cbClusterDistanceBut, 0, wx.ADJUST_MINSIZE, 0)

		#-- Sizers
		sizer_proc_1 = wx.BoxSizer(wx.VERTICAL)
		sizer_proc_1.Add(l_cbClusterDistance, 0, wx.ADJUST_MINSIZE, 0)
		sizer_proc_1.Add(sizer_cluster_1, 0, wx.EXPAND, 0)

		sizer_proc = wx.BoxSizer(wx.HORIZONTAL)
		sizer_proc.Add(sizer_proc_1, 1, wx.ALL|wx.EXPAND, 5)

		notebook_pane_proc.SetSizer(sizer_proc)
		sizer_proc.Fit(notebook_pane_proc)

		#------------------------------------ Repository access
		l_spinSCMRetries = wx.StaticText(notebook_pane_scm, -1, " SCM retries")
		self.g_spinSCMRetries = wx.SpinCtrl(notebook_pane_scm, -1,min=0,max=100,initial=sta_globals.iSVNRetries)
		self.g_spinSCMRetries.SetInitialSize((100,20))

		sizer_scm_1 = wx.FlexGridSizer(1,2,1,1)
		sizer_scm_1.Add(l_spinSCMRetries, 0, wx.ADJUST_MINSIZE, 0)
		sizer_scm_1.Add(self.g_spinSCMRetries, 0, wx.TOP|wx.ADJUST_MINSIZE, 0)
		sizer_scm_1.AddGrowableCol(1)

		sizer_scm = wx.BoxSizer(wx.HORIZONTAL)
		sizer_scm.Add(sizer_scm_1, 1, wx.ALL|wx.EXPAND, 5)

		notebook_pane_scm.SetSizer(sizer_scm)
		sizer_scm.Fit(notebook_pane_scm)

		#------------------------------------- Buttons
		l_cStaticLine		= wx.StaticLine(self,-1)
		self.bDismiss		= wx.Button(self, -1, "Cancel")
		self.bDHelp			= wx.Button(self, -1, "Help")

		sizer_buttons = wx.BoxSizer(wx.HORIZONTAL)
		sizer_buttons.Add(self.bDismiss,0, wx.ALL | wx.EXPAND, 2)
		sizer_buttons.Add(self.bDHelp,0, wx.ALL | wx.EXPAND, 2)

		#------------------------------------- Main
		sizer_main = wx.BoxSizer(wx.VERTICAL)
		sizer_main.Add(notebook, 1, wx.ALL | wx.EXPAND, 2)
		sizer_main.Add(l_cStaticLine,0, wx.ALL | wx.EXPAND, 2)
		sizer_main.Add(sizer_buttons,0, wx.ALL | wx.ALIGN_RIGHT , 1)
		sizer_main.Fit(self)
		self.SetSizer(sizer_main)

		#------------------------------------ Callbacks
		self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
		self.bDismiss.Bind(wx.EVT_BUTTON, self.OnDismiss)
		self.bDHelp.Bind(wx.EVT_BUTTON, self.OnHelp)

	def OnHelp(self,evt):
		self.cParent.mainFrame.cHelp.html.ScrollToAnchor('s3.9')
		self.cParent.mainFrame.cHelp.Show(True)

	def OnDismiss(self,evt):
		self.Hide()

	def OnCloseWindow(self, event):
		event.Veto()
		self.Hide()

	def RegisterPlugins(self):

		#--- Cluster plugins
		for i in sta_globals.lPlugins_Cluster:
			self.g_cbClusterDistance.Append(i.sName)

		if len(sta_globals.lPlugins_Cluster)>0:
			self.g_cbClusterDistance.SetSelection(0)
			if (sta_globals.lPlugins_Cluster[0].bHasGUI):
				self.g_cbClusterDistanceBut.Enable(True)

#=================================================================================
#															CComputeMetricsDialog
#=================================================================================
class CComputeMetricsDialog(wx.Dialog):
	def __init__(self,p_cParent, *args, **kwds):
		#--------------------------------- Data ---

		self.cParent		= p_cParent

		#------------------------------------ GUI
		wx.Dialog.__init__(self, *args, **kwds)

		self.SetTitle('Compute metrics')

		l_metrics_tMetrics		= wx.StaticText(self, -1, " Extracted metrics")
		self.metrics_lMetrics	= wx.ListBox(self, -1, choices=[])
		self.metrics_lMetrics.SetMinSize((120, 180))
		self.metrics_bRemove	= wx.Button(self, -1, "Remove")
		self.metrics_bRemove.SetMinSize((120, 20))
		self.metrics_bRemove.Disable()

		l_metrics_tGenerator	= wx.StaticText(self, -1, " Extractors")
		self.metrics_lGenerators= wx.ListBox(self, -1, choices=[])
		self.metrics_lGenerators.SetMinSize((120, 180))
		self.metrics_bGenerate	= wx.Button(self, -1, "Extract")
		self.metrics_bGenerate.SetMinSize((120, 20))
		self.metrics_bGenerate.Disable()

		l_metrics_tInfoTitle	= wx.StaticText(self, -1, " Info")
		self.metrics_tInfo		= wx.html.HtmlWindow(self, style=wx.SUNKEN_BORDER)
		self.metrics_tInfo.SetMinSize((280, -1))
		self.metrics_cProgress	= wx.Gauge(self, -1, 10, style=wx.GA_HORIZONTAL|wx.GA_SMOOTH)
		self.metrics_cProgress.SetMinSize((-1, 10))
		self.metrics_bCancel	= wx.Button(self, -1, "Cancel")
		self.metrics_bCancel.SetMinSize((80, 20))
		self.metrics_bCancel.Disable()

		l_cStaticLine		= wx.StaticLine(self,-1)
		self.bDismiss		= wx.Button(self, -1, "Done")
		self.bDHelp			= wx.Button(self, -1, "Help")

		#--- Sizers
		sizer_cp_metrics			= wx.BoxSizer(wx.HORIZONTAL)
		sizer_cp_metrics_metrics	= wx.BoxSizer(wx.VERTICAL)
		sizer_cp_metrics_generators	= wx.BoxSizer(wx.VERTICAL)
		sizer_cp_metrics_info		= wx.BoxSizer(wx.VERTICAL)
		sizer_cp_metrics_info_bar	= wx.BoxSizer(wx.HORIZONTAL)

		sizer_cp_metrics_metrics.Add(l_metrics_tMetrics, 0, wx.ADJUST_MINSIZE|wx.TOP|wx.BOTTOM, 3)
		sizer_cp_metrics_metrics.Add(self.metrics_lMetrics, 1, wx.EXPAND, 0)
		sizer_cp_metrics_metrics.Add(self.metrics_bRemove, 0, wx.ADJUST_MINSIZE, 0)
		sizer_cp_metrics_metrics.Layout()
		sizer_cp_metrics.Add(sizer_cp_metrics_metrics, 0, wx.EXPAND, 0)

		sizer_cp_metrics_generators.Add(l_metrics_tGenerator, 0, wx.ADJUST_MINSIZE|wx.TOP|wx.BOTTOM, 3)
		sizer_cp_metrics_generators.Add(self.metrics_lGenerators, 1, wx.EXPAND, 0)
		sizer_cp_metrics_generators.Add(self.metrics_bGenerate , 0, wx.ADJUST_MINSIZE, 0)
		sizer_cp_metrics_generators.Layout()
		sizer_cp_metrics.Add(sizer_cp_metrics_generators, 0, wx.EXPAND, 0)

		sizer_cp_metrics_info.Add(l_metrics_tInfoTitle, 0, wx.ADJUST_MINSIZE|wx.TOP|wx.BOTTOM, 3)
		sizer_cp_metrics_info.Add(self.metrics_tInfo, 1, wx.EXPAND|wx.ADJUST_MINSIZE, 0)

		sizer_cp_metrics_info_bar.Add(self.metrics_cProgress, 1, wx.EXPAND|wx.RIGHT|wx.LEFT, 2)
		sizer_cp_metrics_info_bar.Add(self.metrics_bCancel, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		sizer_cp_metrics_info_bar.Layout()
		sizer_cp_metrics_info.Add(sizer_cp_metrics_info_bar, 0, wx.EXPAND, 0)

		sizer_cp_metrics.Add(sizer_cp_metrics_info, 1, wx.EXPAND, 0)

		sizer_buttons = wx.BoxSizer(wx.HORIZONTAL)
		sizer_buttons.Add(self.bDismiss,0, wx.ALL | wx.EXPAND, 2)
		sizer_buttons.Add(self.bDHelp,0, wx.ALL | wx.EXPAND, 2)

		#------------------------------------- Main
		sizer_main = wx.BoxSizer(wx.VERTICAL)
		sizer_main.Add(sizer_cp_metrics,1, wx.ALL |wx.EXPAND, 3)
		sizer_main.Add(l_cStaticLine,0, wx.ALL | wx.EXPAND, 2)
		sizer_main.Add(sizer_buttons,0, wx.ALL | wx.ALIGN_RIGHT , 1)
		sizer_main.Fit(self)
		self.SetSizer(sizer_main)

		#------------------------------------ Callbacks
		self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
		self.bDismiss.Bind(wx.EVT_BUTTON, self.OnDismiss)
		self.bDHelp.Bind(wx.EVT_BUTTON, self.OnHelp)

	def OnHelp(self,evt):
		self.cParent.mainFrame.cHelp.html.ScrollToAnchor('s3.7')
		self.cParent.mainFrame.cHelp.Show(True)

	def OnDismiss(self,evt):
		self.Hide()

	def OnCloseWindow(self, event):
		event.Veto()
		self.Hide()

	def RegisterPlugins(self):

		#--- Metric generator plugins
		for i in sta_globals.lPlugins_MetricGenerator:
			self.metrics_lGenerators.Append(i.sName)

class COpenProjectDialog(wx.Dialog):
	def __init__(self,p_cParent, *args, **kwds):
		#--------------------------------- Data ---

		self.cParent		= p_cParent

		#------------------------------------ GUI
		wx.Dialog.__init__(self, *args, **kwds)

		self.SetTitle('Open analysis project')

		self.g_listProjects = ExListCtrl(self, -1, style=wx.LC_REPORT | wx.LC_VRULES | wx.LC_SINGLE_SEL )
		self.g_listProjects.InsertColumn(0,'Project')
		self.g_listProjects.InsertColumn(1,'#Files')
		self.g_listProjects.InsertColumn(2,'Last update')
		self.g_listProjects.SetColumnWidth(0,100)
		self.g_listProjects.SetColumnWidth(1,70)
		self.g_listProjects.SetColumnWidth(2,70)
		self.g_listProjects.SetMinSize((280,150))

		self.g_bPrjNew = wx.Button(self, 1, "New")
		self.g_bPrjEdit = wx.Button(self, 2, "Edit")
		self.g_bPrjDelete = wx.Button(self, 3, "Delete")
		self.g_bPrjLoad = wx.Button(self, 4, "Load")

		#--- Sizers
		sizer_ProjectButtons = wx.BoxSizer(wx.VERTICAL)
		sizer_ProjectButtons.Add(self.g_bPrjNew, 0, wx.FIXED_MINSIZE, 0)
		sizer_ProjectButtons.Add(self.g_bPrjEdit, 0, wx.FIXED_MINSIZE, 0)
		sizer_ProjectButtons.Add(self.g_bPrjDelete, 0, wx.FIXED_MINSIZE, 0)
		sizer_ProjectButtons.AddStretchSpacer()
		sizer_ProjectButtons.Add(self.g_bPrjLoad, 0, wx.ALIGN_BOTTOM|wx.FIXED_MINSIZE, 0)

		sizer_ProjectList = wx.BoxSizer(wx.HORIZONTAL)
		sizer_ProjectList.Add(self.g_listProjects, 0, wx.ALL|wx.EXPAND|wx.ADJUST_MINSIZE, 3)
		sizer_ProjectList.Add(sizer_ProjectButtons, 1, wx.EXPAND, 0)

		#------------------------------------- Buttons
		l_cStaticLine		= wx.StaticLine(self,-1)
		self.bDismiss		= wx.Button(self, -1, "Cancel")
		self.bDHelp			= wx.Button(self, -1, "Help")

		sizer_buttons = wx.BoxSizer(wx.HORIZONTAL)
		sizer_buttons.Add(self.bDismiss,0, wx.ALL | wx.EXPAND, 2)
		sizer_buttons.Add(self.bDHelp,0, wx.ALL | wx.EXPAND, 2)

		#------------------------------------- Main
		sizer_main = wx.BoxSizer(wx.VERTICAL)
		sizer_main.Add(sizer_ProjectList, 1, wx.ALL | wx.EXPAND, 2)
		sizer_main.Add(l_cStaticLine,0, wx.ALL | wx.EXPAND, 2)
		sizer_main.Add(sizer_buttons,0, wx.ALL | wx.ALIGN_RIGHT , 1)
		sizer_main.Fit(self)
		self.SetSizer(sizer_main)

		#------------------------------------ Callbacks
		self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
		self.bDismiss.Bind(wx.EVT_BUTTON, self.OnDismiss)
		self.bDHelp.Bind(wx.EVT_BUTTON, self.OnHelp)
		self.Bind(wx.EVT_KEY_DOWN, self.OnKey)

	def OnKey(self,evt):
		if (evt.GetKeyCode() == wx.WXK_ESCAPE):
			self.Hide()

	def OnHelp(self,evt):
		self.cParent.mainFrame.cHelp.html.ScrollToAnchor('s3.2.2')
		self.cParent.mainFrame.cHelp.Show(True)

	def OnDismiss(self,evt):
		self.Hide()

	def AddProject(self,p_cPrj):
		l_iItem = self.g_listProjects.GetItemCount()
		self.g_listProjects.InsertStringItem(l_iItem,p_cPrj.sName)
		self.g_listProjects.SetStringItem(l_iItem,1,str(p_cPrj.iFiles))
		self.g_listProjects.SetStringItem(l_iItem,2,p_cPrj.sDate)
		return l_iItem

	def GetSelection(self):
		l_iItems = self.g_listProjects.GetItemCount()
		for i in xrange(l_iItems):
			l_iState = self.g_listProjects.GetItemState(i,wx.LIST_STATE_SELECTED)
			if (l_iState == wx.LIST_STATE_SELECTED):
				return i
		return wx.NOT_FOUND

	def InitView(self):
		self.g_bPrjNew.Enable(True)
		self.g_bPrjEdit.Disable()
		self.g_bPrjDelete.Disable()
		self.g_bPrjLoad.Disable()

	def OnCloseWindow(self, event):
		event.Veto()
		self.Hide()

	def enablePrjButtons(self,l_sw):

		if l_sw:
			self.g_bPrjNew.Enable(True)
			self.g_bPrjEdit.Enable(True)
			self.g_bPrjDelete.Enable(True)
			self.g_bPrjLoad.Enable(True)
		else:
			self.g_bPrjNew.Disable()
			self.g_bPrjEdit.Disable()
			self.g_bPrjDelete.Disable()
			self.g_bPrjLoad.Disable()

#////////////////////////////////////////////////////////////////////////////////
#							Main Frame
#////////////////////////////////////////////////////////////////////////////////
class CMainFrame(wx.Frame):

	def __init__(self, *args, **kwds):

		kwds["style"] = wx.DEFAULT_FRAME_STYLE
		wx.Frame.__init__(self, *args, **kwds)

		self.SetTitle(sta_globals.sProjectName)
		_icon = wx.EmptyIcon()
		_icon.CopyFromBitmap(wx.Bitmap("cfg/img/time.ico", wx.BITMAP_TYPE_ANY))
		self.SetIcon(_icon)
		self.SetSize((1036, 768))
		self.SetSizeHints(1036, 768)

		#---------------------------------------------------------------------------- Status bar
		self.statusbar = self.CreateStatusBar(7, 0)
		self.statusbar.SetStatusWidths([-1, 150, 150, 100, 100, 70, 70])
		statusbar_fields = ["", "", "", "", "", "", ""]
		for i in range(len(statusbar_fields)):
			self.statusbar.SetStatusText(statusbar_fields[i], i)

		#---------------------------------------------------------------------------- Windows
		self.window_top = wx.SplitterWindow(self, -1, style = wx.SP_3D)
		panel_control = wx.Panel(self.window_top, -1)
		panel_display = wx.Panel(self.window_top, -1)
		panel_control.Bind(wx.EVT_SIZE,self.cbFilterSize)

		self.window_main = wx.SplitterWindow(panel_display, 1001, style=wx.SP_3DSASH)
		self.window_tree = wx.Panel(self.window_main, -1)
		self.window_display_holder = wx.Panel(self.window_main, -1)

		self.window_display = wx.SplitterWindow(self.window_display_holder, -1, style=wx.SP_3DSASH)
		self.window_evolution = wx.Panel(self.window_display, -1)
		self.window_graphs = wx.Panel(self.window_display, -1)

		self.window_top.SplitHorizontally(panel_control, panel_display, 230)
		self.window_main.SplitVertically(self.window_tree, self.window_display_holder, 200)
		self.window_display.SplitHorizontally(self.window_evolution, self.window_graphs, 0)

		self.window_display.Unsplit(self.window_graphs)
		self.window_top.SetMinimumPaneSize(230)
		self.window_main.SetMinimumPaneSize(200)
		self.window_display.SetMinimumPaneSize(100)

		# Sizers
		sizer_display = wx.BoxSizer(wx.VERTICAL)
		sizer_display.Add(self.window_main, 1, wx.EXPAND, 0)
		panel_display.SetSizer(sizer_display)
		sizer_display.Fit(panel_display)

		sizer_display_holder = wx.BoxSizer(wx.VERTICAL)
		sizer_display_holder.Add(self.window_display, 1, wx.EXPAND, 0)
		self.window_display_holder.SetSizer(sizer_display_holder)
		sizer_display_holder.Fit(self.window_display_holder)
		sizer_display_holder.SetSizeHints(self.window_display_holder)

		#----------------------------------------------------------------------------- Top Menu
		cMenuBar = wx.MenuBar()

		self.cMenuFile = wx.Menu()
		self.cMenuFile.Append(10100,'New...	Ctrl+N','Create new project')
		self.cMenuFile.Append(10101,'Open...	Ctrl+O','Open an existing project')
		self.cMenuFile.AppendSeparator()

		self.cMenuFile.Append(10102,'Export...','Export a project data for use on another machine')
		self.cMenuFile.Append(10103,'Import...','Import a project data')
		self.cMenuFile.AppendSeparator()
		self.cMenuFile.Enable(10102,False)

		self.cMenuFile.Append(10110,'Exit','Exit the application')
		cMenuBar.Append(self.cMenuFile,'File')

		self.cMenuTools = wx.Menu()
		self.cMenuTools.Append(10700,'Compute metrics...','Compute metrics')
		self.cMenuTools.Append(10701,'Full Update of selected files','Full update (files, versions, content, metrics) of selected files.')
		cMenuBar.Append(self.cMenuTools,'Tools')

		self.cMenuSettings = wx.Menu()
		self.cMenuSettings.Append(10800,'Settings...','Tweak the analysis and visualization parameters')
		cMenuBar.Append(self.cMenuSettings,'Settings')

		self.cMenuHelp = wx.Menu()
		self.cMenuHelp.Append(10900,'Help','The user manual')
		self.cMenuHelp.Append(10901,'About','Information about the product')
		cMenuBar.Append(self.cMenuHelp,'Help')

		self.cHelp = sta_help.CHelp(self, -1, "Help", size=(690, 600),style = wx.DEFAULT_FRAME_STYLE|wx.STAY_ON_TOP )

		self.SetMenuBar(cMenuBar)

		#---------------------------------------------------------------------------- Notebook
		self.notebook_1 = wx.Notebook(panel_control, -1, style=0)
		self.notebook_1_pane_clusters = wx.Panel(self.notebook_1, -1)
		self.notebook_1_pane_filters = wx.Panel(self.notebook_1, -1)

		self.notebook_1.AddPage(self.notebook_1_pane_filters, "Metrics")
		self.notebook_1.AddPage(self.notebook_1_pane_clusters, "Clusters")

		#------------------------------------------------------------------- Filters panel pane
		self.project_filters = wx.ScrolledWindow(self.notebook_1_pane_filters, -1)
		sizer_filters = wx.BoxSizer(wx.HORIZONTAL)
		sizer_filters.Add(self.project_filters, 1, wx.EXPAND, 0)

		# Notebook
		self.notebook_1_pane_filters.SetSizer(sizer_filters)

		#------------------------------------------------------------------- Blender panel
		panel_blender			= wx.Panel(panel_control, -1,style=wx.SUNKEN_BORDER)
		self.project_blender	= sta_gl.glPanel(panel_blender)
		self.project_blender.SetSize((350,220))

		# Sizers
		sizer_blender = wx.BoxSizer(wx.HORIZONTAL)
		sizer_blender.Add(self.project_blender, 1, wx.EXPAND, 0)
		panel_blender.SetSizer(sizer_blender)
		#sizer_blender.Fit(panel_blender)

		#---------------------------------------------------------------------- Clusters
		self.panelGL_clusters = sta_gl.glPanel(self.notebook_1_pane_clusters,style=wx.SUNKEN_BORDER)
		sizer_clusters = wx.BoxSizer(wx.VERTICAL)
		sizer_clusters.Add(self.panelGL_clusters, 1, wx.EXPAND, 0)

		# Notebook
		self.notebook_1_pane_clusters.SetSizer(sizer_clusters)
		sizer_clusters.Fit(self.notebook_1_pane_clusters)
		sizer_clusters.SetSizeHints(self.notebook_1_pane_clusters)

		#---------------------------------------------------------------------- Selections
		self.g_listSelections = wx.ListBox(self.window_tree, -1, choices=[])
		self.g_listSelections.SetMinSize((200,100))

		#--- Selections menu (pop-up
		self.cMenuSelections = wx.Menu("Selections")
		self.cMenuSelections.Append(801,"Rename")
		self.cMenuSelections.AppendSeparator()
		self.cMenuSelections.Append(802,"Delete")

		#--- Selections
		sizer_selections_sb = wx.StaticBox(self.window_tree, -1, "Available file selections")
		sizer_selections = wx.StaticBoxSizer(sizer_selections_sb, wx.VERTICAL)
		sizer_selections.Add(self.g_listSelections, 1, wx.ALL|wx.EXPAND, 3)

		#----------------------------------------------------------------------- File tree
		self.g_listFiles = wx.TreeCtrl(self.window_tree, -1, style=wx.TR_HAS_BUTTONS|wx.TR_LINES_AT_ROOT|wx.TR_DEFAULT_STYLE|wx.SUNKEN_BORDER)
		self.g_listFiles.SetMinSize((200,-1))

		#--- File tree pop-up
		self.cMenuFileTree = wx.Menu("Data management")
		self.cMenuFileTree.Append(701,"Update version info")
		self.cMenuFileTree.Append(702,"Update file content")
		self.cMenuFileTree.AppendSeparator()
		self.cMenuFileTree.Append(709,"Clear version info")

		#--- Sizers
		sizer_tree_sb = wx.StaticBox(self.window_tree, -1, "Project file tree")
		sizer_tree = wx.StaticBoxSizer(sizer_tree_sb, wx.VERTICAL)
		sizer_tree.Add(self.g_listFiles, 1, wx.ALL|wx.EXPAND, 3)

		#----------------------------------------------------------------------- Data acquisition
		self.g_gFile = wx.Gauge(self.window_tree, -1, 10, style=wx.GA_HORIZONTAL|wx.GA_SMOOTH)
		self.g_gFile.SetMinSize((-1, 10))
		self.g_gFile.SetInitialSize((-1, 10))
		self.g_gContent = wx.Gauge(self.window_tree, -1, 10, style=wx.GA_HORIZONTAL|wx.GA_SMOOTH)
		self.g_gContent.SetMinSize((-1, 10))
		self.g_gContent.SetInitialSize((-1, 10))
		self.g_cConnection = throbber.Throbber(self.window_tree,-1,sta_globals.cConnectionBmp,frames=6,frameWidth=150,frameDelay = 0.15,reverse=1)

		self.g_bPrjUpdate = wx.BitmapButton(self.window_tree, -1, wx.Bitmap("cfg/img/filedir1.bmp", wx.BITMAP_TYPE_ANY))
		self.g_bPrjUpdate.SetToolTipString("Get list of files in the project")
		self.g_bPrjClear = wx.BitmapButton(self.window_tree, -1, wx.Bitmap("cfg/img/filedir2.bmp", wx.BITMAP_TYPE_ANY))
		self.g_bPrjClear.SetToolTipString("Clean the file list")
		self.g_bFileUpdate = wx.BitmapButton(self.window_tree, -1, wx.Bitmap("cfg/img/filever1.bmp", wx.BITMAP_TYPE_ANY))
		self.g_bFileUpdate.SetToolTipString("Get file history")
		self.g_bFileClear = wx.BitmapButton(self.window_tree, -1, wx.Bitmap("cfg/img/filever2.bmp", wx.BITMAP_TYPE_ANY))
		self.g_bFileClear.SetToolTipString("Remove history information")
		self.g_bFileContent = wx.BitmapButton(self.window_tree, -1, wx.Bitmap("cfg/img/filein1.bmp", wx.BITMAP_TYPE_ANY))
		self.g_bFileContent.SetToolTipString("Get file content")
		self.g_bFileCancel = wx.BitmapButton(self.window_tree, -1, wx.Bitmap("cfg/img/cancel.bmp", wx.BITMAP_TYPE_ANY))
		self.g_bFileCancel.SetToolTipString("Cancel current operation")

		# Sizers
		sizer_progress = wx.BoxSizer(wx.VERTICAL)
		sizer_progress.Add(self.g_cConnection, 0, wx.ALL|wx.ADJUST_MINSIZE|wx.ALIGN_CENTER_HORIZONTAL, 1)
		sizer_progress.Add(self.g_gFile, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
		sizer_progress.Add(self.g_gContent, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)

		sizer_buttons = wx.BoxSizer(wx.HORIZONTAL)
		sizer_buttons.Add(self.g_bPrjUpdate,0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		sizer_buttons.Add(self.g_bPrjClear,0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		sizer_buttons.AddStretchSpacer()
		sizer_buttons.Add(self.g_bFileUpdate,0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		sizer_buttons.Add(self.g_bFileClear,0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		sizer_buttons.AddStretchSpacer()
		sizer_buttons.Add(self.g_bFileContent,0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		sizer_buttons.AddStretchSpacer()
		sizer_buttons.Add(self.g_bFileCancel,0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)

		#----------------------------------------------------------------------- Toolbar
		self.g_toolViews = wx.ToolBar(panel_control,-1,style = wx.TB_VERTICAL)
		self.g_toolViews.SetToolBitmapSize(wx.Size(32,32))
		self.g_toolViews.SetToolPacking(3)

		cImage1 = wx.Image("cfg/img/details.bmp",type=wx.BITMAP_TYPE_BMP)
		cBitmap1 = wx.BitmapFromImage(cImage1)

		cImage2 = wx.Image("cfg/img/files.bmp",type=wx.BITMAP_TYPE_BMP)
		cBitmap2 = wx.BitmapFromImage(cImage2)

		cImage3 = wx.Image("cfg/img/chart.bmp",type=wx.BITMAP_TYPE_BMP)
		cBitmap3 = wx.BitmapFromImage(cImage3)

		cImage4 = wx.Image("cfg/img/cmd.bmp",type=wx.BITMAP_TYPE_BMP)
		cBitmap4 = wx.BitmapFromImage(cImage4)

		self.g_toolViews.AddCheckTool(400,cBitmap1,shortHelp="Show version info")	# Details
		self.g_toolViews.AddCheckTool(401,cBitmap2, shortHelp="Show file tree ")	# Tree
		self.g_toolViews.ToggleTool(401,True)
		self.g_toolViews.AddCheckTool(402,cBitmap3,shortHelp="Show attribute evolution")	# Charts
		self.g_toolViews.AddCheckTool(403,cBitmap4,shortHelp="Show command log")	# Log window

		self.g_toolViews.Realize()

		#---------------------------------------------------------------------- Project evolution

		self.bitmap_button_1 = wx.BitmapButton(self.window_evolution, -1, wx.Bitmap("cfg/img/home.ico", wx.BITMAP_TYPE_ANY))
		self.bitmap_button_1.SetToolTipString("Fit to selection")
		self.bitmap_button_1.SetInitialSize((16,16))
		self.bitmap_button_1.SetMinSize((16,16))
		self.bitmap_button_2 = wx.BitmapButton(self.window_evolution, -1, wx.Bitmap("cfg/img/eye.ico", wx.BITMAP_TYPE_ANY))
		self.bitmap_button_2.SetToolTipString("Fit to file")
		self.bitmap_button_2.SetInitialSize((16,16))
		self.bitmap_button_2.SetMinSize((16,16))
		self.bitmap_button_3 = wx.BitmapButton(self.window_evolution, -1, wx.Bitmap("cfg/img/horizontal.ico", wx.BITMAP_TYPE_ANY))
		self.bitmap_button_3.SetToolTipString("Remove focus interval")
		self.bitmap_button_3.SetInitialSize((16,16))
		self.bitmap_button_3.SetMinSize((16,16))
		self.bitmap_button_4 = wx.BitmapButton(self.window_evolution, -1, wx.Bitmap("cfg/img/vertical.ico", wx.BITMAP_TYPE_ANY))
		self.bitmap_button_4.SetToolTipString("Change metric")
		self.bitmap_button_4.SetInitialSize((16,16))
		self.bitmap_button_4.SetMinSize((16,16))

		self.g_scrollY = wx.ScrollBar(self.window_evolution, -1, style= wx.SB_VERTICAL)
		self.g_scrollX = wx.ScrollBar(self.window_evolution, -1, style= wx.SB_HORIZONTAL)
		self.g_scrollY.SetMinSize((16, -1))
		self.g_scrollX.SetMinSize((-1,16))

		self.panel_horizontal_metric = sta_gl.glPanel(self.window_evolution)
		self.panel_horizontal_metric.SetMinSize((-1,16))
		self.panel_horizontal_metric.SetBackgroundColour(wx.Colour(166, 166, 166))

		self.panel_vertical_metric = sta_gl.glPanel(self.window_evolution)
		self.panel_vertical_metric.SetMinSize((16, -1))
		self.panel_vertical_metric.SetBackgroundColour(wx.Colour(166, 166, 166))

		self.g_panelOpenGLPrj = sta_gl.glPanel(self.window_evolution)		 # Main project evolution view
		self.g_panelOpenGLPrj.SetMinSize((0,0))

		#--- Project evolution menu pop-up menu
		self.cMenuFilters = wx.Menu("Filters")

		self.cMenu = wx.Menu("File arrange")
		self.cMenu.AppendCheckItem(151,"Sort alphabetically")
		self.cMenu.AppendCheckItem(152,"- on type")
		self.cMenu.AppendCheckItem(153,"- on creation time")
		self.cMenu.AppendCheckItem(154,"- on activity")
		self.cMenu.AppendCheckItem(155,"- on text hits")
		self.cMenu.AppendCheckItem(156,"- on local similarity")
		self.cMenu.AppendCheckItem(157,"- on similar transaction")
		self.cMenu.AppendCheckItem(150,"Invert sort")
		self.cMenu.AppendSeparator()

		# comparison name, statusbar name, use in clusters?, attribue name, delete attribue?, special handling
		sta_globals.lpSortFunction.append(('','',True))
		sta_globals.lpSortFunction.append((sta_data_manip.cmpFile_Alphabetically,'alphabetically',True,'',False,''))
		sta_globals.lpSortFunction.append((sta_data_manip.cmpFile_Type,'on type',True,'',False,''))
		sta_globals.lpSortFunction.append((sta_data_manip.cmpFile_Creation,'on creation time',True,'',False,''))
		sta_globals.lpSortFunction.append((sta_data_manip.cmpFile_Attr,'on activity',True,'activity',True,'MenuSort_activity'))
		sta_globals.lpSortFunction.append((sta_data_manip.cmpFile_Attr,'on text hits',True,'texthits',True,'MenuSort_hits'))
		sta_globals.lpSortFunction.append((sta_data_manip.cmpFile_Attr,'on similarity',False,'similarity',False,'MenuSort_simlarity'))
		sta_globals.lpSortFunction.append((sta_data_manip.cmpFile_Attr,'on transaction',False,'transaction',True,'MenuSort_transaction'))

		self.cMenu.Append(109,"Compute similarity")
		self.cMenu.AppendSeparator()
		self.cMenu.Append(114,"Remove transaction")
		self.cMenu.Append(116,"Remove cross transactions")
		self.cMenu.Append(118,"Remove selected versions")
		self.cMenu.AppendSeparator()
		self.cMenu.AppendMenu(112,"Group selected",self.cMenuFilters)
		self.cMenu.Append(111,"Get clustering score")
		self.cMenu.Append(107,"Compute clusters")
		self.cMenu.Append(110,"Clean clusters")
		self.cMenu.AppendCheckItem(108,"Preserve clusters")
		self.cMenu.AppendSeparator()
		self.cMenu.Append(119,"Save selection")
		self.cMenu.Append(117,"Save frequency list")
		self.cMenu.Append(115,"Take snaphot")

		#--- Sizers
		sizer_evolution = wx.FlexGridSizer(3, 3, 0, 0)
		sizer_evolution.Add(self.bitmap_button_1, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
		sizer_evolution.Add(self.panel_horizontal_metric, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
		sizer_evolution.Add(self.bitmap_button_3, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
		sizer_evolution.Add(self.panel_vertical_metric, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
		sizer_evolution.Add(self.g_panelOpenGLPrj, 0, wx.EXPAND, 0)
		sizer_evolution.Add(self.g_scrollY, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
		sizer_evolution.Add(self.bitmap_button_4, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
		sizer_evolution.Add(self.g_scrollX, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
		sizer_evolution.Add(self.bitmap_button_2, 0, wx.EXPAND|wx.FIXED_MINSIZE, 0)
		self.window_evolution.SetSizer(sizer_evolution)
		sizer_evolution.Fit(self.window_evolution)
		sizer_evolution.SetSizeHints(self.window_evolution)
		sizer_evolution.AddGrowableRow(1)
		sizer_evolution.AddGrowableCol(1)

		#--------------------------------------------------------------------- Evolution graphs
		self.sizerAttributeView = wx.BoxSizer(wx.VERTICAL)
		self.window_graphs.SetSizer(self.sizerAttributeView)
		self.sizerAttributeView.Fit(self.window_graphs)

		#---------------------------------------------------------------------- Integration

		# Top part
		sizer_control = wx.BoxSizer(wx.HORIZONTAL)
		sizer_control.Add(self.notebook_1, 1, wx.EXPAND | wx.LEFT, 2)
		sizer_control.Add(panel_blender, 0, wx.EXPAND | wx.ALL, 2)
		sizer_control.Add(self.g_toolViews, 0, wx.EXPAND | wx.LEFT, 2)
		panel_control.SetSizer(sizer_control)
		sizer_control.Fit(panel_control)

		# Source navigation part
		sizer_source = wx.BoxSizer(wx.VERTICAL)
		sizer_source.Add(sizer_selections, 0, wx.ALL|wx.EXPAND, 2)
		sizer_source.Add(sizer_tree, 1, wx.ALL|wx.EXPAND, 2)
		sizer_source.Add(sizer_progress, 0, wx.ALL|wx.EXPAND, 3)
		sizer_source.Add(sizer_buttons, 0, wx.EXPAND, 0)
		self.window_tree.SetSizer(sizer_source)
		sizer_source.Fit(self.window_tree)

		# Complete
		sizer_main = wx.BoxSizer(wx.VERTICAL)
		sizer_main.Add(self.window_top, 1, wx.EXPAND, 0)
		self.SetSizer(sizer_main)
		self.Layout()

	#----------------------------------------------------- Add project lists ---
	def cbFilterSize(self,evt):
		self.sFilterSize = evt.GetSize()
		self.cbFilterSize_aux()
		evt.Skip()

	def cbFilterSize_aux(self):
		try:
			self.project_filters.SetVirtualSizeHints(10,10,-1,self.sFilterSize.GetHeight()-20)
		except:
			pass

	def RegisterPlugins(self):

		self.project_filters.SetScrollRate(10,0)

		self.cListsSizer_Project = wx.BoxSizer(wx.HORIZONTAL)
		#-------------------------- Filters list ---
		label_0 = wx.StaticText(self.project_filters, -1, " Available metric filters")
		self.g_lFilters_Project = wx.CheckListBox(self.project_filters,-1,style=wx.BORDER_SUNKEN)
		self.g_lFilters_Project.SetMinSize((120,-1))

		cFilterListSizer_Project = wx.BoxSizer(wx.VERTICAL)
		cFilterListSizer_Project.Add(label_0, 0, wx.EXPAND, 0)
		cFilterListSizer_Project.Add(self.g_lFilters_Project, 1,wx.EXPAND, 0)

		self.cListsSizer_Project.Add(cFilterListSizer_Project, 0, wx.EXPAND, 0)

		#----------------------- Load plugin GUIs ---
		for i in sta_globals.lPlugins_Project:
			i.buildFilterGUI(self)
		#self.cListsSizer_Project.Fit(self.project_filters)

		self.project_filters.SetSizer(self.cListsSizer_Project)

	#-------------------------------------------------------- Enable project ---
	def enableCurrentPrjButtons(self,l_sw):

		if l_sw:
		   self.g_bPrjClear.Enable(True)
		   self.g_bPrjUpdate.Enable(True)
		else:
		   self.g_bPrjClear.Disable()
		   self.g_bPrjUpdate.Disable()

	#----------------------------------------------------------- Enable file ---
	def enableFileButtons(self,l_sw):

		if l_sw:
			self.g_bFileClear.Enable(True)
			self.g_bFileUpdate.Enable(True)
			self.g_bFileContent.Enable(True)
			self.g_bFileCancel.Disable()

			self.cMenuFileTree.Enable(701,True)
			self.cMenuFileTree.Enable(702,True)
			self.cMenuFileTree.Enable(709,True)
		else:
			self.g_bFileClear.Disable()
			self.g_bFileUpdate.Disable()
			self.g_bFileContent.Disable()
			self.g_bFileCancel.Disable()

			self.cMenuFileTree.Enable(701,False)
			self.cMenuFileTree.Enable(702,False)
			self.cMenuFileTree.Enable(709,False)

	#---------------------------------------------------- Enable file action ---
	def enableActivityButtons(self,l_sw):

		if l_sw:

		   #self.notebook_1.Enable(True)
		   self.notebook_1_pane_filters.Enable(True)
		   self.notebook_1_pane_clusters.Enable(True)
		   self.cMenuFile.Enable(10100,True)
		   self.cMenuFile.Enable(10101,True)
		   self.cMenuFile.Enable(10102,True)
		   self.cMenuFile.Enable(10103,True)
		   self.cMenuSettings.Enable(10800,True)
		   self.cMenuTools.Enable(10700,True)
		   self.cMenuTools.Enable(10701,True)
		   self.g_toolViews.Enable(True)

		   self.g_bFileCancel.Disable()

		   self.g_listFiles.Enable(self.bStatusList[0])
		   self.g_listSelections.Enable(self.bStatusList[1])

		   self.g_bFileClear.Enable(self.bStatusList[2])
		   self.g_bFileUpdate.Enable(self.bStatusList[3])
		   self.g_bFileContent.Enable(self.bStatusList[4])

		   self.g_bPrjClear.Enable(self.bStatusList[5])
		   self.g_bPrjUpdate.Enable(self.bStatusList[6])

		else:

		   self.bStatusList = []

		   self.bStatusList.append(self.g_listFiles.IsEnabled())
		   self.bStatusList.append(self.g_listSelections.IsEnabled())

		   self.bStatusList.append(self.g_bFileClear.IsEnabled())
		   self.bStatusList.append(self.g_bFileUpdate.IsEnabled())
		   self.bStatusList.append(self.g_bFileContent.IsEnabled())

		   self.bStatusList.append(self.g_bPrjClear.IsEnabled())
		   self.bStatusList.append(self.g_bPrjUpdate.IsEnabled())

		   self.g_listFiles.Disable()			# List of files
		   self.g_listSelections.Disable()		# List of selections

		   self.g_bFileClear.Disable()			# Selection clear
		   self.g_bFileUpdate.Disable()			# Selection history update
		   self.g_bFileContent.Disable()		# Selection content update
		   self.g_bPrjClear.Disable()			#
		   self.g_bPrjUpdate.Disable()			#

		   self.notebook_1_pane_filters.Disable()
		   self.notebook_1_pane_clusters.Disable()
		   self.cMenuFile.Enable(10100,False)
		   self.cMenuFile.Enable(10101,False)
		   self.cMenuFile.Enable(10102,False)
		   self.cMenuFile.Enable(10103,False)
		   self.cMenuSettings.Enable(10800,False)
		   self.cMenuTools.Enable(10700,False)
		   self.cMenuTools.Enable(10701,False)
		   self.g_toolViews.Disable()			# Toolbar

# end of class CMainFrame

#////////////////////////////////////////////////////////////////////////////////
#							YesNo Dialog
#////////////////////////////////////////////////////////////////////////////////

class CYesNoDialog(wx.Dialog):
	def __init__(self, l_msg, *args, **kwds):
		# begin wx.Glade: CYesNoDialog.__init__
		kwds["style"] = wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		self.g_dYNText = wx.StaticText(self, -1, l_msg)
		self.g_dYNYes = wx.Button(self, -1, "Yes")
		self.g_dYNNo = wx.Button(self, -1, "No")

		self.g_dYNYes.Bind(wx.EVT_BUTTON,self.OnOK)
		self.g_dYNNo.Bind(wx.EVT_BUTTON,self.OnCancel)

		self.__set_properties()
		self.__do_layout()
		# end wx.Glade

	def __set_properties(self):
		# begin wx.Glade: CYesNoDialog.__set_properties
		pass
		# end wx.Glade

	def __do_layout(self):
		# begin wx.Glade: CYesNoDialog.__do_layout
		sizer_3 = wx.BoxSizer(wx.VERTICAL)
		sizer_5 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_3.Add(self.g_dYNText, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL|wx.FIXED_MINSIZE, 10)
		sizer_5.Add(self.g_dYNYes, 0, wx.ALL|wx.FIXED_MINSIZE, 5)
		sizer_5.Add(self.g_dYNNo, 0, wx.ALL|wx.FIXED_MINSIZE, 5)
		sizer_3.Add(sizer_5, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
		self.SetSizer(sizer_3)
		sizer_3.Fit(self)
		sizer_3.SetSizeHints(self)
		self.Layout()
		# end wx.Glade

	def OnOK(self,event):
		self.EndModal(wx.ID_OK)

	def OnCancel(self,event):
		self.EndModal(wx.ID_CANCEL)

# end of class CYesNoDialog

#////////////////////////////////////////////////////////////////////////////////
#								Info dialog
#////////////////////////////////////////////////////////////////////////////////
class CInfoDialog(wx.Dialog):
	def __init__(self, p_sName ,*args, **kwds):

		kwds["style"] = wx.CAPTION|wx.RESIZE_BORDER
		wx.Dialog.__init__(self, *args, **kwds)

		self.SetTitle(p_sName)

		self.g_tInfo = wx.TextCtrl(self, -1, "", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_RICH2)
		self.g_tInfo.SetMinSize((300,180))
		self.SetSize((300, 180))

		sizer = wx.BoxSizer(wx.VERTICAL)
		sizer.Add(self.g_tInfo, 1, wx.EXPAND|wx.ADJUST_MINSIZE|wx.FIXED_MINSIZE, 0)
		self.SetSizer(sizer)
		sizer.Fit(self)
		sizer.SetSizeHints(self)
		self.Layout()

	def logCommand(self,p_sCmd):
		self.g_tInfo.AppendText(p_sCmd)
