#*****************************************************************************************
# Name			: Bugzilla Integrator
# File			: mextBugzilla.py
# Description	: A plugin for SolidTA intergartion with Bugzilla generated reports 
# Version		: 1.0
# Copyright SolidSource B.V.
#*****************************************************************************************

import wx
import sta_metricgenerator
import os
import subprocess
import sta_utils
import sta_globals

import pysqlite2.dbapi2 as sqlite

#===============================================================================
#											Bug Class
#===============================================================================
class CBug:
	def __init__(self,*args,**kwds):		
		self.sId		=""
		self.sSeverity	=""
		self.sPriority	=""
		self.sPlatform	=""
		self.sUser		=""
		self.sStatus	=""
		self.sResolution=""
		self.sComment	=""
		self.lCommit	=[]	
	 
	def __str__(self):
		sResult = self.sId
		return sResult

#===============================================================================
#												  Bugzilla report extractor
#===============================================================================
class MetricGenerator(sta_metricgenerator.MetricGenerator):
	def __init__(self,*args, **kwds):
		sta_metricgenerator.MetricGenerator.__init__(self,*args, **kwds)
		self.sName				= 'Bug removal activity monitor'
		self.sAuthor			= 'SolidSource'
		self.sVersion			= '1.0'
		self.sTableID			= 'M_SS2007010301'
		self.sTableName			= 'Bug removal activity'
		self.sTableDescription	= 'Version metric.<br />Gives the presence of debugging activity and associated impact/classification.'
		self.sTableDependencies = 'D_SS2007010302'
		
		self.sInfo		= '<strong>Description:</strong><br />'
		self.sInfo		= self.sInfo + 'Extracts debugging activity information from Bugzilla generated reports.<br /><br />'
		
		self.sInfo		= self.sInfo + '<strong>Requires:</strong><br />'
		self.sInfo		= self.sInfo + 'A Buzilla generated report.<br />'
		self.sInfo		= self.sInfo + 'Revision comment recordings (Comments metric).<br /><br />'
		
		self.sInfo		= self.sInfo + '<strong>Output metrics:</strong><br />'
		self.sInfo		= self.sInfo + 'Bug removal activity'
		#----------------------------------------------------------


#===============================================================================
#																	 Generate
#===============================================================================	
	def generate(self,p_sDBPath):
		
		if not sta_utils.isValidDB(p_sDBPath):
			sta_globals.GUI.MainThreadExec('self.logCommand(" ERROR: no history information found\\n")')
			sta_globals.GUI.MainThreadExec('self.postGenerator()')	
			return
		
		cDB = sqlite.connect(p_sDBPath)
		cCursorDB = cDB.cursor()
		#-----------------------------------------------------------------------		
		
		sta_globals.GUI.MainThreadExec('self.cbWorkerFileDialog()')		
		l_sFileName = sta_globals.cWorkersQueue.get()
		if (l_sFileName != ''):
			
			#sta_globals.GUI.mainFrame.Update()
			
			if not sta_utils.isValidTable(cCursorDB,'M_SS2007010102'):
				sta_globals.GUI.MainThreadExec('self.logCommand("ERROR: Could not retrieve revision comment recordings.\\n")')
				cCursorDB.close()
				cDB.close()	 
				return			
			
			if os.path.exists(l_sFileName):
				#--------------------------------------------- Get file size ---
				l_iSize = 0
				fileHandle=open(l_sFileName,'r')
				sLine = fileHandle.readline()				
				while sLine != '':
					l_iSize = l_iSize + 1
					sLine = fileHandle.readline()					
				fileHandle.close()

				#------------------------------------------ Prepare database ---
				if sta_utils.isValidTable(cCursorDB,'D_SS2007010302'):
					sCmd = "drop table D_SS2007010302"
					cCursorDB.execute(sCmd)					
				sCmd = "create table D_SS2007010302(ID integer primary key,Name text,"\
						+ "Severity text,"\
						+ "Priority text,"\
						+ "Platform text,"\
						+ "User text,"\
						+ "Status text,"\
						+ "Resolution text,"\
						+ "Comment text)"
				cCursorDB.execute(sCmd)					
					
				if sta_utils.isValidTable(cCursorDB,'M_SS2007010301'):
					sCmd = "drop table M_SS2007010301"
					cCursorDB.execute(sCmd)
				else:
					sCmdRoot = "insert into Metrics(ID,Name,Type,Description,Dependencies) values ('%s','%s',1,'%s','%s')" 
					sParam = [self.sTableID,self.sTableName,self.sTableDescription,self.sTableDependencies]
					sCmd = sCmdRoot%tuple(sParam)
					cCursorDB.execute(sCmd)	
					
				sCmd = "create table M_SS2007010301(ID integer primary key,"\
						+ "Buglist text)"
				cCursorDB.execute(sCmd)
					
				l_BugList = []
				#------------------------------------- Parse Bugzilla report ---
				fileHandle=open(l_sFileName,'r')
				sLine = fileHandle.readline()
				sLine = fileHandle.readline()
				sLine = sLine.rstrip()
				while sLine != "":			  
					l_lVal = sLine.split(",")
					
					for i in range(7):
						if len(l_lVal[i])>0:
							if (l_lVal[i][0]=='"') and (l_lVal[i][-1]=='"'):
								l_lVal[i] = l_lVal[i][1:]					
								l_lVal[i] = l_lVal[i][:-1]
					
					l_cBug 		= CBug()
					l_cBug.sId 			= l_lVal[0]
					l_cBug.sSeverity 	= l_lVal[1]
					l_cBug.sPriority 	= l_lVal[2]
					l_cBug.sPlatform 	= l_lVal[3]
					l_cBug.sUser 	= l_lVal[4]
					l_cBug.sStatus 	= l_lVal[5]
					l_cBug.sResolution = l_lVal[6]
					for i in range(7,len(l_lVal)):
						l_cBug.sComment = l_cBug.sComment + l_lVal[i]  
						
					if (l_cBug.sComment[0]=='"') and (l_cBug.sComment[-1]=='"'):
						l_cBug.sComment = l_cBug.sComment[1:]					
						l_cBug.sComment = l_cBug.sComment[:-1]
					l_cBug.sComment = l_cBug.sComment.replace('\'','')
					l_cBug.sComment = l_cBug.sComment.replace('"','') 
					
					#--- insert BUG data in database
					sCmdRoot = "insert into D_SS2007010302(ID,Name,Severity,Priority,Platform,User,Status,Resolution,Comment) values (null,'%s','%s','%s','%s','%s','%s','%s','%s')"
					sParam = [l_cBug.sId,l_cBug.sSeverity,l_cBug.sPriority,l_cBug.sPlatform,l_cBug.sUser,l_cBug.sStatus,l_cBug.sResolution,l_cBug.sComment]				
					sCmd = sCmdRoot%tuple(sParam)
					cCursorDB.execute(sCmd)
					l_BugList.append(l_cBug.sId)
					
					sLine = fileHandle.readline()
					sLine = sLine.rstrip()
					
					sta_globals.GUI.MainThreadExec('self.cbGeneratorProgressUpdate()')
					
				fileHandle.close()
				#------------------------------ Build version correspondence ---
				l_iRange = 0
				for i in sta_globals.lSelectedFiles:
					l_iRange = l_iRange + len(i.lRevs)					
				
				sta_globals.GUI.MainThreadExec('self.mainFrame.metrics_cProgress.SetRange($STA$)',lParams=[l_iRange])
				sta_globals.GUI.MainThreadExec('self.mainFrame.metrics_cProgress.SetValue(0)')
				l_iProgress = 0
				
				for i in sta_globals.lSelectedFiles:
					for j in i.lRevs:
						if sta_globals.GUI.bMetricCancel:							
							break
						else:
							sCmd = "select Name from M_SS2007010102 where ID="+str(j.iDBid)
							cCursorDB.execute(sCmd)
							for k in cCursorDB:
								l_sComment = k[0]
								break
							
							l_sLine =''
							for k in range(len(l_BugList)):
								if l_sComment.find(l_BugList[k])>=0:
									l_sLine = l_sLine+str(k+1)+' '
									
							l_sLine = l_sLine.rstrip()
							sCmdRoot = "insert into M_SS2007010301(ID,Buglist) values (%s,'%s')"
							sParam = [j.iDBid,l_sLine]
							sCmd = sCmdRoot%tuple(sParam)
							cCursorDB.execute(sCmd)
						
							l_iProgress = l_iProgress + 1
							sta_globals.GUI.MainThreadExec('self.mainFrame.metrics_cProgress.SetValue($STA$)',lParams=[l_iProgress])
					if sta_globals.GUI.bMetricCancel:							
						break
						
		#-----------------------------------------------------------------------
		# close database
		cDB.commit()
		cCursorDB.close()
		cDB.close()
		
		sta_globals.GUI.MainThreadExec('self.UpdateFiltersList()')
		sta_globals.GUI.MainThreadExec('self.logCommand(" Finished: "+$STA$+" generation completed\\n")',lParams=[self.sName])
		sta_globals.GUI.MainThreadExec('self.postGenerator()')
