#*****************************************************************************************
# File			: pextMethod.py
# Description	: A plugin for visualizing function ID information.
# Version		: 1.0
# Copyright SolidSource B.V.
#*****************************************************************************************

#------------------------------------------------------------ Global imports ---
import wx
from OpenGL.GL import *
from OpenGL.GLUT import *
from OpenGL.GLU import *

import pysqlite2.dbapi2 as sqlite

#------------------------------------------------------------- Local imports ---
import sta_globals
import sta_plugin
import sta_utils
import sta_gl_list
import sta_gl_mixerunit

#===============================================================================
#																Methods plugin
#===============================================================================
class Plugin(sta_plugin.Plugin):

	def __init__(self,*args, **kwds):
		sta_plugin.Plugin.__init__(self,*args, **kwds)
		self.sClass					= 'pextMethod'  # Name of the plugin file
		self.sName					= 'Methods'	 # Name to display in a list
		self.sVersion				= '1.0'		 # Version
		self.sMetricID				= 'MTHD'

		self.sTable					= 'D_SS2007010201_2'  # Name of the table where metric is stored
		self.lTables.append(self.sTable)				# Append to this list all tables that are used

		#----------------------------------------------------- Specific processing

		self.dMethods				= {}		# List of version IDs for every metric
		self.dMethodsMetric_1		= {}		# Number of files for each method
		self.dMethodsMetric_2		= {}		# Time of introduction for each method


#-------------------------------------------------------------------------------
#																 Filter GUI
#-------------------------------------------------------------------------------

#----------------------------------------------------------------- Build GUI ---
	def buildFilterGUI(self,pMasterGUI):

		self.cGUIMaster = pMasterGUI

		self.cSizer = wx.BoxSizer(wx.VERTICAL)

		l_cLabelSizer = wx.BoxSizer(wx.HORIZONTAL)
		l_sLabel = wx.StaticText(pMasterGUI.project_filters, -1, '  '+self.sName)
		self.g_txtMetric = wx.StaticText(pMasterGUI.project_filters, -1, style = wx.ALIGN_RIGHT )
		l_cLabelSizer.Add(l_sLabel, 0, wx.ADJUST_MINSIZE, 0)
		l_cLabelSizer.Add(self.g_txtMetric, 0, wx.ALIGN_RIGHT, 0)

		self.cGUIList = sta_gl_list.wxColorCheckListBox(self.sName,self.sClass,pMasterGUI.project_filters, style=wx.BORDER_SUNKEN|wx.LB_MULTIPLE|wx.LB_SORT)
		self.cGUIList.lObservers.append(self)

		self.cGUIList.SetData(sta_globals.lIDColors)
		self.cGUIList.AddMetric("Number of files",self.MetricNumberOfFiles)
		self.cGUIList.AddMetric("Introduction moment",self.TimeOfIntroduction)

		self.cGUIList.Bind(wx.EVT_LISTBOX,self.cbListSelect)

		self.cSizer.Add(l_cLabelSizer, 0, wx.EXPAND, 0)
		self.cSizer.Add(self.cGUIList, 1, wx.EXPAND|wx.ADJUST_MINSIZE)
		pMasterGUI.cListsSizer_Project.Add(self.cSizer, 0, wx.EXPAND, 0)

		self.cGUIList.SetMinSize((200,-1))

		self.showFilterGUI(False)
		self.doBindings()

#-------------------------------------------------------------------------------
#														 Filter GUI callback
#-------------------------------------------------------------------------------

	def cbListSelect_aux(self, files):

		if len(self.lIdx) == 0:
			for i in files:
				for j in i.lRevs:
					try:
						l_lMethods = j.lValues[self.sMetricID]
						if len(l_lMethods) == 0:
							j.lValues[self.sClass] = -1
						elif len(l_lMethods) > 1:
							j.lValues[self.sClass] = -2
						else:
							j.lValues[self.sClass] = l_lMethods[0]
					except:
						j.lValues[self.sClass]= -1
		else:
			for i in files:
				for j in i.lRevs:
					try:
						j.lValues[self.sClass]= -1
						l_lMethods = j.lValues[self.sMetricID]
						for k in l_lMethods:
							if k in self.lIdx:
								if j.lValues[self.sClass] != -1:
									j.lValues[self.sClass] = -2
								else:
									j.lValues[self.sClass] = k
					except:
						j.lValues[self.sClass]= -1

	def getSelectedIndexes(self):
		l_lMethods = self.cGUIList.GetSelections()
		self.clearSelection()
		for i in l_lMethods:
			self.lIdx.append(self.dMethods[i])
		self.bSelected = len(self.lIdx)>0

#-------------------------------------------------------------------------------
#															Filter GUI metrics
#-------------------------------------------------------------------------------

#--------------------------------------------------------- Number of files ---
	def MetricNumberOfFiles(self,sName):
		return self.dMethodsMetric_1[self.dMethods[sName]]

#--------------------------------------------------------- Number of files ---
	def TimeOfIntroduction(self,sName):
		return self.dMethodsMetric_2[self.dMethods[sName]]

#-------------------------------------------------------------------------------
#																Data management
#-------------------------------------------------------------------------------
#--------------------------------------------------------------- Load metric ---
	def loadMetric(self):

		self.p = 0

		l_sDBPath = sta_globals.cSTAPrj.storagePath()+"/history.db"

		if not sta_utils.isValidDB(l_sDBPath):
			print 'DATA: no history information found'
			return

		cDB = sqlite.connect(l_sDBPath)
		cCursorDB = cDB.cursor()

		if not sta_utils.isValidTable(cCursorDB,self.sTable):
			print 'DATA: no Method information found'
			cCursorDB.close()
			cDB.close()
			return

		#------------------------------- Load list of methods ---

		sCmd = "select distinct(Method) from "+self.sTable
		l_iIdx = 0
		cCursorDB.execute(sCmd)
		for i in cCursorDB:
			l_iIdx = l_iIdx + 1

		sta_globals.GUI.logCommand('Methods filter: '+str(l_iIdx)+' methods found.\n')

		self.lData		   		= range(l_iIdx)
		self.dMethods			= {}
		self.dMethodsMetric_1  	= {}
		self.dMethodsMetric_2  	= {}
		self.cGUIList.SetUpList(l_iIdx)

		sCmd = "select distinct(Method) from "+self.sTable
		l_iIdx = 0
		cCursorDB.execute(sCmd)
		for i in cCursorDB:
			self.cGUIList.SetItem(l_iIdx,i[0],l_iIdx)
			self.lData[l_iIdx] = l_iIdx
			self.dMethods[i[0]] = l_iIdx
			self.dMethodsMetric_1[l_iIdx] = 0
			self.dMethodsMetric_2[l_iIdx] = 0
			l_iIdx = l_iIdx + 1

		#--------------------------------- Load version table ---
		l_lMetric = {}

		sCmd = "select distinct(ID) from "+self.sTable
		cCursorDB.execute(sCmd)
		for i in cCursorDB:
			l_lMetric[i[0]] = []

		sCmd = "select ID,Method from "+self.sTable
		cCursorDB.execute(sCmd)
		for i in cCursorDB:
			l_lMetric[i[0]].append(self.dMethods[i[1]])

		cCursorDB.close()
		cDB.close()
		#-------------------------------------- Assign values ---
		self.clearSelection()

		for i in sta_globals.lFiles:
			l_sMethods = set([])
			l_dMethods = {}
			for j in i.lRevs:
				try:
					l_lMethods = l_lMetric[j.iDBid]
					l_sMethods = l_sMethods.union(set(l_lMethods))
					j.lValues[self.sMetricID] = l_lMethods
					if len(l_lMethods) == 0:
						j.lValues[self.sClass] = -1
					elif len(l_lMethods) > 1:
						j.lValues[self.sClass] = -2
					else:
						j.lValues[self.sClass] = l_lMethods[0]

					for k in l_lMethods:
						if (self.dMethodsMetric_2[k] > j.iTime) or (self.dMethodsMetric_2[k] == 0):
							self.dMethodsMetric_2[k] = j.iTime
				except:
					j.lValues[self.sMetricID]= []
					j.lValues[self.sClass]= -1

			for k in l_sMethods:
				self.dMethodsMetric_1[k] = self.dMethodsMetric_1[k] + 1

		l_lMetric = {}
		l_iMaxTime = max(self.dMethodsMetric_2.values())
		for i in self.dMethodsMetric_2.keys():
			self.dMethodsMetric_2[i] = l_iMaxTime - self.dMethodsMetric_2[i]

		self.cGUIList.Update()
		self.cGUIList.Refresh()

#------------------------------------------------------------- Unload metric ---
	def unloadMetric(self):
		self.dMethods			= {}
		self.dMethodsMetric_1	= {}
		self.dMethodsMetric_2	= {}

		sta_plugin.Plugin.unloadMetric(self)

#===============================================================================
#												Authors filter mixer unit
#===============================================================================
class MixerUnit(sta_gl_mixerunit.MixerUnit):

	def __init__(self, *args, **kwds):
		sta_gl_mixerunit.MixerUnit.__init__(self, *args, **kwds)

		self.iAttrType		= 0
		self.iDrawType		= 0
